/*
 * Decompiled with CFR 0.152.
 */
package javaforce.linux;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.utils.monitordir;

public class DesktopCache
implements monitordir.Listener {
    private static Vector<Desktop> desktops = new Vector();
    private static ArrayList<String> monitors = new ArrayList();

    private static void buildCache(File folder) {
        File[] files = folder.listFiles();
        for (int a = 0; a < files.length; ++a) {
            try {
                if (files[a].isDirectory()) {
                    DesktopCache.buildCache(files[a]);
                    continue;
                }
                String file = files[a].getAbsolutePath();
                if (!file.endsWith(".desktop")) continue;
                FileInputStream fis = new FileInputStream(files[a]);
                byte[] data = JF.readAll(fis);
                String str = new String(data);
                String[] lns = str.split("\n");
                String name = null;
                String icon = null;
                String type = null;
                String exec = null;
                boolean desktopEntry = false;
                for (int b = 0; b < lns.length; ++b) {
                    if (lns[b].startsWith("[Desktop Entry]")) {
                        desktopEntry = true;
                        continue;
                    }
                    if (lns[b].startsWith("[")) {
                        desktopEntry = false;
                    }
                    if (!desktopEntry) continue;
                    if (lns[b].startsWith("Name=")) {
                        name = lns[b].substring(5);
                        continue;
                    }
                    if (lns[b].startsWith("Icon=")) {
                        icon = lns[b].substring(5);
                        continue;
                    }
                    if (lns[b].startsWith("Type=")) {
                        type = lns[b].substring(5);
                        continue;
                    }
                    if (!lns[b].startsWith("Exec=")) continue;
                    exec = lns[b].substring(5);
                }
                if (name == null || icon == null || type == null || !type.equals("Application")) continue;
                boolean exists = false;
                for (int b = 0; b < desktops.size(); ++b) {
                    if (!DesktopCache.desktops.get((int)b).name.equals(name)) continue;
                    exists = true;
                    break;
                }
                if (exists) continue;
                Desktop app = new Desktop();
                app.icon = icon;
                app.name = name;
                app.file = file;
                app.exec = exec;
                app.all = str.toLowerCase();
                desktops.add(app);
                continue;
            }
            catch (Exception e) {
                JFLog.log(e);
            }
        }
    }

    public static synchronized void buildCache() {
        File file2;
        File file1 = new File("/usr/share/applications");
        if (file1.exists() && file1.isDirectory()) {
            DesktopCache.buildCache(file1);
            DesktopCache.monitorDir(file1);
        }
        if ((file2 = new File(JF.getUserPath() + "/.local/share/applications")).exists() && file2.isDirectory()) {
            DesktopCache.buildCache(file2);
            DesktopCache.monitorDir(file2);
        }
    }

    private static synchronized void monitorDir(File folder) {
        String fullpath = folder.getAbsolutePath();
        for (int a = 0; a < monitors.size(); ++a) {
            if (!monitors.get(a).equals(fullpath)) continue;
            return;
        }
        if (!monitordir.init()) {
            JFLog.log("DesktopCache:Error:Could not init monitordir");
        }
        int wd = monitordir.add(fullpath);
        monitordir.setListener(wd, new DesktopCache());
        monitors.add(fullpath);
    }

    private static String readFile(String file) {
        try {
            int read;
            FileInputStream fis = new FileInputStream(file);
            byte[] data = new byte[1024];
            int pos = 0;
            while ((read = fis.read(data, pos, 1024 - pos)) > 0 && (pos += read) < 1024) {
            }
            fis.close();
            return new String(data, 0, pos);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static boolean isInterpreter(String cmd) {
        if (cmd.equals("bash")) {
            return true;
        }
        if (cmd.equals("wine")) {
            return true;
        }
        return cmd.equals("python");
    }

    public static String getDesktopFromPID(int pid) {
        if (pid == -1) {
            return null;
        }
        try {
            String cmdline = DesktopCache.readFile("/proc/" + pid + "/cmdline");
            if (cmdline == null) {
                return null;
            }
            String[] args = cmdline.split(new String(new char[]{'\u0000'}));
            String stat = DesktopCache.readFile("/proc/" + pid + "/stat");
            if (stat == null) {
                return null;
            }
            String[] stats = stat.split(" ");
            int ppid = JF.atoi(stats[3]);
            String cmd = args[0];
            int idx = cmd.lastIndexOf(47);
            if (idx != -1) {
                cmd = cmd.substring(idx + 1);
            }
            if (DesktopCache.isInterpreter(cmd) && (idx = (cmd = args[1]).lastIndexOf(47)) != -1) {
                cmd = cmd.substring(idx + 1);
            }
            if (cmd.equals("java")) {
                if (ppid > 0) {
                    return DesktopCache.getDesktopFromPID(ppid);
                }
                return null;
            }
            return DesktopCache.getDesktopFromExec(cmd);
        }
        catch (Exception e) {
            JFLog.log(e);
            return null;
        }
    }

    public static String getDesktopFromExec(String exec) {
        for (int a = 0; a < desktops.size(); ++a) {
            Desktop app = desktops.get(a);
            String appExec = app.exec;
            int idx = appExec.lastIndexOf(47);
            if (idx != -1) {
                appExec = appExec.substring(idx + 1);
            }
            if (!appExec.equalsIgnoreCase(exec)) continue;
            return app.file;
        }
        return null;
    }

    public static String getDesktopFromText(String text) {
        int idx = (text = text.toLowerCase()).indexOf(32);
        if (idx != -1) {
            text = text.substring(0, idx);
        }
        if ((idx = text.indexOf(45)) != -1) {
            text = text.substring(0, idx);
        }
        if ((idx = text.indexOf(47)) != -1) {
            text = text.substring(0, idx);
        }
        if ((idx = text.indexOf(126)) != -1) {
            text = text.substring(0, idx);
        }
        for (int a = 0; a < desktops.size(); ++a) {
            Desktop app = desktops.get(a);
            if (app.all.indexOf(text) == -1) continue;
            return app.file;
        }
        return null;
    }

    public static List<Desktop> getList() {
        return desktops;
    }

    @Override
    public void folderChangeEvent(String event, String path) {
        DesktopCache.buildCache();
    }

    public static class Desktop {
        public String icon;
        public String file;
        public String name;
        public String exec;
        public String all;
    }
}

