/*
 * Decompiled with CFR 0.152.
 */
package javaforce.service;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import javaforce.BE;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.KeyMgmt;

public class FileSyncServer {
    private static boolean debug;
    private String passwd;
    private String root;
    private Server server;
    private Object lock = new Object();
    private ServerSocket ss;
    private ArrayList<Client> clients = new ArrayList();
    private static final byte REQ_AUTH = 1;
    private static final byte REQ_FOLDER_OPEN = 2;
    private static final byte REQ_FILE_OPEN = 3;
    private static final byte REQ_FILE_BLOCK_HASH = 4;
    private static final byte REQ_FILE_BLOCK_DATA = 5;
    private static final byte REQ_FILE_TRUNCATE = 6;
    private static final byte REQ_FILE_DELETE = 7;
    private static final byte REQ_FOLDER_LIST = 16;
    private static final byte RET_OKAY = -1;
    private static final byte RET_NO_EXIST = -2;
    private static final byte RET_NO_CHANGE = -3;
    private static final byte RET_CHANGE = -4;
    private static final int max_passwd_len = 256;
    private static final int max_data_len = 0x100000;

    public FileSyncServer(String passwd, String root) {
        this.passwd = passwd;
        this.root = root;
    }

    private static String getKeyFile() {
        return JF.getConfigPath() + "/jffilesync.key";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addClient(Client client) {
        Object object = this.lock;
        synchronized (object) {
            this.clients.add(client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeClient(Client client) {
        Object object = this.lock;
        synchronized (object) {
            this.clients.remove(client);
        }
    }

    public void start() {
        this.stop();
        this.server = new Server();
        this.server.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.server == null) {
            return;
        }
        this.server.active = false;
        Object object = this.lock;
        synchronized (object) {
            Client[] cs;
            for (Client c : cs = this.clients.toArray(new Client[0])) {
                c.close();
            }
            this.clients.clear();
        }
        object = this.server;
        synchronized (object) {
            this.server.notify();
        }
        this.server = null;
    }

    private class Server
    extends Thread {
        public boolean active;

        private Server() {
        }

        @Override
        public void run() {
            this.active = true;
            JFLog.append(JF.getLogPath() + "/jffilesync.log", true);
            JFLog.setRetention(30);
            JFLog.log("FileSync : Starting service");
            JFLog.log("CreateServerSocketSSL");
            KeyMgmt keys = new KeyMgmt();
            if (new File(FileSyncServer.getKeyFile()).exists()) {
                try {
                    FileInputStream fis = new FileInputStream(FileSyncServer.getKeyFile());
                    keys.open(fis, "password");
                    fis.close();
                }
                catch (Exception e) {
                    JFLog.log(e);
                }
            } else {
                JFLog.log("Warning:Server SSL Keys not generated!");
                return;
            }
            FileSyncServer.this.ss = JF.createServerSocketSSL(keys);
            try {
                while (this.active) {
                    Socket s = FileSyncServer.this.ss.accept();
                    Client client = new Client(s);
                    FileSyncServer.this.addClient(client);
                    client.start();
                }
            }
            catch (Exception e) {
                JFLog.log(e);
            }
        }
    }

    private class Client
    extends Thread {
        public String remote;
        private Socket s;
        private InputStream is;
        private OutputStream os;
        private boolean active;
        private byte[] data = new byte[0x100000];
        private String folder;

        public Client(Socket s) {
            this.s = s;
            this.remote = s.getInetAddress().toString();
        }

        @Override
        public void run() {
            block15: {
                this.active = true;
                try {
                    this.is = this.s.getInputStream();
                    this.os = this.s.getOutputStream();
                    int auth_cmd = this.is.read();
                    if (auth_cmd == -1) {
                        throw new Exception("read error");
                    }
                    if (auth_cmd != 1) {
                        throw new Exception("auth not received");
                    }
                    int read = this.is.readNBytes(this.data, 0, 4);
                    if (read != 4) {
                        throw new Exception("read error");
                    }
                    int length = BE.getuint32(this.data, 0);
                    if (length > 256) {
                        throw new Exception("passwd too long");
                    }
                    read = this.is.readNBytes(this.data, 0, length);
                    if (read != length) {
                        throw new Exception("passwd not received");
                    }
                    String auth_passwd_str = new String(this.data);
                    if (!FileSyncServer.this.passwd.equals(auth_passwd_str)) {
                        throw new Exception("access denied");
                    }
                    if (this.active) {
                        int cmd = this.is.read();
                        if (cmd == -1) {
                            throw new Exception("read error");
                        }
                        read = this.is.readNBytes(this.data, 0, 4);
                        if (read != 4) {
                            throw new Exception("read error");
                        }
                        length = BE.getuint32(this.data, 0);
                        if (length > 0x100000) {
                            throw new Exception("data packet too big");
                        }
                        read = this.is.readNBytes(this.data, 0, length);
                        if (read != length) {
                            throw new Exception("read data error");
                        }
                        switch (cmd) {
                            default: 
                        }
                        throw new Exception("unknown cmd");
                    }
                }
                catch (Exception e) {
                    if (!debug) break block15;
                    JFLog.log(e);
                }
            }
            this.close();
            FileSyncServer.this.removeClient(this);
        }

        public void close() {
            this.active = false;
            try {
                this.s.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

