/*
 * Decompiled with CFR 0.152.
 */
package javaforce.vm;

import java.io.File;
import java.io.Serializable;
import javaforce.ShellProcess;
import javaforce.vm.Size;
import javaforce.vm.Storage;

public class Disk
implements Serializable {
    private static final long serialVersionUID = 1L;
    public String pool;
    public String folder;
    public String name;
    public int type;
    public Size size;
    public int boot_order;
    public String target_dev = "sd%c";
    public String target_bus = "auto";
    public static final int TYPE_VMDK = 0;
    public static final int TYPE_QCOW2 = 1;
    public static final int TYPE_ISO = 2;
    public static final int PROVISION_THICK = 0;
    public static final int PROVISION_THIN = 1;

    public String getType() {
        switch (this.type) {
            case 1: {
                return "qcow2";
            }
            case 0: {
                return "vmdk";
            }
            case 2: {
                return "iso";
            }
        }
        return "";
    }

    public static int getType(String ext) {
        switch (ext) {
            case "qcow2": {
                return 1;
            }
            case "vmdk": {
                return 0;
            }
            case "iso": {
                return 2;
            }
        }
        return -1;
    }

    public String getFolder() {
        return "/volumes/" + this.pool + "/" + this.folder;
    }

    public String getPath() {
        return "/volumes/" + this.pool + "/" + this.folder + "/" + this.name + "." + this.getType();
    }

    public String getSnapshotPath(String ssname) {
        return "/volumes/" + this.pool + "/" + this.folder + "/" + this.name + "-" + ssname + ".qcow2";
    }

    public String getPath(String pool) {
        return "/volumes/" + pool + "/" + this.folder + "/" + this.name + "." + this.getType();
    }

    public boolean exists() {
        return new File(this.getPath()).exists();
    }

    public boolean exists(String pool) {
        return new File(this.getPath(pool)).exists();
    }

    private String getPath2() {
        String flat;
        if (this.type == 0 && new File(flat = "/volumes/" + this.pool + "/" + this.folder + "/" + this.name + "-flat." + this.getType()).exists()) {
            return flat;
        }
        return "/volumes/" + this.pool + "/" + this.folder + "/" + this.name + "." + this.getType();
    }

    private static native boolean ncreate(String var0, String var1);

    public boolean create(int provision) {
        new File(this.getFolder()).mkdirs();
        ShellProcess sp = new ShellProcess();
        switch (this.type) {
            case 0: {
                String subformat = "";
                switch (provision) {
                    case 0: {
                        subformat = "monolithicFlat";
                        break;
                    }
                    default: {
                        subformat = "monolithicSparse";
                    }
                }
                sp.run(new String[]{"/usr/bin/qemu-img", "create", "-f", this.getType(), "-o", "subformat=" + subformat, this.getPath(), this.size.getSize()}, true);
                break;
            }
            case 1: {
                String preallocation = "";
                switch (provision) {
                    case 0: {
                        preallocation = "metadata";
                        break;
                    }
                    default: {
                        preallocation = "off";
                    }
                }
                sp.run(new String[]{"/usr/bin/qemu-img", "create", "-f", this.getType(), "-o", "preallocation=" + preallocation, this.getPath(), this.size.getSize()}, true);
                break;
            }
        }
        return sp.getErrorLevel() == 0;
    }

    public boolean resize(Storage pool) {
        ShellProcess sp = new ShellProcess();
        switch (this.type) {
            case 0: {
                sp.run(new String[]{"/usr/bin/qemu-img", "resize", this.getPath(), this.size.getSize()}, true);
                break;
            }
            case 1: {
                sp.run(new String[]{"/usr/bin/qemu-img", "resize", this.getPath(), this.size.getSize()}, true);
            }
        }
        return sp.getErrorLevel() == 0;
    }

    private String getDeviceType() {
        switch (this.type) {
            case 2: {
                return "cdrom";
            }
        }
        return "disk";
    }

    public String getHardwareXML(int os) {
        StringBuilder xml2 = new StringBuilder();
        String _dev = this.target_dev;
        String _bus = this.target_bus;
        if (this.target_bus == null || this.target_bus.equals("auto")) {
            _bus = os == 1 ? "sata" : "scsi";
        }
        xml2.append("<disk type='file' device='" + this.getDeviceType() + "'>");
        xml2.append("<source file='" + this.getPath2() + "'>");
        xml2.append("</source>");
        xml2.append("<target dev='" + _dev + "' bus='" + _bus + "'/>");
        if (this.boot_order > 0) {
            xml2.append("<boot order='" + this.boot_order + "'/>");
        }
        xml2.append("</disk>");
        return xml2.toString();
    }

    private String getCreateXML(int provision) {
        StringBuilder xml2 = new StringBuilder();
        xml2.append("<volume type='file'>");
        xml2.append("<name>" + this.name + "</name>");
        xml2.append("<allocation unit='" + this.size.getUnitChar() + "iB'>");
        switch (provision) {
            case 0: {
                xml2.append(this.size.size);
                break;
            }
            case 1: {
                xml2.append("0");
            }
        }
        xml2.append("</allocation>");
        xml2.append("<capacity unit='" + this.size.getUnitChar() + "iB'>");
        xml2.append(this.size.size);
        xml2.append("</capacity>");
        xml2.append("<target>");
        xml2.append("<path>" + this.getPath() + "</path>");
        xml2.append("<format type='" + this.getType() + "'/>");
        xml2.append("</target>");
        xml2.append("</volume>");
        return xml2.toString();
    }

    public String toString() {
        if (this.type == 2) {
            return this.name + ":iso";
        }
        return this.name + ":" + this.size.toString();
    }
}

