/*
 * Decompiled with CFR 0.152.
 */
package javaforce.vm;

import java.io.Serializable;
import java.util.ArrayList;
import javaforce.ShellProcess;
import javaforce.vm.NetworkConfig;

public class NetworkBridge
extends NetworkConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    public String type;
    public String iface;
    public static final int TYPE_OS = 1;
    public static final int TYPE_BR = 2;
    public static final int TYPE_ALL = 3;

    protected NetworkBridge(String name, String type, String iface) {
        super(name);
        this.type = type;
        this.iface = iface;
    }

    private static NetworkBridge[] list_br() {
        ShellProcess p = new ShellProcess();
        p.keepOutput(true);
        String output = p.run(new String[]{"/usr/sbin/brctl", "show"}, true);
        if (output == null) {
            return null;
        }
        String[] lns = output.split("\n");
        ArrayList<NetworkBridge> list = new ArrayList<NetworkBridge>();
        for (int a = 1; a < lns.length; ++a) {
            String[] fs;
            if (lns[a].length() == 0 || (fs = lns[a].split("\t+", -1)).length < 4) continue;
            String br = fs[0];
            String nic = fs[3];
            list.add(new NetworkBridge(br, "br", nic));
        }
        return list.toArray(new NetworkBridge[0]);
    }

    private static NetworkBridge[] list_os() {
        ShellProcess p = new ShellProcess();
        p.keepOutput(true);
        String output = p.run(new String[]{"/usr/bin/ovs-vsctl", "show"}, true);
        if (output == null) {
            return null;
        }
        String[] lns = output.split("\n");
        ArrayList<NetworkBridge> list = new ArrayList<NetworkBridge>();
        String br = null;
        String nic = null;
        boolean tag = false;
        for (int a = 1; a < lns.length; ++a) {
            String ln = lns[a].trim();
            if (ln.length() == 0) continue;
            if (ln.startsWith("Bridge ")) {
                tag = false;
                br = ln.substring(7);
                continue;
            }
            if (ln.startsWith("Port ")) {
                tag = false;
                continue;
            }
            if (ln.startsWith("tag:")) {
                tag = true;
            }
            if (!ln.startsWith("Interface ") || br == null || tag || (nic = ln.substring(10)).equals(br) || nic.startsWith("vnet")) continue;
            list.add(new NetworkBridge(br, "os", nic));
            br = null;
            nic = null;
            tag = false;
        }
        return list.toArray(new NetworkBridge[0]);
    }

    public static NetworkBridge[] list() {
        return NetworkBridge.list(3);
    }

    public static NetworkBridge[] list(int flags) {
        int a;
        NetworkBridge[] list;
        ArrayList<NetworkBridge> list_all = new ArrayList<NetworkBridge>();
        if ((flags & 2) != 0 && (list = NetworkBridge.list_br()) != null) {
            for (a = 0; a < list.length; ++a) {
                list_all.add(list[a]);
            }
        }
        if ((flags & 1) != 0 && (list = NetworkBridge.list_os()) != null) {
            for (a = 0; a < list.length; ++a) {
                list_all.add(list[a]);
            }
        }
        return list_all.toArray(new NetworkBridge[0]);
    }

    public static NetworkBridge create(String name, String iface) {
        ShellProcess p = new ShellProcess();
        p.keepOutput(true);
        p.run(new String[]{"/usr/bin/ovs-vsctl", "add-br", name}, true);
        p = new ShellProcess();
        p.keepOutput(true);
        p.run(new String[]{"/usr/bin/ovs-vsctl", "add-port", name, iface}, true);
        NetworkBridge nic = new NetworkBridge(name, "os", iface);
        nic.link_up();
        return nic;
    }

    private void remove_br() {
        ShellProcess p = new ShellProcess();
        p.keepOutput(true);
        p.run(new String[]{"/usr/sbin/brctl", "delbr", this.name}, true);
    }

    private void remove_os() {
        ShellProcess p = new ShellProcess();
        p.keepOutput(true);
        p.run(new String[]{"/usr/bin/ovs-vsctl", "del-br", this.name}, true);
    }

    public boolean remove() {
        switch (this.type) {
            case "br": {
                this.remove_br();
                break;
            }
            case "os": {
                this.remove_os();
            }
        }
        return true;
    }
}

