/*
 * Decompiled with CFR 0.152.
 */
package javaforce.webui;

import javaforce.webui.Image;
import javaforce.webui.Resource;
import javaforce.webui.TextComponent;

public class Button
extends TextComponent {
    private String url;
    private Image img;

    public Button(String text) {
        this.text = text;
        this.setClass("button");
    }

    public Button(Resource img) {
        this.img = new Image(img);
        this.add(this.img);
        this.setClass("button");
    }

    public Button(Resource img, String text) {
        this.img = new Image(img);
        this.add(this.img);
        this.text = text;
        this.setClass("button");
    }

    @Override
    public String html() {
        if (this.img != null && this.text == null) {
            return this.img.html();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<button" + this.getAttrs() + ">");
        if (this.img != null) {
            sb.append(this.img.html());
        }
        if (this.text != null) {
            sb.append(this.text);
        }
        sb.append("</button>");
        return sb.toString();
    }

    @Override
    public void updateText(String text) {
        this.sendEvent("settext", new String[]{"text=" + text});
    }

    public void setURL(String url) {
        this.addEvent("onclick", "window.open(\"" + url + "\");");
        this.url = url;
    }

    public String getURL() {
        return this.url;
    }

    public void setImage(Resource img) {
        this.img.setImage(img);
    }
}

