/*
 * Decompiled with CFR 0.152.
 */
package javaforce;

public class JFProfiler {
    private long[] ms;
    private String[] names;
    private int step;
    private String name;
    private StringBuilder sb = new StringBuilder();

    public JFProfiler(String name, int steps) {
        this.name = name;
        this.ms = new long[++steps];
        this.names = new String[steps];
    }

    public void start() {
        this.ms[0] = System.currentTimeMillis();
        this.step = 1;
    }

    public void step(String name) {
        this.ms[this.step] = System.currentTimeMillis();
        this.names[this.step] = name;
        ++this.step;
    }

    public void stop() {
        this.sb.setLength(0);
        this.sb.append(this.name);
        this.sb.append(":");
        for (int i = 1; i < this.step; ++i) {
            long delta = this.ms[i] - this.ms[i - 1];
            this.sb.append(String.format("%02dms=(%s) ", delta, this.names[i]));
        }
        System.out.println(this.sb.toString());
    }
}

