/*
 * Decompiled with CFR 0.152.
 */
package javaforce.awt;

import java.awt.Component;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.awt.JFImage;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class JTrayIcon
extends TrayIcon {
    private static final boolean debug = false;
    private int count;

    public JTrayIcon(Image image, String tooltip, final JPopupMenu menu) {
        super(image, tooltip);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 3) {
                    JTrayIcon.this.count = 0;
                    menu.show(null, e.getXOnScreen(), e.getYOnScreen());
                }
            }
        });
        menu.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                --JTrayIcon.this.count;
                if (JTrayIcon.this.count == 0 && !JTrayIcon.this.inside(menu, e.getXOnScreen(), e.getYOnScreen())) {
                    menu.setVisible(false);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                ++JTrayIcon.this.count;
            }
        });
        int cnt = menu.getComponentCount();
        for (int a = 0; a < cnt; ++a) {
            Component child = menu.getComponent(a);
            child.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseExited(MouseEvent e) {
                    --JTrayIcon.this.count;
                    if (JTrayIcon.this.count == 0 && !JTrayIcon.this.inside(menu, e.getXOnScreen(), e.getYOnScreen())) {
                        menu.setVisible(false);
                    }
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    ++JTrayIcon.this.count;
                }
            });
        }
    }

    private boolean inside(JPopupMenu menu, int x, int y) {
        Point pt = menu.getLocationOnScreen();
        Rectangle r = menu.getBounds();
        int x1 = pt.x;
        int x2 = x1 + r.width;
        int y1 = pt.y;
        int y2 = y1 + r.height;
        if (x < x1 || x > x2) {
            return false;
        }
        return y >= y1 && y <= y2;
    }

    public static void main(String[] args) {
        JFImage img = new JFImage();
        img.loadPNG(JF.class.getResourceAsStream("/javaforce/icons/javaforce.png"));
        JFImage img16 = new JFImage(16, 16);
        img16.putJFImageScale(img, 0, 0, 15, 15);
        JPopupMenu menu = new JPopupMenu();
        JMenuItem item1 = new JMenuItem("item1");
        item1.addActionListener(e -> JFLog.log("item1"));
        menu.add(item1);
        JMenuItem item2 = new JMenuItem("item2");
        item2.addActionListener(e -> JFLog.log("item2"));
        menu.add(item2);
        JMenuItem item3 = new JMenuItem("item3");
        item3.addActionListener(e -> JFLog.log("item3"));
        menu.add(item3);
        JTrayIcon icon = new JTrayIcon(img16.getImage(), "test", menu);
        try {
            SystemTray.getSystemTray().add(icon);
        }
        catch (Exception e2) {
            JFLog.log(e2);
        }
    }
}

