/*
 * Decompiled with CFR 0.152.
 */
package javaforce.awt;

import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.awt.JFAWT;
import javaforce.awt.ViewLog;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;

public class ViewJFLog
extends JDialog {
    private JButton close;
    private JComboBox<String> historyFile;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JScrollPane jScrollPane1;
    private JComboBox<String> logFile;
    private JTextArea txt;
    public boolean isClosed = false;
    private ArrayList<Integer> ids = new ArrayList();

    public ViewJFLog() {
        super((Frame)null, true);
        this.initComponents();
        this.init();
    }

    private void init() {
        int[] _ids;
        JFAWT.centerWindow(this);
        this.ids.clear();
        this.logFile.removeAllItems();
        for (int id : _ids = JFLog.getIDs()) {
            String name = JFLog.getLogFileName(id);
            this.ids.add(id);
            this.logFile.addItem(name);
        }
        this.historyFile.removeAllItems();
    }

    private void initComponents() {
        this.close = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.txt = new JTextArea();
        this.jLabel1 = new JLabel();
        this.logFile = new JComboBox();
        this.jLabel2 = new JLabel();
        this.historyFile = new JComboBox();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ViewJFLog.this.formWindowClosing(evt);
            }
        });
        this.close.setText("Close");
        this.close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ViewJFLog.this.closeActionPerformed(evt);
            }
        });
        this.txt.setEditable(false);
        this.txt.setColumns(20);
        this.txt.setRows(5);
        this.jScrollPane1.setViewportView(this.txt);
        this.jLabel1.setText("Log File");
        this.logFile.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ViewJFLog.this.logFileItemStateChanged(evt);
            }
        });
        this.jLabel2.setText("Rotation");
        this.historyFile.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ViewJFLog.this.historyFileItemStateChanged(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.close)).addComponent(this.jScrollPane1, -1, 498, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.logFile, 0, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.historyFile, 0, -1, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.logFile, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.historyFile, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 361, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.close).addContainerGap()));
        this.pack();
    }

    private void closeActionPerformed(ActionEvent evt) {
        this.isClosed = true;
        this.dispose();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.isClosed = true;
    }

    private void logFileItemStateChanged(ItemEvent evt) {
        this.loadLog();
    }

    private void historyFileItemStateChanged(ItemEvent evt) {
        this.loadHistory();
    }

    public static void main(String[] args) {
        final String file = args[0];
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new ViewLog(new File(file)).setVisible(true);
            }
        });
    }

    private void clear() {
        this.txt.setText("");
    }

    private void set(String log) {
        this.txt.setText(log);
    }

    private void loadLog() {
        try {
            int idx = this.logFile.getSelectedIndex();
            if (idx == -1) {
                return;
            }
            this.clear();
            String file = (String)this.logFile.getSelectedItem();
            int id = this.ids.get(idx);
            String log = new String(JF.readFile(file), "UTF-8");
            this.set(log);
            this.updateHistory(id);
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    private void loadHistory() {
        try {
            int idx = this.historyFile.getSelectedIndex();
            if (idx == -1) {
                return;
            }
            this.clear();
            String file = (String)this.historyFile.getSelectedItem();
            String log = new String(JF.readFile(file), "UTF-8");
            this.set(log);
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    private void updateHistory(int id) {
        try {
            File[] files;
            this.historyFile.removeAllItems();
            for (File file : files = JFLog.getFiles(id)) {
                this.historyFile.addItem(file.getAbsolutePath());
            }
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }
}

