/*
 * Decompiled with CFR 0.152.
 */
package javaforce.webui;

import javaforce.webui.Button;
import javaforce.webui.Color;
import javaforce.webui.Container;
import javaforce.webui.Label;
import javaforce.webui.Pad;
import javaforce.webui.PopupPanel;

public class TitleBar
extends Container {
    private Label label;
    private Button button;
    private Pad pad;
    private PopupPanel panel;
    private Runnable onClose;

    public TitleBar(String title, PopupPanel panel) {
        this.panel = panel;
        this.setClass("titlebar");
        this.label = new Label(title);
        this.label.addClass("defaultcursor");
        this.label.addClass("noselect");
        this.label.setColor(Color.white);
        this.add(this.label);
        this.pad = new Pad();
        this.add(this.pad);
        this.button = new Button("X");
        this.button.addClass("right");
        this.add(this.button);
        this.button.addClickListener((e, c) -> {
            if (this.onClose != null) {
                this.onClose.run();
            } else {
                panel.setVisible(false);
            }
        });
    }

    @Override
    public void init() {
        super.init();
        this.addEvent("onmousedown", "onmousedownPopupPanel(event, " + this.panel.id + ");");
    }

    public void setOnClose(Runnable onClose) {
        this.onClose = onClose;
    }

    @Override
    public void setHeight(int h) {
        super.setHeight(h);
        this.label.setHeight(h);
        this.button.setWidth(h);
        this.button.setHeight(h);
    }

    public void setText(String title) {
        this.label.setText(title);
    }
}

