/*
 * Decompiled with CFR 0.152.
 */
package javaforce.controls.jfc;

import java.util.Arrays;
import javaforce.LE;
import javaforce.controls.jfc.JFTag;

public class JFPacket {
    public static JFTag decodeAddress(String name) {
        return new JFTag(name);
    }

    public static byte[] makeWritePacket(JFTag tag, byte[] tagdata) {
        int strlen = tag.tag.length();
        byte[] data = new byte[11 + strlen + 2 + 2 + tagdata.length];
        LE.setuint16(data, 0, 4);
        LE.setuint16(data, 2, 4660);
        LE.setuint32(data, 4, 2 + strlen);
        LE.setuint16(data, 8, 1);
        LE.setuint8(data, 10, strlen);
        System.arraycopy(tag.tag.getBytes(), 0, data, 11, strlen);
        int pos = 11 + strlen;
        LE.setuint16(data, pos, tag.type);
        LE.setuint16(data, pos += 2, tagdata.length);
        System.arraycopy(tagdata, 0, data, pos += 2, tagdata.length);
        return data;
    }

    public static byte[] makeReadPacket(JFTag tag) {
        int strlen = tag.tag.length();
        byte[] data = new byte[11 + strlen];
        LE.setuint16(data, 0, 3);
        LE.setuint16(data, 2, 4660);
        LE.setuint32(data, 4, 2 + strlen);
        LE.setuint16(data, 8, 1);
        LE.setuint8(data, 10, strlen);
        System.arraycopy(tag.tag.getBytes(), 0, data, 11, strlen);
        return data;
    }

    public static byte[] makeReadPacket(JFTag[] tags) {
        int size = 10;
        for (int a = 0; a < tags.length; ++a) {
            int strlen = tags[a].tag.length();
            size += 1 + strlen;
        }
        byte[] data = new byte[size];
        LE.setuint16(data, 0, 3);
        LE.setuint16(data, 2, 4660);
        LE.setuint32(data, 4, size - 8);
        LE.setuint16(data, 8, tags.length);
        int pos = 12;
        for (int a = 0; a < tags.length; ++a) {
            int strlen = tags[a].tag.length();
            LE.setuint8(data, pos, strlen);
            System.arraycopy(tags[a].tag.getBytes(), 0, data, ++pos, strlen);
            pos += strlen;
        }
        return data;
    }

    public static byte[] makeWritePacket(JFTag[] tags, byte[][] tagdata) {
        int size = 10;
        for (int a = 0; a < tags.length; ++a) {
            int strlen = tags[a].tag.length();
            size += 1 + strlen;
            size += tagdata[a].length;
        }
        byte[] data = new byte[size];
        LE.setuint16(data, 0, 4);
        LE.setuint16(data, 2, 4660);
        LE.setuint32(data, 4, size - 8);
        LE.setuint16(data, 8, tags.length);
        int pos = 12;
        for (int a = 0; a < tags.length; ++a) {
            int strlen = tags[a].tag.length();
            LE.setuint8(data, pos, strlen);
            System.arraycopy(tags[a].tag.getBytes(), 0, data, ++pos, strlen);
            LE.setuint16(data, pos += strlen, tags[a].type);
            LE.setuint16(data, pos += 2, tagdata[a].length);
            System.arraycopy(tagdata[a], 0, data, pos += 2, tagdata[a].length);
            pos += tagdata[a].length;
        }
        return data;
    }

    public static boolean isPacketComplete(byte[] data) {
        if (data.length < 8) {
            return false;
        }
        int len = LE.getuint32(data, 4);
        return data.length >= 8 + len;
    }

    public static JFTag decodePacket(byte[] data) {
        int cmd = LE.getuint16(data, 0);
        int id = LE.getuint16(data, 2);
        int len = LE.getuint32(data, 4);
        int cnt = LE.getuint16(data, 8);
        if (cnt != 1) {
            return null;
        }
        int type = LE.getuint16(data, 10);
        int size = LE.getuint16(data, 12);
        int datalen = len - 6;
        JFTag tag = new JFTag(null);
        tag.data = Arrays.copyOfRange(data, 12, 12 + datalen);
        return tag;
    }

    public static JFTag[] decodeMultiPacket(byte[] data, int tagcnt) {
        int cmd = LE.getuint16(data, 0);
        int id = LE.getuint16(data, 2);
        int len = LE.getuint32(data, 4);
        int cnt = LE.getuint16(data, 8);
        if (cnt != tagcnt) {
            return null;
        }
        JFTag[] tags = new JFTag[tagcnt];
        int pos = 10;
        for (int a = 0; a < tagcnt; ++a) {
            tags[a] = new JFTag(null);
            int type = LE.getuint16(data, pos);
            int datalen = LE.getuint16(data, pos += 2);
            JFTag tag = new JFTag(null);
            tag.data = Arrays.copyOfRange(data, pos += 2, pos + datalen);
            pos += datalen;
        }
        return tags;
    }
}

