/*
 * Decompiled with CFR 0.152.
 */
package javaforce.controls.s7;

import javaforce.BE;
import javaforce.JFLog;
import javaforce.controls.s7.S7Data;

public class S7Params {
    public byte func;
    public byte[] funcData;
    public static final byte READ = 4;
    public static final byte WRITE = 5;
    public static final byte CONNECT = -16;
    private static final byte TT_UNKNOWN = 0;
    private static final byte TT_BIT = 3;
    private static final byte TT_UINT = 4;
    private static final byte TT_SINT = 5;
    private static final byte TT_REAL = 7;
    private static final byte TT_CHAR = 9;

    public void makeConnect() {
        this.func = (byte)-16;
        this.funcData = new byte[7];
        this.funcData[0] = 1;
        this.funcData[1] = 0;
        this.funcData[2] = 1;
        this.funcData[3] = 1;
        this.funcData[4] = 1;
        this.funcData[5] = 1;
        this.funcData[6] = -32;
    }

    public void makeRead(S7Data s7) {
        this.func = (byte)4;
        this.funcData = new byte[13];
        this.funcData[0] = 1;
        this.funcData[1] = 18;
        this.funcData[2] = 10;
        this.funcData[3] = 16;
        this.funcData[4] = s7.data_type;
        BE.setuint16(this.funcData, 5, s7.length);
        BE.setuint16(this.funcData, 7, s7.block_number);
        this.funcData[9] = s7.block_type;
        this.funcData[10] = (byte)((s7.offset & 0xFF0000) >> 16);
        this.funcData[11] = (byte)((s7.offset & 0xFF00) >> 8);
        this.funcData[12] = (byte)(s7.offset & 0xFF);
    }

    public void makeRead(S7Data[] s7s) {
        this.func = (byte)4;
        byte cnt = (byte)s7s.length;
        this.funcData = new byte[1 + cnt * 12];
        this.funcData[0] = cnt;
        int offset = 1;
        for (byte a = 0; a < cnt; a = (byte)(a + 1)) {
            S7Data s7 = s7s[a];
            this.funcData[offset++] = 18;
            this.funcData[offset++] = 10;
            this.funcData[offset++] = 16;
            this.funcData[offset++] = s7.data_type;
            BE.setuint16(this.funcData, offset, 1);
            BE.setuint16(this.funcData, offset += 2, s7.block_number);
            offset += 2;
            this.funcData[offset++] = s7.block_type;
            this.funcData[offset++] = (byte)((s7.offset & 0xFF0000) >> 16);
            this.funcData[offset++] = (byte)((s7.offset & 0xFF00) >> 8);
            this.funcData[offset++] = (byte)(s7.offset & 0xFF);
        }
    }

    private byte getTransportType(byte data_type) {
        switch (data_type) {
            case 1: {
                return 3;
            }
            case 2: 
            case 4: 
            case 6: {
                return 4;
            }
            case 3: {
                return 9;
            }
            case 5: 
            case 7: {
                return 5;
            }
            case 8: {
                return 7;
            }
        }
        return 0;
    }

    public void makeWrite(byte block_type, int block_number, byte data_type, int off, int len, byte[] data) {
        this.func = (byte)5;
        this.funcData = new byte[17 + data.length];
        this.funcData[0] = 1;
        this.funcData[1] = 18;
        this.funcData[2] = 10;
        this.funcData[3] = 16;
        this.funcData[4] = data_type;
        BE.setuint16(this.funcData, 5, len);
        BE.setuint16(this.funcData, 7, block_number);
        this.funcData[9] = block_type;
        this.funcData[10] = (byte)((off & 0xFF0000) >> 16);
        this.funcData[11] = (byte)((off & 0xFF00) >> 8);
        this.funcData[12] = (byte)(off & 0xFF);
        this.funcData[13] = 0;
        this.funcData[14] = this.getTransportType(data_type);
        if (data_type == 1) {
            BE.setuint16(this.funcData, 15, len);
        } else {
            BE.setuint16(this.funcData, 15, data.length << 3);
        }
        System.arraycopy(data, 0, this.funcData, 17, data.length);
    }

    public int size() {
        return 1 + this.funcData.length;
    }

    public void write(byte[] data, int offset) {
        data[offset++] = this.func;
        System.arraycopy(this.funcData, 0, data, offset, this.funcData.length);
    }

    private boolean isBits(byte transport_type) {
        switch (transport_type) {
            case 3: {
                return true;
            }
            case 4: {
                return true;
            }
            case 5: {
                return true;
            }
            case 7: {
                return false;
            }
            case 9: {
                return false;
            }
        }
        return false;
    }

    public boolean read(byte[] data, int offset, S7Data out) throws Exception {
        this.func = data[offset++];
        int count = data[offset++];
        for (int a = 0; a < count; ++a) {
            byte success;
            if ((success = data[offset++]) != -1) {
                JFLog.log("Error:success=" + success);
                return false;
            }
            if (this.func != 4) continue;
            byte transport_type = data[offset++];
            int len = BE.getuint16(data, offset);
            if (this.isBits(transport_type)) {
                len = len + 7 >> 3;
            }
            offset += 2;
            if (a == 0) {
                out.data = new byte[len];
                System.arraycopy(data, offset, out.data, 0, len);
            }
            offset += len;
            if (len % 2 != 1) continue;
            ++offset;
        }
        return true;
    }

    public boolean read(byte[] data, int offset, S7Data[] outs) throws Exception {
        this.func = data[offset++];
        int count = data[offset++];
        for (int a = 0; a < count; ++a) {
            byte success;
            S7Data out = outs[a];
            if ((success = data[offset++]) != -1) {
                JFLog.log("Error:success=" + success);
                return false;
            }
            if (this.func != 4) continue;
            byte transport_type = data[offset++];
            int len = BE.getuint16(data, offset);
            if (this.isBits(transport_type)) {
                len = len + 7 >> 3;
            }
            out.data = new byte[len];
            System.arraycopy(data, offset += 2, out.data, 0, len);
            offset += len;
            if (len % 2 != 1) continue;
            ++offset;
        }
        return true;
    }
}

