/*
 * Decompiled with CFR 0.152.
 */
package javaforce.media;

import javaforce.media.MediaFormat;
import javaforce.media.MediaIO;

public class MediaEncoder
extends MediaFormat {
    public boolean fps_1000_1001 = false;
    public int framesPerKeyFrame = 12;
    public int videoBitRate = 400000;
    public int audioBitRate = 128000;
    public int compressionLevel = -1;
    public int profileLevel = 1;

    private native boolean nstart(MediaIO var1, int var2, int var3, int var4, int var5, int var6, String var7, int var8, int var9);

    private native boolean nstartFile(String var1, int var2, int var3, int var4, int var5, int var6, String var7, int var8, int var9);

    public boolean start(MediaIO io, int width, int height, int fps, int chs, int freq, String format, boolean doVideo, boolean doAudio) {
        return this.nstart(io, width, height, fps, chs, freq, format, doVideo ? -1 : 0, doAudio ? -1 : 0);
    }

    public boolean start(MediaIO io, int width, int height, int fps, int chs, int freq, String format, int video_codec, int audio_codec) {
        return this.nstart(io, width, height, fps, chs, freq, format, video_codec, audio_codec);
    }

    public boolean startFile(String file, int width, int height, int fps, int chs, int freq, String format, int video_codec, int audio_codec) {
        return this.nstartFile(file, width, height, fps, chs, freq, format, video_codec, audio_codec);
    }

    public void set1000over1001(boolean state) {
        this.fps_1000_1001 = state;
    }

    public void setFramesPerKeyFrame(int count) {
        this.framesPerKeyFrame = count;
    }

    public void setVideoBitRate(int rate) {
        this.videoBitRate = rate;
    }

    public void setAudioBitRate(int rate) {
        this.audioBitRate = rate;
    }

    public void setCompressionLevel(int level) {
        this.compressionLevel = level;
    }

    public void setProfileLevel(int level) {
        this.profileLevel = level;
    }

    public native boolean addAudio(short[] var1, int var2, int var3);

    public boolean addAudio(short[] sams) {
        return this.addAudio(sams, 0, sams.length);
    }

    public native boolean addVideo(int[] var1);

    public native int getAudioFramesize();

    public native long getLastDTS();

    public native long getLastPTS();

    public native boolean addAudioEncoded(byte[] var1, int var2, int var3);

    public native boolean addVideoEncoded(byte[] var1, int var2, int var3, boolean var4);

    public native boolean addAudioEncodedTS(byte[] var1, int var2, int var3, long var4, long var6);

    public native boolean addVideoEncodedTS(byte[] var1, int var2, int var3, boolean var4, long var5, long var7);

    public native void flush();

    public native void stop();

    public String getCodecMimeType(String codec, boolean doVideo, boolean doAudio) {
        StringBuilder mime = new StringBuilder();
        switch (codec) {
            case "dash": 
            case "mp4": {
                mime.append("video/mp4;codecs=\"");
                if (doAudio) {
                    mime.append("mp4a.40.2");
                }
                if (doVideo) {
                    if (doAudio) {
                        mime.append(",");
                    }
                    switch (this.profileLevel) {
                        case 1: {
                            mime.append("avc1.420028");
                            break;
                        }
                        case 2: {
                            mime.append("avc1.4D0028");
                            break;
                        }
                        case 3: {
                            mime.append("avc1.640028");
                        }
                    }
                }
                mime.append("\"");
                break;
            }
            case "webm": {
                mime.append("video/webm;codecs=\"");
                if (doAudio) {
                    mime.append("opus");
                }
                if (doVideo) {
                    if (doAudio) {
                        mime.append(",");
                    }
                    mime.append("vp09.00.10.08");
                }
                mime.append("\"");
            }
        }
        return mime.toString();
    }
}

