/*
 * Decompiled with CFR 0.152.
 */
package javaforce.ui;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import javaforce.BE;
import javaforce.JFLog;
import javaforce.awt.priv.bmp;
import javaforce.awt.priv.svg;
import javaforce.awt.priv.xpm;
import javaforce.ui.Color;
import javaforce.ui.Dimension;
import javaforce.ui.FontComponent;

public class Image
extends FontComponent {
    private int[] buffer;
    private int lineStyle = 1;
    private int resizeOperation = 0;
    public static final int ALPHA_MASK = -16777216;
    public static final int OPAQUE = -16777216;
    public static final int TRANSPARENT = 0;
    public static final int RED_MASK = 0xFF0000;
    public static final int GREEN_MASK = 65280;
    public static final int BLUE_MASK = 255;
    public static final int RGB_MASK = 0xFFFFFF;
    private static int defColor = -16777216;
    public int jpeg_quality = 90;

    public Image() {
        this.setSize(1, 1);
    }

    public Image(int width, int height) {
        this.setSize(width, height);
    }

    public static void setDefaultColor(int clr) {
        defColor = clr;
    }

    public static int getDefaultColor() {
        return defColor;
    }

    private native int[] nloadPNG(byte[] var1, int[] var2);

    public boolean loadPNG(InputStream is) {
        byte[] data;
        try {
            data = is.readAllBytes();
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
        int[] dim = new int[2];
        this.buffer = this.nloadPNG(data, dim);
        if (this.buffer != null) {
            super.setSize(dim[0], dim[1]);
        }
        return this.buffer != null;
    }

    public boolean loadPNG(String fn) {
        try {
            FileInputStream fis = new FileInputStream(fn);
            boolean loaded = this.loadPNG(fis);
            fis.close();
            return loaded;
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    private native byte[] nsavePNG(int[] var1, int var2, int var3);

    public boolean savePNG(OutputStream os) {
        byte[] data = this.nsavePNG(this.buffer, this.size.width, this.size.height);
        if (data == null) {
            return false;
        }
        try {
            os.write(data);
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
        return true;
    }

    public boolean savePNG(String fn) {
        try {
            FileOutputStream fis = new FileOutputStream(fn);
            boolean saved = this.savePNG(fis);
            fis.close();
            return saved;
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    private native int[] nloadJPG(byte[] var1, int[] var2);

    public boolean loadJPG(InputStream is) {
        byte[] data;
        try {
            data = is.readAllBytes();
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
        int[] dim = new int[2];
        this.buffer = this.nloadJPG(data, dim);
        return this.buffer != null;
    }

    public boolean loadJPG(String fn) {
        try {
            FileInputStream fis = new FileInputStream(fn);
            boolean loaded = this.loadJPG(fis);
            fis.close();
            return loaded;
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    private native byte[] nsaveJPG(int[] var1, int var2, int var3, int var4);

    public boolean saveJPG(OutputStream os) {
        byte[] data = this.nsaveJPG(this.buffer, this.size.width, this.size.height, this.jpeg_quality);
        if (data == null) {
            return false;
        }
        try {
            os.write(data);
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
        return true;
    }

    public boolean saveJPG(String fn) {
        try {
            FileOutputStream fis = new FileOutputStream(fn);
            boolean saved = this.saveJPG(fis);
            fis.close();
            return saved;
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    public boolean loadBMP(String filename, int index) {
        try {
            return this.loadBMP(new FileInputStream(filename), index);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean saveBMP(String filename) {
        try {
            return this.saveBMP(new FileOutputStream(filename));
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean loadBMP(InputStream in, int index) {
        Dimension size = new Dimension(0, 0);
        this.buffer = bmp.load(in, size, index);
        try {
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.buffer == null) {
            JFLog.log("loadBMP() failed! null returned");
            return false;
        }
        if (size.width == 0 || size.height == 0) {
            JFLog.log("loadBMP() failed! image size zero");
            return false;
        }
        super.setSize(size.width, size.height);
        return true;
    }

    public boolean saveBMP(OutputStream out) {
        Dimension size = new Dimension(this.getWidth(), this.getHeight());
        return bmp.save24(out, this.buffer, size, false, false);
    }

    public boolean saveICO(String filename) {
        try {
            return this.saveICO(new FileOutputStream(filename));
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean saveICO(OutputStream out) {
        Dimension size = new Dimension(this.getWidth(), this.getHeight());
        return bmp.save32(out, this.buffer, size, false, true);
    }

    public boolean saveICNS(String filename) {
        try {
            return this.saveICNS(new FileOutputStream(filename));
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean saveICNS(OutputStream out) {
        int h;
        byte[] header = new byte[16];
        int w = this.getWidth();
        if (w > (h = this.getHeight())) {
            h = w;
        }
        if (h > w) {
            w = h;
        }
        int newSize = 16;
        String OSType2 = "icp4";
        if (w > 256) {
            newSize = 512;
            OSType2 = "ic09";
        } else if (w > 128) {
            newSize = 256;
            OSType2 = "ic08";
        } else if (w > 64) {
            newSize = 128;
            OSType2 = "ic07";
        } else if (w > 32) {
            newSize = 64;
            OSType2 = "icp6";
        } else if (w > 16) {
            newSize = 32;
            OSType2 = "icp5";
        }
        if (w != newSize || h != newSize) {
            JFLog.log("Image.saveICNS() failed:Image must be square");
            return false;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.savePNG(baos);
        System.arraycopy("icns".getBytes(), 0, header, 0, 4);
        BE.setuint32(header, 4, 16 + baos.size());
        System.arraycopy(OSType2.getBytes(), 0, header, 8, 4);
        BE.setuint32(header, 12, 8 + baos.size());
        try {
            out.write(header);
            out.write(baos.toByteArray());
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean loadSVG(String filename) {
        try {
            return this.loadSVG(new FileInputStream(filename));
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean saveSVG(String filename) {
        try {
            return this.saveSVG(new FileOutputStream(filename));
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean loadSVG(InputStream in) {
        Dimension size = new Dimension(0, 0);
        this.buffer = svg.load(in, size, defColor);
        try {
            in.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.buffer == null) {
            return false;
        }
        if (size.width == 0 || size.height == 0) {
            return false;
        }
        super.setSize(size.width, size.height);
        return true;
    }

    public boolean saveSVG(OutputStream out) {
        ByteArrayOutputStream png_data = new ByteArrayOutputStream();
        this.savePNG(png_data);
        Dimension size = new Dimension(this.getWidth(), this.getHeight());
        boolean ret = svg.save(out, png_data.toByteArray(), size);
        try {
            out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public boolean loadXPM(String filename) {
        try {
            return this.loadXPM(new FileInputStream(filename));
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean loadXPM(InputStream in) {
        Dimension size = new Dimension(0, 0);
        this.buffer = new xpm().load(in, size);
        if (this.buffer == null) {
            return false;
        }
        if (size.width == 0 || size.height == 0) {
            return false;
        }
        this.setSize(size.width, size.height);
        return true;
    }

    @Override
    public void setSize(int width, int height) {
        int[] org_buffer = this.buffer;
        int org_w = this.getWidth();
        int org_h = this.getHeight();
        super.setSize(width, height);
        this.buffer = new int[width * height];
        if (org_buffer != null) {
            switch (this.resizeOperation) {
                case 0: {
                    break;
                }
                case 1: {
                    this.putPixels(org_buffer, 0, 0, org_w, org_h, 0, org_w);
                    break;
                }
            }
        }
    }

    public int getResizeOperation() {
        return this.resizeOperation;
    }

    public void setResizeOperation(int op) {
        this.resizeOperation = op;
    }

    public int getPixel(int x, int y) {
        if (x < 0 || x >= this.getWidth()) {
            return 0;
        }
        if (y < 0 || y >= this.getHeight()) {
            return 0;
        }
        return this.buffer[y * this.getWidth() + x] & Color.MASK_RGB;
    }

    public void putPixel(int x, int y, int c) {
        if (x < 0 || x >= this.getWidth()) {
            return;
        }
        if (y < 0 || y >= this.getHeight()) {
            return;
        }
        this.buffer[y * this.getWidth() + x] = Color.OPAQUE | c;
    }

    public int getPixelA(int x, int y) {
        if (x < 0 || x >= this.getWidth()) {
            return 0;
        }
        if (y < 0 || y >= this.getHeight()) {
            return 0;
        }
        return this.buffer[y * this.getWidth() + x];
    }

    public void putPixelA(int x, int y, int c) {
        if (x < 0 || x >= this.getWidth()) {
            return;
        }
        if (y < 0 || y >= this.getHeight()) {
            return;
        }
        this.buffer[y * this.getWidth() + x] = c;
    }

    public int[] getPixels() {
        int[] px = new int[this.buffer.length];
        System.arraycopy(this.buffer, 0, px, 0, this.buffer.length);
        return px;
    }

    public int[] getBuffer() {
        return this.buffer;
    }

    public void putPixels(int[] src, int x, int y, int w, int h, int srcOffset) {
        this.putPixels(src, x, y, w, h, srcOffset, w);
    }

    public void putPixels(int[] src, int x, int y, int w, int h, int srcOffset, int srcWidth) {
        int bw = this.getWidth();
        int bh = this.getHeight();
        if (w <= 0) {
            return;
        }
        if (h <= 0) {
            return;
        }
        if (y < 0) {
            if ((h -= (y *= -1)) <= 0) {
                return;
            }
            srcOffset += y * srcWidth;
            y = 0;
        }
        if (x < 0) {
            if ((w -= (x *= -1)) <= 0) {
                return;
            }
            srcOffset += x;
            x = 0;
        }
        if (x + w > bw && (w = bw - x) <= 0) {
            return;
        }
        if (y + h > bh && (h = bh - y) <= 0) {
            return;
        }
        int dstOffset = y * bw + x;
        if (w == bw && srcWidth == w) {
            System.arraycopy(src, srcOffset, this.buffer, dstOffset, w * h);
        } else {
            for (int i = 0; i < h; ++i) {
                System.arraycopy(src, srcOffset, this.buffer, dstOffset, w);
                srcOffset += srcWidth;
                dstOffset += bw;
            }
        }
    }

    public void putPixelsKeyClr(int[] px, int x, int y, int w, int h, int offset, int keyclr) {
        int srcWidth = w;
        int bw = this.getWidth();
        int bh = this.getHeight();
        if (w <= 0) {
            return;
        }
        if (h <= 0) {
            return;
        }
        if (y < 0) {
            if ((h -= (y *= -1)) <= 0) {
                return;
            }
            offset += y * srcWidth;
            y = 0;
        }
        if (x < 0) {
            if ((w -= (x *= -1)) <= 0) {
                return;
            }
            offset += x;
            x = 0;
        }
        if (x + w > bw && (w = bw - x) <= 0) {
            return;
        }
        if (y + h > bh && (h = bh - y) <= 0) {
            return;
        }
        int dst = y * bw + x;
        for (int i = 0; i < h; ++i) {
            for (int j = 0; j < w; ++j) {
                if ((px[offset + j] & Color.MASK_RGB) == keyclr) continue;
                this.buffer[dst + j] = px[offset + j];
            }
            offset += srcWidth;
            dst += bw;
        }
    }

    public void putPixelsBlend(int[] px, int x, int y, int w, int h, int srcOffset, int srcWidth, boolean keepAlpha) {
        int bw = this.getWidth();
        int bh = this.getHeight();
        if (w <= 0) {
            return;
        }
        if (h <= 0) {
            return;
        }
        if (y < 0) {
            if ((h -= (y *= -1)) <= 0) {
                return;
            }
            srcOffset += y * srcWidth;
            y = 0;
        }
        if (x < 0) {
            if ((w -= (x *= -1)) <= 0) {
                return;
            }
            srcOffset += x;
            x = 0;
        }
        if (x + w > bw && (w = bw - x) <= 0) {
            return;
        }
        if (y + h > bh && (h = bh - y) <= 0) {
            return;
        }
        int dst = y * bw + x;
        for (int i = 0; i < h; ++i) {
            for (int j = 0; j < w; ++j) {
                int sp = px[srcOffset + j];
                int sa = sp & Color.MASK_ALPHA;
                sp &= Color.MASK_RGB;
                int slvl = sa >>> 24;
                if (slvl > 0) {
                    ++slvl;
                }
                int dlvl = 256 - slvl;
                int dp = this.buffer[dst + j];
                int da = dp & Color.MASK_ALPHA;
                this.buffer[dst + j] = (keepAlpha ? da : sa) + (((dp &= Color.MASK_RGB) & Color.MASK_RED) * dlvl >> 8 & Color.MASK_RED) + ((dp & Color.MASK_GREEN) * dlvl >> 8 & Color.MASK_GREEN) + ((dp & Color.MASK_BLUE) * dlvl >> 8 & Color.MASK_BLUE) + ((sp & Color.MASK_RED) * slvl >> 8 & Color.MASK_RED) + ((sp & Color.MASK_GREEN) * slvl >> 8 & Color.MASK_GREEN) + ((sp & Color.MASK_BLUE) * slvl >> 8 & Color.MASK_BLUE);
            }
            srcOffset += srcWidth;
            dst += bw;
        }
    }

    public void putPixelsBlendKeyClr(int[] px, int x, int y, int w, int h, int srcOffset, int srcWidth, boolean keepAlpha, int keyclr) {
        int bw = this.getWidth();
        int bh = this.getHeight();
        if (w <= 0) {
            return;
        }
        if (h <= 0) {
            return;
        }
        if (y < 0) {
            if ((h -= (y *= -1)) <= 0) {
                return;
            }
            srcOffset += y * srcWidth;
            y = 0;
        }
        if (x < 0) {
            if ((w -= (x *= -1)) <= 0) {
                return;
            }
            srcOffset += x;
            x = 0;
        }
        if (x + w > bw && (w = bw - x) <= 0) {
            return;
        }
        if (y + h > bh && (h = bh - y) <= 0) {
            return;
        }
        int dst = y * bw + x;
        for (int i = 0; i < h; ++i) {
            for (int j = 0; j < w; ++j) {
                int sp = px[srcOffset + j];
                int sa = sp & Color.MASK_ALPHA;
                if ((sp &= Color.MASK_RGB) == keyclr) continue;
                int slvl = sa >>> 24;
                if (slvl > 0) {
                    ++slvl;
                }
                int dlvl = 256 - slvl;
                int dp = this.buffer[dst + j];
                int da = dp & Color.MASK_ALPHA;
                this.buffer[dst + j] = (keepAlpha ? da : sa) + (((dp &= Color.MASK_RGB) & Color.MASK_RED) * dlvl >> 8 & Color.MASK_RED) + ((dp & Color.MASK_GREEN) * dlvl >> 8 & Color.MASK_GREEN) + ((dp & Color.MASK_BLUE) * dlvl >> 8 & Color.MASK_BLUE) + ((sp & Color.MASK_RED) * slvl >> 8 & Color.MASK_RED) + ((sp & Color.MASK_GREEN) * slvl >> 8 & Color.MASK_GREEN) + ((sp & Color.MASK_BLUE) * slvl >> 8 & Color.MASK_BLUE);
            }
            srcOffset += srcWidth;
            dst += bw;
        }
    }

    public void putPixelsStencil(int[] px, int x, int y, int w, int h, int srcOffset, int srcWidth, boolean keepAlpha, int clr) {
        int bw = this.getWidth();
        int bh = this.getHeight();
        if (w <= 0) {
            return;
        }
        if (h <= 0) {
            return;
        }
        if (y < 0) {
            if ((h -= (y *= -1)) <= 0) {
                return;
            }
            srcOffset += y * srcWidth;
            y = 0;
        }
        if (x < 0) {
            if ((w -= (x *= -1)) <= 0) {
                return;
            }
            srcOffset += x;
            x = 0;
        }
        if (x + w > bw && (w = bw - x) <= 0) {
            return;
        }
        if (y + h > bh && (h = bh - y) <= 0) {
            return;
        }
        int dst = y * bw + x;
        for (int i = 0; i < h; ++i) {
            for (int j = 0; j < w; ++j) {
                int sp = px[srcOffset + j];
                int sa = sp & Color.MASK_ALPHA;
                sp = clr;
                int slvl = sa >>> 24;
                if (slvl > 0) {
                    ++slvl;
                }
                int dlvl = 256 - slvl;
                int dp = this.buffer[dst + j];
                int da = dp & Color.MASK_ALPHA;
                this.buffer[dst + j] = (keepAlpha ? da : sa) + (((dp &= Color.MASK_RGB) & Color.MASK_RED) * dlvl >> 8 & Color.MASK_RED) + ((dp & Color.MASK_GREEN) * dlvl >> 8 & Color.MASK_GREEN) + ((dp & Color.MASK_BLUE) * dlvl >> 8 & Color.MASK_BLUE) + ((sp & Color.MASK_RED) * slvl >> 8 & Color.MASK_RED) + ((sp & Color.MASK_GREEN) * slvl >> 8 & Color.MASK_GREEN) + ((sp & Color.MASK_BLUE) * slvl >> 8 & Color.MASK_BLUE);
            }
            srcOffset += srcWidth;
            dst += bw;
        }
    }

    public void fill(int x, int y, int w, int h, int clr) {
        this.fill(x, y, w, h, clr, false);
    }

    public void fill(int x, int y, int w, int h, int clr, boolean hasAlpha) {
        if (!hasAlpha) {
            clr |= Color.OPAQUE;
        }
        int srcWidth = w;
        int bw = this.getWidth();
        int bh = this.getHeight();
        if (w <= 0) {
            return;
        }
        if (h <= 0) {
            return;
        }
        if (y < 0) {
            if ((h -= (y *= -1)) <= 0) {
                return;
            }
            y = 0;
        }
        if (x < 0) {
            if ((w -= (x *= -1)) <= 0) {
                return;
            }
            x = 0;
        }
        if (x + w > bw && (w = bw - x) <= 0) {
            return;
        }
        if (y + h > bh && (h = bh - y) <= 0) {
            return;
        }
        int dst = y * bw + x;
        if (w == bw && srcWidth == w) {
            Arrays.fill(this.buffer, dst, dst + w * h, clr);
        } else {
            for (int i = 0; i < h; ++i) {
                Arrays.fill(this.buffer, dst, dst + w, clr);
                dst += bw;
            }
        }
    }

    public void fill(int x, int y, int w, int h) {
        this.fill(x, y, w, h, this.getForeColor().getColor(), false);
    }

    public void drawText(int x, int y, String txt) {
        this.getFont().drawText(x, y, txt, this, this.getForeColor().getColor());
    }

    public void drawPixel(int x, int y) {
        switch (this.lineStyle) {
            case 2: {
                if ((x + y) % 2 != 0) break;
                return;
            }
        }
        this.putPixel(x, y, this.getForeColor().getColor());
    }

    public void setLineStyle(int style) {
        this.lineStyle = style;
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        int rise = y2 - y1;
        int run = x2 - x1;
        if (rise == 0 && run == 0) {
            this.drawPixel(x1, y1);
            return;
        }
        if (rise == 0) {
            int dx;
            int n = dx = x2 > x1 ? 1 : -1;
            while (x1 != x2) {
                this.drawPixel(x1, y1);
                x1 += dx;
            }
            this.drawPixel(x1, y1);
            return;
        }
        if (run == 0) {
            int dy;
            int n = dy = y2 > y1 ? 1 : -1;
            while (y1 != y2) {
                this.drawPixel(x1, y1);
                y1 += dy;
            }
            this.drawPixel(x1, y1);
            return;
        }
        if (Math.abs(rise) == Math.abs(run)) {
            int dy;
            int dx = x2 > x1 ? 1 : -1;
            int n = dy = y2 > y1 ? 1 : -1;
            while (y1 != y2) {
                this.drawPixel(x1, y1);
                x1 += dx;
                y1 += dy;
            }
            this.drawPixel(x1, y1);
            return;
        }
        if (rise > run) {
            int dy;
            float fx = x1;
            float dx = (float)run / (float)rise;
            int n = dy = y2 > y1 ? 1 : -1;
            while (y1 != y2) {
                this.drawPixel((int)fx, y1);
                fx += dx;
                y1 += dy;
            }
            this.drawPixel((int)fx, y1);
        } else {
            int dx;
            float fy = y1;
            float dy = (float)rise / (float)run;
            int n = dx = x2 > x1 ? 1 : -1;
            while (x1 != x2) {
                this.drawPixel(x1, (int)fy);
                x1 += dx;
                fy += dy;
            }
            this.drawPixel(x1, (int)fy);
        }
    }

    public void drawBox(int x, int y, int width, int height) {
        int x1 = x;
        int y1 = y;
        int x2 = x + width - 1;
        int y2 = y + height - 1;
        this.drawLine(x1, y1, x2, y1);
        this.drawLine(x2, y1, x2, y2);
        this.drawLine(x2, y2, x1, y2);
        this.drawLine(x1, y2, x1, y1);
    }

    public void drawImage(Image img, int x, int y) {
        this.putPixels(img.getBuffer(), x, y, img.getWidth(), img.getHeight(), 0);
    }

    public void drawImageKeyClr(Image img, int x, int y, int keyclr) {
        this.putPixelsKeyClr(img.getBuffer(), x, y, img.getWidth(), img.getHeight(), 0, keyclr);
    }

    public void drawImageBlend(Image img, int x, int y, boolean keepAlpha) {
        this.putPixelsBlend(img.getBuffer(), x, y, img.getWidth(), img.getHeight(), 0, img.getWidth(), keepAlpha);
    }
}

