/*
 * Decompiled with CFR 0.152.
 */
package javaforce.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Random;
import javaforce.JF;
import javaforce.ParseArgs;

public class FindReplace {
    boolean b_icmp = false;
    boolean b_asis = false;
    boolean b_recursive = false;
    final int BUFSIZE = 65536;
    final int THSIZE = 32768;
    String oldstr;
    String newstr;
    byte[] ibuf;
    byte[] obuf;
    ParseArgs pa = new ParseArgs();

    public static void main(String[] args) {
        FindReplace x = new FindReplace();
        x.main2(args);
    }

    void usage() {
        System.out.println("Find & Replace utility v" + JF.getVersion());
        System.out.println("Usage : jfr [options] oldstr newstr filespec");
        System.out.println(" strings may contain C-style codes (\\n\\r\\t\\xHH\\DDD)");
        System.out.println("   HH=hex DDD=decimal ascii codes");
        System.out.println(" place \"quotes\" around strings if they start with '-' or contain spaces");
        System.out.println(" -asis = do not process C-style codes");
        System.out.println(" -i = case insensitive comparison");
        System.out.println(" -r = recursive");
        System.exit(0);
    }

    void main2(String[] args) {
        int a;
        this.pa.arg_decoderefs = false;
        this.pa.arg_parse(args);
        if (this.pa.arg_names.size() < 3) {
            this.usage();
        }
        for (a = 0; a < this.pa.arg_opts.size(); ++a) {
            if (this.pa.arg_opts.get(a).equals("i")) {
                this.b_icmp = true;
                continue;
            }
            if (this.pa.arg_opts.get(a).equals("asis")) {
                this.b_asis = true;
                continue;
            }
            if (this.pa.arg_opts.get(a).equals("r")) {
                this.b_recursive = true;
                continue;
            }
            System.out.println("Option ignored : " + this.pa.arg_opts.get(a));
        }
        this.oldstr = this.convertstr(this.pa.arg_names.get(0));
        this.newstr = this.convertstr(this.pa.arg_names.get(1));
        System.out.println("Converting \"" + this.pa.arg_names.get(0) + "\" to \"" + this.pa.arg_names.get(1) + "\"");
        System.out.println("Converting [" + this.makestr(this.oldstr) + "] to [" + this.makestr(this.newstr) + "]");
        this.ibuf = new byte[65536];
        this.obuf = new byte[65536];
        for (a = 2; a < this.pa.arg_names.size(); ++a) {
            File file = new File(this.pa.arg_names.get(a));
            if (file.isDirectory()) {
                this.doFolder(file);
                continue;
            }
            this.doFile(file);
        }
    }

    void error(String msg) {
        System.out.println("Error : " + msg);
        System.exit(1);
    }

    void doFolder(File folder) {
        File[] files = folder.listFiles();
        for (int a = 0; a < files.length; ++a) {
            File file = files[a];
            if (file.isDirectory()) {
                if (!this.b_recursive) continue;
                this.doFolder(file);
                continue;
            }
            this.doFile(file);
        }
    }

    void doFile(File fi) {
        if (!fi.exists()) {
            this.error("file not found:" + fi.getAbsolutePath());
            return;
        }
        Random r = new Random();
        JF.randomize(r);
        String parent = fi.getParent();
        if (parent == null) {
            parent = "";
        }
        File fo = new File(parent + "jfr-" + r.nextInt(0xFFFFFF) + ".tmp");
        int cnt = 0;
        FileInputStream fis = JF.fileopen(fi.getAbsolutePath());
        if (fis == null) {
            JF.msg("Unable to open : " + fi.getAbsolutePath());
            return;
        }
        FileOutputStream fos = JF.filecreate(fo.getAbsolutePath());
        int ifs = JF.filelength(fis);
        int ofs = 0;
        int ibs = 0;
        int obs = 0;
        int ibp = 0;
        while (ifs > 0 || ibs > 0) {
            boolean res;
            if (ibs < 32768 && ifs > 0) {
                if (ibs > 0) {
                    System.arraycopy(this.ibuf, ibp, this.ibuf, 0, ibs);
                }
                ibp = 0;
                if (ifs >= 32768) {
                    if (JF.read(fis, this.ibuf, ibs, 32768) != 32768) {
                        this.error("unable to read file");
                    }
                    ibs += 32768;
                    ifs -= 32768;
                } else {
                    if (JF.read(fis, this.ibuf, ibs, ifs) != ifs) {
                        this.error("unable to read file");
                    }
                    ibs += ifs;
                    ifs = 0;
                }
            }
            if (obs > 32768) {
                if (!JF.write(fos, this.obuf, 0, obs)) {
                    this.error("unable to write file");
                }
                obs = 0;
            }
            if (res = this.b_icmp ? JF.memicmp(this.ibuf, ibp, this.oldstr.getBytes(), 0, this.oldstr.length()) : JF.memcmp(this.ibuf, ibp, this.oldstr.getBytes(), 0, this.oldstr.length())) {
                if (this.newstr.length() > 0) {
                    System.arraycopy(this.newstr.getBytes(), 0, this.obuf, obs, this.newstr.length());
                }
                obs += this.newstr.length();
                ofs += this.newstr.length();
                ibp += this.oldstr.length();
                ibs -= this.oldstr.length();
                ++cnt;
                continue;
            }
            this.obuf[obs] = this.ibuf[ibp];
            ++obs;
            ++ibp;
            --ibs;
            ++ofs;
        }
        if (obs > 0 && !JF.write(fos, this.obuf, 0, obs)) {
            this.error("unable to write file");
        }
        int allread = 0;
        if (cnt > 0) {
            JF.fileclose(fis);
            JF.fileclose(fos);
            fis = JF.fileopen(fo.getAbsolutePath());
            fos = JF.filecreate(fi.getAbsolutePath());
            while (!JF.eof(fis)) {
                int read = JF.read(fis, this.ibuf, 0, 65536);
                allread += read;
                if (JF.write(fos, this.ibuf, 0, read)) continue;
                this.error("unable to write file");
            }
            if (allread != ofs) {
                this.error("unable to write file");
            }
            JF.fileclose(fis);
            JF.fileclose(fos);
            fo.delete();
            System.out.println("Replaced " + cnt + " occurances of string in file " + fi.getAbsolutePath());
        } else {
            JF.fileclose(fis);
            JF.fileclose(fos);
            fo.delete();
            System.out.println("String not found in " + fi.getAbsolutePath());
        }
    }

    /*
     * Unable to fully structure code
     */
    String convertstr(String in) {
        s = "";
        for (a = 0; a < in.length(); ++a) {
            block29: {
                c = in.charAt(a);
                if (c != '\\' || this.b_asis) break block29;
                x = in.charAt(a + 1);
                if (x >= 48 && x <= 57) {
                    v1 = x;
                    v2 = in.charAt(a + 2);
                    if (v2 < 48 || v2 > 57) {
                        s = (String)s + c;
                        continue;
                    }
                    v3 = in.charAt(a + 3);
                    if (v3 < 48 || v3 > 57) {
                        s = (String)s + c;
                        continue;
                    }
                    x = (v1 -= 48) * 100 + (v2 -= 48) * 10 + (v3 -= 48);
                    if (x > 127) {
                        x -= 256;
                    }
                    c = (char)x;
                    s = (String)s + c;
                    a += 3;
                    continue;
                }
                switch (x) {
                    case 92: {
                        s = (String)s + "\\";
                        ** GOTO lbl80
                    }
                    case 39: {
                        s = (String)s + "'";
                        ** GOTO lbl80
                    }
                    case 34: {
                        s = (String)s + "\"";
                        ** GOTO lbl80
                    }
                    case 45: {
                        s = (String)s + "-";
                        ** GOTO lbl80
                    }
                    case 98: {
                        s = (String)s + "\b";
                        ** GOTO lbl80
                    }
                    case 102: {
                        s = (String)s + "\f";
                        ** GOTO lbl80
                    }
                    case 110: {
                        s = (String)s + "\n";
                        ** GOTO lbl80
                    }
                    case 114: {
                        s = (String)s + "\r";
                        ** GOTO lbl80
                    }
                    case 116: {
                        s = (String)s + "\t";
                        ** GOTO lbl80
                    }
                    case 120: {
                        v1 = in.charAt(a + 2);
                        v2 = in.charAt(a + 3);
                        if (v1 >= 48 && v1 <= 57) {
                            v1 -= 48;
                        } else if (v1 >= 97 && v1 <= 102) {
                            v1 -= 87;
                        } else if (v1 >= 65 && v1 <= 70) {
                            v1 -= 55;
                        } else {
                            s = (String)s + c;
                            break;
                        }
                        if (v2 >= 48 && v2 <= 57) {
                            v2 -= 48;
                        } else if (v2 >= 97 && v2 <= 102) {
                            v2 -= 87;
                        } else if (v2 >= 65 && v2 <= 70) {
                            v2 -= 55;
                        } else {
                            s = (String)s + c;
                            break;
                        }
                        x = v1 * 16 + v2;
                        s = (String)s + (char)x;
                        a += 3;
                        break;
                    }
lbl80:
                    // 10 sources

                    default: {
                        ++a;
                        break;
                    }
                }
                continue;
            }
            s = (String)s + c;
        }
        return s;
    }

    String makestr(String str) {
        Object ret = "";
        for (int a = 0; a < str.length(); ++a) {
            char ch = str.charAt(a);
            ret = ch < ' ' ? (String)ret + "\\x" + Integer.toHexString(ch) : (String)ret + ch;
        }
        return ret;
    }
}

