/*
 * Decompiled with CFR 0.152.
 */
package javaforce.utils;

import java.util.ArrayList;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.ShellProcess;
import javaforce.ShellProcessListener;
import javaforce.utils.BuildTools;

public class InstallProject
implements ShellProcessListener {
    private BuildTools tools;

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("Usage:InstallProject build.xml");
            System.exit(1);
        }
        try {
            new InstallProject().run(args[0]);
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    public void run(String buildfile) throws Exception {
        String apptype;
        this.tools = new BuildTools();
        if (!this.tools.loadXML(buildfile)) {
            throw new Exception("error loading " + buildfile);
        }
        Object app = this.tools.getProperty("app");
        switch (apptype = this.tools.getProperty("apptype")) {
            case "client": {
                app = (String)app + "-client";
                break;
            }
            case "server": {
                app = (String)app + "-server";
            }
        }
        JFLog.log("Installing executable:" + (String)app + ".bin to /usr/bin");
        JF.copyFile((String)app + ".bin", "/usr/bin/" + (String)app);
        BuildTools.chmod_x("/usr/bin/" + (String)app);
        ShellProcess sp = new ShellProcess();
        sp.addListener(this);
        ArrayList<String> cmd = new ArrayList<String>();
        if (JF.isWindows()) {
            cmd.add("ant.bat");
        } else {
            cmd.add("ant");
        }
        cmd.add("-file");
        cmd.add(buildfile);
        cmd.add("install");
        JFLog.log("Executing ant -file " + buildfile + " install");
        sp.run(cmd.toArray(JF.StringArrayType), true);
        this.doSubProjects();
    }

    @Override
    public void shellProcessOutput(String str) {
        System.out.print(str);
    }

    private void doSubProjects() {
        String[] subs;
        for (String project : subs = this.tools.getSubProjects()) {
            InstallProject.main(new String[]{project + ".xml"});
        }
    }
}

