/*
 * Decompiled with CFR 0.152.
 */
package javaforce.webui.tasks;

import java.io.File;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Calendar;
import javaforce.BE;
import javaforce.JFLog;
import javaforce.webui.tasks.TaskEvent;

public class TaskLog {
    private String folder;
    private ArrayList<TaskEvent> processing = new ArrayList();
    private ArrayList<TaskEvent> completed = new ArrayList();
    private Object lock = new Object();
    private static final long time_cut_time = 86400000L;

    public TaskLog(String folder) {
        this.folder = folder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(TaskEvent event) {
        Object object = this.lock;
        synchronized (object) {
            this.processing.add(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void complete(TaskEvent event) {
        try {
            Calendar now = Calendar.getInstance();
            int year = now.get(1);
            int month = now.get(2) + 1;
            Object object = this.lock;
            synchronized (object) {
                this.completed.add(event);
                this.processing.remove(event);
                String filename = this.getFilename(year, month);
                RandomAccessFile file_io = new RandomAccessFile(filename, "rw");
                byte[] data = event.toByteArray();
                file_io.seek(file_io.length());
                file_io.write(data);
                file_io.close();
            }
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void purge() {
        Object object = this.lock;
        synchronized (object) {
            long time_now = System.currentTimeMillis();
            long time_cut = time_now - 86400000L;
            ArrayList<TaskEvent> remove = new ArrayList<TaskEvent>();
            Object object2 = this.lock;
            synchronized (object2) {
                for (TaskEvent event : this.completed) {
                    if (event.time_complete == 0L || event.time_complete >= time_cut) continue;
                    remove.add(event);
                }
                for (TaskEvent event : remove) {
                    this.completed.remove(event);
                }
            }
        }
    }

    public boolean getTaskCompleted(long task_id) {
        TaskEvent event = this.getTaskEvent(task_id);
        return event.time_complete != 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskEvent getTaskEvent(long task_id) {
        Object object = this.lock;
        synchronized (object) {
            for (TaskEvent event : this.processing) {
                if (event.task_id != task_id) continue;
                return event;
            }
            for (TaskEvent event : this.completed) {
                if (event.task_id != task_id) continue;
                return event;
            }
        }
        return null;
    }

    private String getFilename(int year, int month) {
        return String.format("%s/%d-%02d.tasks", this.folder, year, month);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskEvent[] getEventsInProcess() {
        TaskEvent[] list;
        Object object = this.lock;
        synchronized (object) {
            list = this.processing.toArray(TaskEvent.ArrayType);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskEvent[] getEvents(int year, int month) {
        byte[] data = new byte[4096];
        ArrayList<TaskEvent> events = new ArrayList<TaskEvent>();
        RandomAccessFile file_io = null;
        try {
            Object object = this.lock;
            synchronized (object) {
                int event_length;
                String filename = this.getFilename(year, month);
                if (!new File(filename).exists()) {
                    return TaskEvent.ArrayType;
                }
                file_io = new RandomAccessFile(filename, "rw");
                long length = file_io.length();
                for (long pos = 0L; pos < length; pos += (long)event_length) {
                    file_io.readFully(data, 0, 4);
                    pos += 4L;
                    event_length = BE.getuint32(data, 0);
                    while (event_length > data.length) {
                        data = new byte[data.length << 1];
                    }
                    file_io.readFully(data, 0, event_length);
                    events.add(TaskEvent.fromByteArray(data, 0, event_length));
                }
                file_io.close();
            }
        }
        catch (Exception e) {
            if (file_io != null) {
                try {
                    file_io.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            JFLog.log(e);
        }
        return events.toArray(TaskEvent.ArrayType);
    }
}

