package javaforce.awt;

/** View Log File
 *
 * @author pquiring
 */

import java.io.*;

import javaforce.*;

public class ViewLog extends javax.swing.JDialog {

  //file
  private File file;

  //text
  private Runnable refresh;
  private String msg;

  /**
   * Creates new form ViewLog
   */
  public ViewLog(File file) {
    super((javax.swing.JFrame)null, true);
    initComponents();
    init();
    this.file = file;
    load(file);
  }

  public ViewLog(String msg) {
    super((javax.swing.JFrame)null, true);
    initComponents();
    init();
    this.msg = msg;
    load(msg);
  }

  public ViewLog(String msg, Runnable refresh) {
    super((javax.swing.JFrame)null, true);
    initComponents();
    init();
    this.msg = msg;
    this.refresh = refresh;
    load(msg);
  }

  private void init() {
    JFAWT.centerWindow(this);
  }

  /**
   * This method is called from within the constructor to initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is always
   * regenerated by the Form Editor.
   */
  @SuppressWarnings("unchecked")
  // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
  private void initComponents() {

    close = new javax.swing.JButton();
    jScrollPane1 = new javax.swing.JScrollPane();
    txt = new javax.swing.JTextArea();
    bRefresh = new javax.swing.JButton();

    setDefaultCloseOperation(javax.swing.WindowConstants.DO_NOTHING_ON_CLOSE);
    addWindowListener(new java.awt.event.WindowAdapter() {
      public void windowClosing(java.awt.event.WindowEvent evt) {
        formWindowClosing(evt);
      }
    });

    close.setText("Close");
    close.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        closeActionPerformed(evt);
      }
    });

    txt.setEditable(false);
    txt.setColumns(20);
    txt.setRows(5);
    txt.setText("[loading...]");
    jScrollPane1.setViewportView(txt);

    bRefresh.setText("Refresh");
    bRefresh.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        bRefreshActionPerformed(evt);
      }
    });

    javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
    getContentPane().setLayout(layout);
    layout.setHorizontalGroup(
      layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(layout.createSequentialGroup()
        .addContainerGap()
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
          .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
            .addComponent(bRefresh)
            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
            .addComponent(close))
          .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 498, Short.MAX_VALUE))
        .addContainerGap())
    );
    layout.setVerticalGroup(
      layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
        .addContainerGap()
        .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 417, Short.MAX_VALUE)
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
          .addComponent(close)
          .addComponent(bRefresh))
        .addContainerGap())
    );

    pack();
  }// </editor-fold>//GEN-END:initComponents

  private void closeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_closeActionPerformed
    isClosed = true;
    dispose();
  }//GEN-LAST:event_closeActionPerformed

  private void formWindowClosing(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowClosing
    isClosed = true;
  }//GEN-LAST:event_formWindowClosing

  private void bRefreshActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bRefreshActionPerformed
    doRefresh();
  }//GEN-LAST:event_bRefreshActionPerformed

  /**
   * @param args the command line arguments
   */
  public static void main(String[] args) {
    final String file = args[0];
    java.awt.EventQueue.invokeLater(new Runnable() {
      public void run() {
        new ViewLog(new File(file)).setVisible(true);
      }
    });
  }

  // Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JButton bRefresh;
  private javax.swing.JButton close;
  private javax.swing.JScrollPane jScrollPane1;
  private javax.swing.JTextArea txt;
  // End of variables declaration//GEN-END:variables

  private void load(File file) {
    try {
      FileInputStream fis = new FileInputStream(file);
      byte[] txt = JF.readAll(fis);
      load(new String(txt));
    } catch (Exception e) {
      JFLog.log(e);
    }
  }

  private void load(String msg) {
    txt.setText(msg);
  }

  public void setText(String msg) {
    this.msg = msg;
    load(msg);
  }

  public void setRefresh(Runnable refresh) {
    this.refresh = refresh;
  }

  private void doRefresh() {
    if (file != null) load(file);
    if (refresh != null) {
      refresh.run();
    }
  }

  public boolean isClosed = false;

  public boolean isClosed() {
    return isClosed;
  }
}
