/*
 * Decompiled with CFR 0.152.
 */
package javaforce.io;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import javaforce.io.SerialObject;

public class ObjectReader {
    private DataInputStream dis;
    private boolean header;
    private int type = -1;

    public ObjectReader(InputStream is) {
        this.dis = new DataInputStream(new BufferedInputStream(is));
    }

    public void readHeader() throws Exception {
        if (this.header) {
            throw new Exception("header already read");
        }
        short magic = this.dis.readShort();
        if (magic != 19014) {
            throw new Exception("invalid magic");
        }
        short res1 = this.dis.readShort();
        this.type = this.dis.readInt();
        long res2 = this.dis.readLong();
        this.header = true;
    }

    public int getType() {
        return this.type;
    }

    public Object readObject(SerialObject reader) throws Exception {
        if (!this.header) {
            this.readHeader();
        }
        reader.readInit(this.dis);
        reader.readObject();
        return reader;
    }
}

