/*
 * Decompiled with CFR 0.152.
 */
package javaforce.lxc;

public class LxcImage {
    public String id;
    public String repo;
    public String arch;
    public String name;
    public String version;

    public LxcImage() {
    }

    public LxcImage(String mtag) {
        int idx = mtag.lastIndexOf(58);
        if (idx == -1) {
            this.version = "latest";
        } else {
            this.version = mtag.substring(idx + 1);
            mtag = mtag.substring(0, idx);
        }
        String[] fs = mtag.split("[/]");
        int cnt = fs.length - 1;
        if (cnt >= 0) {
            this.name = fs[cnt--];
        }
        if (cnt >= 0) {
            this.arch = fs[cnt--];
        }
        if (cnt >= 0) {
            this.repo = fs[cnt--];
        }
    }

    public LxcImage(String mtag, String version) {
        this.version = version;
        String[] fs = mtag.split("[/]");
        int cnt = fs.length - 1;
        if (cnt >= 0) {
            this.name = fs[cnt--];
        }
        if (cnt >= 0) {
            this.arch = fs[cnt--];
        }
        if (cnt >= 0) {
            this.repo = fs[cnt--];
        }
    }

    public LxcImage(String arch, String name, String version) {
        this.arch = arch;
        this.name = name;
        this.version = version;
    }

    public LxcImage(String repo, String arch, String name, String version) {
        this.repo = repo;
        this.arch = arch;
        this.name = name;
        this.version = version;
    }

    public LxcImage setID(String id) {
        this.id = id;
        return this;
    }

    public boolean delete() {
        return false;
    }

    public String[] getStates() {
        return new String[]{this.id, this.toString()};
    }

    public String toString() {
        if (this.repo != null) {
            return this.repo + "/" + this.arch + "/" + this.name + ":" + this.version;
        }
        return this.arch + "/" + this.name + ":" + this.version;
    }
}

