/*
 * Decompiled with CFR 0.152.
 */
package javaforce.service;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import javaforce.Base64;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.KeyMgmt;
import javaforce.LDAP;
import javaforce.jbus.JBusClient;
import javaforce.jbus.JBusServer;
import javaforce.net.EMail;
import javaforce.net.IP4;
import javaforce.net.IP4Port;
import javaforce.net.Subnet4;

public class SMTPServer {
    public static final String busPack = "net.sf.jfsmtp";
    public static boolean debug = false;
    private static SMTPServer smtp;
    private Server server;
    private Events events;
    private ArrayList<ServerWorker> servers = new ArrayList();
    private ArrayList<ClientWorker> clients = new ArrayList();
    private String domain;
    private String ldap_domain;
    private String ldap_server;
    private ArrayList<EMail> users;
    private Object lock = new Object();
    private IP4Port bind = new IP4Port();
    private ArrayList<Subnet4> subnet_src_list;
    private ArrayList<Integer> ports = new ArrayList();
    private ArrayList<Integer> ssl_ports = new ArrayList();
    private boolean digest = false;
    private static final String defaultConfig = "[global]\nport=25\n#port=587\n#secure=465\n#bind=192.168.100.2\n#domain=example.com\n#ldap_domain=example.org\n#ldap_server=192.168.200.2\n#account=user:pass\n#digest=true\n#src.ipnet=192.168.2.0/255.255.255.0\n#src.ip=192.168.3.2\n";
    private static JBusServer busServer;
    private JBusClient busClient;
    private String config;

    public static String getConfigFile() {
        return JF.getConfigPath() + "/jfsmtp.cfg";
    }

    public static String getLogFile() {
        return JF.getLogPath() + "/jfsmtp.log";
    }

    public static String getMailboxFolder(String user) {
        StringBuilder path = new StringBuilder();
        if (JF.isWindows()) {
            path.append(System.getenv("ProgramData").replaceAll("\\\\", "/"));
            path.append("/jfsmtp/mail");
        } else {
            path.append("/var/jfsmtp/mail");
        }
        if (user != null) {
            path.append("/");
            path.append(user);
        }
        String mail = path.toString();
        new File(mail).mkdirs();
        return mail;
    }

    public static int getBusPort() {
        if (JF.isWindows()) {
            return 33009;
        }
        return 777;
    }

    public void setEvents(Events events) {
        this.events = events;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSession(ClientWorker sess) {
        Object object = this.lock;
        synchronized (object) {
            this.clients.add(sess);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSession(ClientWorker sess) {
        Object object = this.lock;
        synchronized (object) {
            this.clients.remove(sess);
        }
    }

    private static String getKeyFile() {
        return JF.getConfigPath() + "/jfsmtp.key";
    }

    public void start() {
        this.stop();
        this.server = new Server();
        this.server.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.server == null) {
            return;
        }
        this.server.active = false;
        Object object = this.server;
        synchronized (object) {
            this.server.notify();
        }
        object = this.lock;
        synchronized (object) {
            ClientWorker[] ca;
            ServerWorker[] sa;
            for (ServerWorker s : sa = this.servers.toArray(new ServerWorker[0])) {
                s.close();
            }
            this.servers.clear();
            for (ClientWorker s : ca = this.clients.toArray(new ClientWorker[0])) {
                s.close();
            }
            this.clients.clear();
        }
        this.server = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadConfig() {
        JFLog.log("loadConfig");
        this.users = new ArrayList();
        Section section = Section.None;
        this.bind.setIP("0.0.0.0");
        this.bind.port = 25;
        this.subnet_src_list = new ArrayList();
        try {
            BufferedReader br = new BufferedReader(new FileReader(SMTPServer.getConfigFile()));
            StringBuilder cfg = new StringBuilder();
            while (true) {
                String ln;
                if ((ln = br.readLine()) == null) {
                    br.close();
                    this.config = cfg.toString();
                    return;
                }
                cfg.append(ln);
                cfg.append("\n");
                ln = ln.trim();
                int cmt = ln.indexOf(35);
                if (cmt != -1) {
                    ln = ln.substring(0, cmt).trim();
                }
                if (ln.length() == 0) continue;
                if (ln.equals("[global]")) {
                    section = Section.Global;
                    continue;
                }
                int idx = ln.indexOf("=");
                if (idx == -1) continue;
                String key = ln.substring(0, idx);
                String value = ln.substring(idx + 1);
                block2 : switch (section.ordinal()) {
                    case 0: 
                    case 1: {
                        switch (key) {
                            case "port": {
                                this.ports.add(Integer.valueOf(ln.substring(5)));
                                break;
                            }
                            case "secure": {
                                this.ssl_ports.add(Integer.valueOf(ln.substring(7)));
                                break;
                            }
                            case "bind": {
                                if (this.bind.setIP(value)) break;
                                JFLog.log("SMTP:bind:Invalid IP:" + value);
                                break;
                            }
                            case "account": {
                                EMail user = new EMail();
                                int cln = value.indexOf(58);
                                if (cln == -1) {
                                    JFLog.log("Invalid user:" + value);
                                    break block2;
                                }
                                user.user = value.substring(0, cln);
                                user.pass = value.substring(cln + 1);
                                this.users.add(user);
                                break;
                            }
                            case "domain": {
                                this.domain = value;
                                break;
                            }
                            case "ldap_domain": {
                                this.ldap_domain = value;
                                break;
                            }
                            case "ldap_server": {
                                this.ldap_server = value;
                                break;
                            }
                            case "digest": {
                                this.digest = value.equals("true");
                                break;
                            }
                            case "debug": {
                                debug = value.equals("true");
                                break;
                            }
                            case "src.ipnet": {
                                Subnet4 subnet = new Subnet4();
                                idx = value.indexOf(47);
                                if (idx == -1) {
                                    JFLog.log("SMTP:Invalid IP Subnet:" + value);
                                    break;
                                }
                                String ip = value.substring(0, idx);
                                String mask = value.substring(idx + 1);
                                if (!subnet.setIP(ip)) {
                                    JFLog.log("SMTP:Invalid IP:" + ip);
                                    break;
                                }
                                if (!subnet.setMask(mask)) {
                                    JFLog.log("SMTP:Invalid netmask:" + mask);
                                    break;
                                }
                                JFLog.log("Source Allow IP Network=" + subnet.toString());
                                this.subnet_src_list.add(subnet);
                                break;
                            }
                            case "src.ip": {
                                Subnet4 subnet = new Subnet4();
                                if (!subnet.setIP(value)) {
                                    JFLog.log("SMTP:Invalid IP:" + value);
                                    break;
                                }
                                subnet.setMask("255.255.255.255");
                                JFLog.log("Source Allow IP Address=" + subnet.toString());
                                this.subnet_src_list.add(subnet);
                                break;
                            }
                        }
                        break;
                    }
                }
            }
        }
        catch (FileNotFoundException e) {
            JFLog.log("config not found, creating defaults.");
            try {
                FileOutputStream fos = new FileOutputStream(SMTPServer.getConfigFile());
                fos.write(defaultConfig.getBytes());
                fos.close();
                this.config = defaultConfig;
                return;
            }
            catch (Exception e2) {
                JFLog.log(e2);
                return;
            }
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    public boolean login(String user, String pass) {
        for (EMail acct : this.users) {
            if (!acct.user.equals(user)) continue;
            return acct.pass.equals(pass);
        }
        if (this.ldap_server != null && this.ldap_domain != null) {
            LDAP ldap = new LDAP();
            return ldap.login(this.ldap_server, this.ldap_domain, user, pass);
        }
        return false;
    }

    private boolean ip_src_allowed(String ip4) {
        if (this.subnet_src_list.size() == 0) {
            return true;
        }
        IP4 target = new IP4();
        if (!target.setIP(ip4)) {
            return false;
        }
        for (Subnet4 net : this.subnet_src_list) {
            if (!net.isWithin(target)) continue;
            return true;
        }
        return false;
    }

    private boolean userExists(EMail email) {
        for (EMail acct : this.users) {
            if (!acct.user.equals(email.user)) continue;
            return true;
        }
        return false;
    }

    public static void serviceStart(String[] args) {
        if (JF.isWindows()) {
            busServer = new JBusServer(SMTPServer.getBusPort());
            busServer.start();
            while (true) {
                if (JBusServer.ready) break;
                JF.sleep(10);
            }
        }
        smtp = new SMTPServer();
        smtp.start();
    }

    public static void serviceStop() {
        JFLog.log("SMTP : Stopping service");
        if (busServer != null) {
            busServer.close();
            busServer = null;
        }
        smtp.stop();
    }

    public static boolean createKeys() {
        return KeyMgmt.keytool(new String[]{"-genkey", "-debug", "-alias", "jfsmtp", "-keypass", "password", "-storepass", "password", "-keystore", SMTPServer.getKeyFile(), "-validity", "3650", "-dname", "CN=jfsmtp.sourceforge.net, OU=user, O=server, C=CA", "-keyalg", "RSA", "-keysize", "2048"});
    }

    public static interface Events {
        public void message(SMTPServer var1, String var2);
    }

    private class Server
    extends Thread {
        public boolean active;

        private Server() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            JFLog.append(JF.getLogPath() + "/jfsmtp.log", true);
            JFLog.setRetention(30);
            JFLog.log("SMTP : Starting service");
            this.active = true;
            try {
                ServerWorker worker;
                int p;
                SMTPServer.this.loadConfig();
                SMTPServer.this.busClient = new JBusClient(SMTPServer.busPack, new JBusMethods());
                SMTPServer.this.busClient.setPort(SMTPServer.getBusPort());
                SMTPServer.this.busClient.start();
                Object object = SMTPServer.this.ports.iterator();
                while (object.hasNext()) {
                    p = object.next();
                    worker = new ServerWorker(p, false);
                    worker.start();
                    SMTPServer.this.servers.add(worker);
                }
                object = SMTPServer.this.ssl_ports.iterator();
                while (object.hasNext()) {
                    p = object.next();
                    worker = new ServerWorker(p, true);
                    worker.start();
                    SMTPServer.this.servers.add(worker);
                }
                while (this.active) {
                    object = this;
                    synchronized (object) {
                        this.wait();
                    }
                }
                return;
            }
            catch (Exception e) {
                JFLog.log(e);
            }
        }
    }

    public class ServerWorker
    extends Thread {
        private ServerSocket ss;
        private int port;
        private boolean secure;
        private boolean worker_active;

        public ServerWorker(int port, boolean secure) {
            this.port = port;
            this.secure = secure;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Object keys;
                if (this.secure) {
                    JFLog.log("CreateServerSocketSSL");
                    keys = new KeyMgmt();
                    if (new File(SMTPServer.getKeyFile()).exists()) {
                        FileInputStream fis = new FileInputStream(SMTPServer.getKeyFile());
                        ((KeyMgmt)keys).open(fis, "password");
                        fis.close();
                    } else {
                        JFLog.log("Warning:Server SSL Keys not generated!");
                    }
                    this.ss = JF.createServerSocketSSL((KeyMgmt)keys);
                } else {
                    this.ss = new ServerSocket();
                }
                keys = SMTPServer.this.bind;
                synchronized (keys) {
                    SMTPServer.this.bind.port = this.port;
                    this.ss.bind(SMTPServer.this.bind.toInetSocketAddress());
                }
                this.worker_active = true;
                while (this.worker_active) {
                    Socket s = this.ss.accept();
                    InetSocketAddress sa = (InetSocketAddress)s.getRemoteSocketAddress();
                    String src_ip = sa.getAddress().getHostAddress();
                    if (src_ip.equals("0:0:0:0:0:0:0:1")) {
                        src_ip = "127.0.0.1";
                    }
                    if (!SMTPServer.this.ip_src_allowed(src_ip)) {
                        JFLog.log("SMTP:Source IP blocked:" + src_ip);
                        s.close();
                        continue;
                    }
                    ClientWorker sess = new ClientWorker(s, this.secure);
                    SMTPServer.this.addSession(sess);
                    sess.start();
                }
            }
            catch (Exception e) {
                JFLog.log(e);
            }
        }

        public void close() {
            try {
                this.ss.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.ss = null;
        }
    }

    public class ClientWorker
    extends Thread {
        private Socket c;
        private boolean secure;
        private InputStream cis = null;
        private OutputStream cos = null;
        private byte[] req = new byte[1500];
        private int reqSize = 0;
        private byte[] buffer = new byte[1500];
        private int bufferSize = 0;
        private EMail from;
        private ArrayList<EMail> to = new ArrayList();

        public ClientWorker(Socket s, boolean secure) {
            this.c = s;
            this.secure = secure;
        }

        public void close() {
            if (this.c != null) {
                try {
                    this.c.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.c = null;
            }
        }

        public String readln() {
            if (this.bufferSize > 0) {
                System.arraycopy(this.buffer, 0, this.req, 0, this.bufferSize);
                this.reqSize = this.bufferSize;
                this.bufferSize = 0;
            } else {
                this.reqSize = 0;
            }
            try {
                while (this.c != null && this.c.isConnected()) {
                    int read;
                    if (this.reqSize >= 2) {
                        for (int idx = 2; idx <= this.reqSize; ++idx) {
                            if (this.req[idx - 2] != 13 || this.req[idx - 1] != 10) continue;
                            int left = this.reqSize - idx;
                            if (left > 0) {
                                System.arraycopy(this.req, idx, this.buffer, 0, left);
                                this.bufferSize = left;
                            }
                            return new String(this.req, 0, idx - 2).trim();
                        }
                    }
                    if (this.reqSize == this.req.length) {
                        if (this.req.length >= 12000) {
                            throw new Exception("data too large");
                        }
                        int newSize = this.req.length << 1;
                        byte[] new_req = new byte[newSize];
                        this.buffer = new byte[newSize];
                        System.arraycopy(this.req, 0, new_req, 0, this.req.length);
                        this.req = new_req;
                    }
                    if ((read = this.cis.read(this.req, this.reqSize, this.req.length - this.reqSize)) >= 0) {
                        this.reqSize += read;
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                JFLog.log(e);
            }
            return null;
        }

        @Override
        public void run() {
            block4: {
                try {
                    String cmd;
                    JFLog.log("Session start");
                    this.cis = this.c.getInputStream();
                    this.cos = this.c.getOutputStream();
                    this.cos.write(("220 jfSMTP Server/" + JF.getVersion() + "\r\n").getBytes());
                    while (this.c != null && this.c.isConnected() && (cmd = this.readln()) != null) {
                        if (cmd.equalsIgnoreCase("QUIT")) {
                            this.cos.write("221 Goodbye\r\n".getBytes());
                            break;
                        }
                        this.doCommand(cmd);
                    }
                }
                catch (Exception e) {
                    if (e instanceof SocketException) break block4;
                    JFLog.log(e);
                }
            }
            this.close();
            SMTPServer.this.removeSession(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doCommand(String cmd) throws Exception {
            if (debug) {
                JFLog.log("Request=" + cmd);
            }
            String[] p = cmd.split(" ", 2);
            block11 : switch (p[0].toUpperCase()) {
                case "HELO": 
                case "EHLO": {
                    this.cos.write(("250 jfSMTP Server/" + JF.getVersion() + "\r\n").getBytes());
                    break;
                }
                case "AUTH": {
                    String type = p[1];
                    switch (type.toUpperCase()) {
                        case "LOGIN": {
                            this.cos.write("334 Send username\r\n".getBytes());
                            String user_base64 = this.readln();
                            if (user_base64 == null) {
                                this.close();
                                return;
                            }
                            String user = new String(Base64.decode(user_base64.getBytes()));
                            this.cos.write("334 Send password\r\n".getBytes());
                            String pass_base64 = this.readln();
                            if (pass_base64 == null) {
                                this.close();
                                return;
                            }
                            String pass = new String(Base64.decode(pass_base64.getBytes()));
                            if (SMTPServer.this.login(user, pass)) {
                                this.cos.write("235 Login successful\r\n".getBytes());
                                break block11;
                            }
                            JF.sleep(1000);
                            this.cos.write("501 Login failed\r\n".getBytes());
                            this.close();
                            return;
                        }
                    }
                    this.cos.write("504 Unknown AUTH type\r\n".getBytes());
                    break;
                }
                case "STARTTLS": {
                    if (this.secure) {
                        this.cos.write("550 Already secure\r\n".getBytes());
                        break;
                    }
                    this.cos.write("220 Ok\r\n".getBytes());
                    this.c = JF.connectSSL(this.c, KeyMgmt.getDefaultClient());
                    this.cis = this.c.getInputStream();
                    this.cos = this.c.getOutputStream();
                    this.secure = true;
                    break;
                }
                case "DATA": {
                    String filename;
                    if (this.from == null) {
                        this.cos.write("550 No from address\r\n".getBytes());
                        break;
                    }
                    if (this.to.size() == 0) {
                        this.cos.write("550 No recipients\r\n".getBytes());
                        break;
                    }
                    this.cos.write("354 Send Data\r\n".getBytes());
                    Object object = SMTPServer.this.lock;
                    synchronized (object) {
                        filename = Long.toString(System.currentTimeMillis());
                        JF.sleep(10);
                    }
                    String basefile = SMTPServer.getMailboxFolder(null) + "/" + filename;
                    String quefile = basefile + ".que";
                    String msgfile = basefile + ".msg";
                    FileOutputStream questream = new FileOutputStream(quefile);
                    while (this.c != null && this.c.isConnected()) {
                        String ln = this.readln();
                        if (ln == null) {
                            this.close();
                            return;
                        }
                        if (ln.equals(".")) break;
                        ((OutputStream)questream).write(ln.getBytes());
                        ((OutputStream)questream).write("\r\n".getBytes());
                    }
                    ((OutputStream)questream).close();
                    new File(quefile).renameTo(new File(msgfile));
                    if (!SMTPServer.this.digest) {
                        StringBuilder to_list = new StringBuilder();
                        for (EMail acct : this.to) {
                            to_list.append("to:");
                            to_list.append(acct.user);
                            to_list.append("\r\n");
                        }
                        byte[] to_data = to_list.toString().getBytes();
                        for (EMail acct : this.to) {
                            String userbox = SMTPServer.getMailboxFolder(acct.user);
                            String userbasefile = userbox + "/" + filename;
                            String userquefile = userbasefile + ".que";
                            String usermsgfile = userbasefile + ".msg";
                            FileOutputStream fos = new FileOutputStream(userquefile);
                            fos.write(to_data);
                            fos.close();
                            new File(userquefile).renameTo(new File(usermsgfile));
                        }
                    }
                    if (SMTPServer.this.events != null) {
                        SMTPServer.this.events.message(smtp, msgfile);
                    }
                    this.cos.write("250 Ok\r\n".getBytes());
                    this.reset();
                    break;
                }
                case "MAIL": {
                    if (this.from != null) {
                        this.cos.write("550 Already have from email\r\n".getBytes());
                        break;
                    }
                    this.from = new EMail();
                    if (!this.from.set(cmd)) {
                        this.from = null;
                        this.cos.write("550 Invalid from address\r\n".getBytes());
                        break;
                    }
                    this.cos.write("250 Ok\r\n".getBytes());
                    break;
                }
                case "RCPT": {
                    EMail email = new EMail();
                    if (!email.set(cmd)) {
                        this.cos.write("550 Invalid to address\r\n".getBytes());
                        break;
                    }
                    if (!SMTPServer.this.digest) {
                        if (SMTPServer.this.domain != null && !email.domain.equals(SMTPServer.this.domain)) {
                            this.cos.write("550 Server will not relay messages\r\n".getBytes());
                            break;
                        }
                        if (!SMTPServer.this.userExists(email)) {
                            this.cos.write("550 User not found\r\n".getBytes());
                            break;
                        }
                    }
                    this.to.add(email);
                    this.cos.write("250 Ok\r\n".getBytes());
                    break;
                }
                default: {
                    this.cos.write("500 Unknown command\r\n".getBytes());
                }
            }
        }

        private void reset() {
            this.from = null;
            this.to.clear();
        }
    }

    static enum Section {
        None,
        Global;

    }

    public static class JBusMethods {
        public void getConfig(String pack) {
            JBusClient cfr_ignored_0 = SMTPServer.smtp.busClient;
            JBusClient cfr_ignored_1 = SMTPServer.smtp.busClient;
            SMTPServer.smtp.busClient.call(pack, "getConfig", JBusClient.quote(JBusClient.encodeString(SMTPServer.smtp.config)));
        }

        public void setConfig(String cfg) {
            JFLog.log("setConfig");
            try {
                FileOutputStream fos = new FileOutputStream(SMTPServer.getConfigFile());
                fos.write(JBusClient.decodeString(cfg).getBytes());
                fos.close();
            }
            catch (Exception e) {
                JFLog.log(e);
            }
        }

        public void restart() {
            JFLog.log("restart");
            smtp.stop();
            smtp = new SMTPServer();
            smtp.start();
        }

        public void genKeys(String pack) {
            if (SMTPServer.createKeys()) {
                JFLog.log("Generated Keys");
                JBusClient cfr_ignored_0 = SMTPServer.smtp.busClient;
                SMTPServer.smtp.busClient.call(pack, "getKeys", JBusClient.quote("OK"));
            } else {
                JBusClient cfr_ignored_1 = SMTPServer.smtp.busClient;
                SMTPServer.smtp.busClient.call(pack, "getKeys", JBusClient.quote("ERROR"));
            }
        }
    }
}

