/*
 * Decompiled with CFR 0.152.
 */
package javaforce.utils;

import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Properties;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.ShellProcess;
import javaforce.ShellProcessListener;
import javaforce.utils.BuildTools;

public class ExecGraal
implements ShellProcessListener {
    private BuildTools tools;

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("Usage:ExecGraal build.xml");
            System.exit(1);
        }
        try {
            new ExecGraal().run(args[0]);
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    public void run(String buildfile) throws Exception {
        this.tools = new BuildTools();
        if (!this.tools.loadXML(buildfile)) {
            throw new Exception("error loading " + buildfile);
        }
        String app = this.tools.getProperty("app");
        Object cfg = this.tools.getProperty("cfg");
        if (((String)cfg).length() == 0) {
            cfg = app + ".cfg";
        }
        Properties props = new Properties();
        FileInputStream fis = new FileInputStream((String)cfg);
        props.load(fis);
        fis.close();
        Object classpath = props.getProperty("CLASSPATH");
        String mainclass = props.getProperty("MAINCLASS");
        classpath = (String)classpath + ";meta.jar";
        ShellProcess sp = new ShellProcess();
        sp.addListener(this);
        ArrayList<Object> cmd = new ArrayList<Object>();
        if (JF.isWindows()) {
            cmd.add("native-image.cmd");
        } else {
            cmd.add("native-image");
        }
        cmd.add("-cp");
        if (JF.isWindows()) {
            cmd.add(classpath);
        } else {
            cmd.add(((String)classpath).replaceAll("[;]", ":"));
        }
        cmd.add(mainclass.replaceAll("/", "."));
        cmd.add("--shared");
        cmd.add("--no-fallback");
        String[] cmdArray = cmd.toArray(JF.StringArrayType);
        System.out.println("cmd=" + JF.join(" ", cmdArray));
        sp.run(cmdArray, true);
        this.doSubProjects();
    }

    @Override
    public void shellProcessOutput(String str) {
        System.out.print(str);
    }

    private void doSubProjects() {
        String[] subs;
        for (String project : subs = this.tools.getSubProjects()) {
            ExecGraal.main(new String[]{project + ".xml"});
        }
    }
}

