/*
 * Decompiled with CFR 0.152.
 */
package javaforce.utils;

import java.util.Calendar;
import javaforce.JFLog;
import javaforce.jni.WinNative;

public class ScriptEx {
    public static String[] args;
    public static final boolean ansi = false;

    public static void main(String[] args) {
        ScriptEx.args = args;
        int ret = 0;
        try {
            new ScriptEx().run();
        }
        catch (Throwable e) {
            e.printStackTrace();
            ret = 1;
        }
        System.exit(ret);
    }

    public void usage() {
        System.out.println("ScriptEx command [args]");
        System.out.println("  get-week");
        System.out.println("   : return current week in year (1-52)");
        System.out.println("  get-epoch-ms");
        System.out.println("   : return current epoch (1970) in ms");
        System.out.println("  get-epoch-sec");
        System.out.println("   : return current epoch (1970) in seconds");
        System.out.println("  get-epoch-ldap");
        System.out.println("   : return current epoch (1601) in 100-ns");
        System.out.println("  runas [domain\\]user password cmd args");
        System.out.println("   : run cmd as another user");
        System.out.println("  runasadmin cmd args");
        System.out.println("   : run cmd with admin rights");
        System.exit(1);
    }

    public void run() {
        if (args == null || args.length < 1) {
            this.usage();
            return;
        }
        int flags = 0;
        switch (args[0]) {
            case "get-week": {
                Calendar cal = Calendar.getInstance();
                System.out.println(String.format("%d", cal.get(3)));
                return;
            }
            case "get-epoch-ms": {
                System.out.println(System.currentTimeMillis());
                return;
            }
            case "get-epoch-sec": {
                System.out.println(System.currentTimeMillis() / 1000L);
                return;
            }
            case "get-epoch-ldap": {
                System.out.println((System.currentTimeMillis() - 11644473600000L) * 10000L);
                return;
            }
            case "runas": {
                if (args.length < 4) {
                    this.usage();
                    return;
                }
                String domain = ".";
                String user = args[1];
                String pass = args[2];
                int idx = user.indexOf(92);
                if (idx != -1) {
                    domain = user.substring(0, idx);
                    user = user.substring(idx + 1);
                }
                String cmd = args[3];
                Object cmdargs = "";
                for (int a = 4; a < args.length; ++a) {
                    if (((String)cmdargs).length() > 0) {
                        cmdargs = (String)cmdargs + " ";
                    }
                    cmdargs = (String)cmdargs + args[a];
                }
                if (!WinNative.createProcessAsUser(domain, user, pass, cmd, (String)cmdargs, flags)) {
                    JFLog.log("Logon failed");
                    return;
                }
                return;
            }
            case "runasadmin": {
                String cmd = args[1];
                Object cmdargs = "";
                for (int a = 2; a < args.length; ++a) {
                    if (((String)cmdargs).length() > 0) {
                        cmdargs = (String)cmdargs + " ";
                    }
                    cmdargs = (String)cmdargs + args[a];
                }
                WinNative.shellExecute("runas", cmd, (String)cmdargs);
                return;
            }
        }
        System.out.println("Unknown command:" + args[0]);
        this.usage();
    }
}

