/*
 * Decompiled with CFR 0.152.
 */
package javaforce.webui;

import javaforce.webui.Color;
import javaforce.webui.Icon;
import javaforce.webui.Image;
import javaforce.webui.Resource;
import javaforce.webui.TextComponent;
import javaforce.webui.event.MouseEvent;

public class ToggleButton
extends TextComponent {
    private boolean state;
    private int clrOff;
    private int clrOn;
    private Image img;
    private Icon icon;

    public ToggleButton(String text) {
        this.text = text;
        this.setColors(Color.darkGrey, Color.grey);
        this.addEvent("onclick", "onClick(event, this);");
        this.setColor();
        this.setClass("button");
    }

    public ToggleButton(String text, int clrOff, int clrOn) {
        this.text = text;
        this.setColors(clrOff, clrOn);
        this.addEvent("onclick", "onClick(event, this);");
        this.setColor();
        this.setClass("button");
    }

    public ToggleButton(Resource img, String text) {
        this.img = new Image(img);
        this.add(this.img);
        this.text = text;
        this.setColors(Color.darkGrey, Color.grey);
        this.addEvent("onclick", "onClick(event, this);");
        this.setColor();
        this.setClass("button");
    }

    public ToggleButton(Resource img, String text, int clrOff, int clrOn) {
        this.img = new Image(img);
        this.add(this.img);
        this.text = text;
        this.setColors(clrOff, clrOn);
        this.addEvent("onclick", "onClick(event, this);");
        this.setColor();
        this.setClass("button");
    }

    public ToggleButton(Icon icon, String text) {
        this.icon = icon;
        this.add(this.icon);
        this.text = text;
        this.setColors(Color.darkGrey, Color.grey);
        this.addEvent("onclick", "onClick(event, this);");
        this.setColor();
    }

    public ToggleButton(Icon icon, String text, int clrOff, int clrOn) {
        this.icon = icon;
        this.add(this.icon);
        this.text = text;
        this.setColors(clrOff, clrOn);
        this.addEvent("onclick", "onClick(event, this);");
        this.setColor();
    }

    private void setColor() {
        this.setBackColor(this.state ? this.clrOn : this.clrOff);
    }

    @Override
    public void onClick(String[] args, MouseEvent me) {
        this.state = !this.state;
        this.setColor();
        this.onChanged(args);
        super.onClick(args, me);
    }

    @Override
    public String html() {
        StringBuilder html = new StringBuilder();
        html.append("<button" + this.getAttrs() + ">");
        if (this.img != null) {
            html.append(this.img.html());
        }
        if (this.icon != null) {
            html.append(this.icon.html());
        }
        if (this.text != null) {
            html.append(this.text);
        }
        html.append("</button>");
        return html.toString();
    }

    @Override
    public void setText(String text) {
        this.text = text;
        this.sendEvent("settext", new String[]{"text=" + text});
    }

    @Override
    public void updateText(String text) {
        this.sendEvent("settext", new String[]{"text=" + text});
    }

    public void setColors(int clrOff, int clrOn) {
        this.clrOff = clrOff;
        this.clrOn = clrOn;
        this.setColor();
    }

    public void setSelected(boolean state) {
        this.state = state;
        this.setColor();
    }

    public boolean isSelected() {
        return this.state;
    }
}

