/*
 * Decompiled with CFR 0.152.
 */
package javaforce.awt;

import java.awt.EventQueue;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.awt.JFAWT;
import javaforce.awt.JFImage;
import javaforce.awt.RFB;
import javaforce.awt.VNCRobot;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;

public class VNC
extends JFrame
implements MouseListener,
MouseMotionListener,
MouseWheelListener,
KeyListener {
    private static RFB rfb;
    private String host;
    private int port;
    private String pass;
    private static JFImage image;
    private int buttons;
    private static boolean is_fullscreen;
    private VNC vnc_windowed;
    private VNC vnc_fullscreen;
    public static boolean debug;
    public static boolean debugKeys;
    private static boolean fast;
    private JButton fullscreen;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JButton jButton4;
    private JScrollPane scroll;
    private JToolBar tools;

    public VNC(String host, int port, String pass) {
        this.initComponents();
        this.host = host;
        this.port = port;
        this.pass = pass;
        this.vnc_windowed = this;
        this.setTitle("VNC : " + host);
        new Connect().start();
    }

    public VNC(VNC windowed) {
        this.vnc_windowed = windowed;
        this.scroll = new JScrollPane();
        this.scroll.setBorder(null);
        this.setUndecorated(true);
        this.setContentPane(this.scroll);
        is_fullscreen = true;
        this.setDefaultCloseOperation(3);
        this.setTitle("VNC : " + windowed.host);
    }

    private void initComponents() {
        this.jButton2 = new JButton();
        this.tools = new JToolBar();
        this.jButton3 = new JButton();
        this.jButton1 = new JButton();
        this.jButton4 = new JButton();
        this.fullscreen = new JButton();
        this.scroll = new JScrollPane();
        this.jButton2.setText("jButton2");
        this.setDefaultCloseOperation(3);
        this.setTitle("VNC");
        this.tools.setRollover(true);
        this.jButton3.setText("Refresh");
        this.jButton3.setFocusable(false);
        this.jButton3.setHorizontalTextPosition(0);
        this.jButton3.setVerticalTextPosition(3);
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VNC.this.jButton3ActionPerformed(evt);
            }
        });
        this.tools.add(this.jButton3);
        this.jButton1.setText("C+A+D");
        this.jButton1.setFocusable(false);
        this.jButton1.setHorizontalTextPosition(0);
        this.jButton1.setVerticalTextPosition(3);
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VNC.this.jButton1ActionPerformed(evt);
            }
        });
        this.tools.add(this.jButton1);
        this.jButton4.setText("WinKey");
        this.jButton4.setFocusable(false);
        this.jButton4.setHorizontalTextPosition(0);
        this.jButton4.setVerticalTextPosition(3);
        this.jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VNC.this.jButton4ActionPerformed(evt);
            }
        });
        this.tools.add(this.jButton4);
        this.fullscreen.setText("FullScreen");
        this.fullscreen.setFocusable(false);
        this.fullscreen.setHorizontalTextPosition(0);
        this.fullscreen.setVerticalTextPosition(3);
        this.fullscreen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VNC.this.fullscreenActionPerformed(evt);
            }
        });
        this.tools.add(this.fullscreen);
        this.scroll.setBorder(null);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tools, -1, 400, Short.MAX_VALUE).addComponent(this.scroll));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.tools, -2, 25, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scroll, -1, 269, Short.MAX_VALUE)));
        this.pack();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.ctrl_alt_del();
    }

    private void jButton4ActionPerformed(ActionEvent evt) {
        this.win_key();
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        this.refresh();
    }

    private void fullscreenActionPerformed(ActionEvent evt) {
        this.fullscreen();
    }

    public static void main(String[] args) {
        String host = null;
        int port = 5900;
        String pass = null;
        if (args.length > 0) {
            host = args[0];
        }
        if (args.length > 1) {
            pass = args[1];
        }
        block10: for (int a = 2; a < args.length; ++a) {
            switch (args[a]) {
                case "--debug": {
                    debug = true;
                    RFB.debug = true;
                    JFImage.debug = true;
                    continue block10;
                }
                case "--fast": {
                    fast = true;
                    continue block10;
                }
                case "--lean": {
                    fast = false;
                }
            }
        }
        if (host == null && (host = JFAWT.getString("Enter VNC Host[:port]", "")) == null) {
            return;
        }
        int idx = host.indexOf(58);
        if (idx != -1) {
            port = Integer.valueOf(host.substring(idx + 1));
            host = host.substring(0, idx);
        }
        if (pass == null && (pass = JFAWT.getString("Enter Password", "")) == null) {
            return;
        }
        final String _host = host;
        final int _port = port;
        final String _pass = RFB.checkPassword(pass);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new VNC(_host, _port, _pass).setVisible(true);
            }
        });
    }

    public void setupEvents() {
        if (!is_fullscreen) {
            image.addMouseListener(this);
            image.addMouseMotionListener(this);
            image.addMouseListener(this);
            image.addMouseWheelListener(this);
            image.setFocusable(true);
            image.addKeyListener(this);
            image.setFocusTraversalKeys(0, JFAWT.emptyKeys());
            image.setFocusTraversalKeys(1, JFAWT.emptyKeys());
        }
        this.scroll.setFocusable(false);
        this.scroll.addKeyListener(this);
        this.addKeyListener(this);
    }

    public void keyDown(int code) {
        rfb.writeKeyEvent(code, true);
    }

    public void keyUp(int code) {
        rfb.writeKeyEvent(code, false);
    }

    public void mouse(int x, int y, int buttons) {
        if (debug) {
            JFLog.log("mouse:" + x + "," + y + ":" + buttons);
        }
        rfb.writeMouseEvent(x, y, buttons);
    }

    public void ctrl_alt_del() {
        this.keyDown(65507);
        this.keyDown(65513);
        JF.sleep(10);
        this.keyDown(65535);
        JF.sleep(50);
        this.keyUp(65535);
        JF.sleep(10);
        this.keyUp(65513);
        this.keyUp(65507);
    }

    public void win_key() {
        this.keyDown(65507);
        JF.sleep(10);
        this.keyDown(65307);
        JF.sleep(50);
        this.keyUp(65307);
        JF.sleep(10);
        this.keyUp(65507);
    }

    public void refresh() {
        if (rfb == null) {
            return;
        }
        int width = rfb.getWidth();
        int height = rfb.getHeight();
        rfb.writeBufferUpdateRequest(0, 0, width, height, false);
    }

    public void fullscreen() {
        try {
            if (is_fullscreen) {
                JFLog.log("!fullscreen");
                this.vnc_fullscreen.dispose();
                this.vnc_windowed.setVisible(true);
                this.vnc_windowed.scroll.setViewportView(image);
                is_fullscreen = false;
            } else {
                JFLog.log("fullscreen");
                this.vnc_windowed.setVisible(false);
                this.vnc_fullscreen = new VNC(this);
                this.vnc_fullscreen.setVisible(true);
                this.vnc_fullscreen.scroll.setViewportView(image);
                GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().setFullScreenWindow(this.vnc_fullscreen);
            }
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        int button = e.getButton();
        this.buttons &= 7;
        switch (button) {
            case 1: {
                this.buttons |= 1;
                break;
            }
            case 2: {
                this.buttons |= 2;
                break;
            }
            case 3: {
                this.buttons |= 4;
            }
        }
        this.mouse(x, y, this.buttons);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        int button = e.getButton();
        this.buttons &= 7;
        switch (button) {
            case 1: {
                this.buttons &= 0xE;
                break;
            }
            case 2: {
                this.buttons &= 0xD;
                break;
            }
            case 3: {
                this.buttons &= 0xB;
            }
        }
        this.mouse(x, y, this.buttons);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        this.buttons &= 7;
        this.mouse(x, y, this.buttons);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        this.buttons &= 7;
        this.mouse(x, y, this.buttons);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        int x = e.getX();
        int y = e.getY();
        int wheel = e.getWheelRotation();
        this.buttons &= 7;
        if (wheel < 0) {
            this.buttons |= 8;
        }
        if (wheel > 0) {
            this.buttons |= 0x10;
        }
        this.mouse(x, y, this.buttons);
        this.buttons &= 7;
        this.mouse(x, y, this.buttons);
    }

    @Override
    public void keyTyped(KeyEvent e) {
        e.consume();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        char ch = e.getKeyChar();
        int code = e.getKeyCode();
        if (debugKeys) {
            JFLog.log("VNC:KeyPressed:" + Integer.toString(ch) + ":" + code);
        }
        if (e.isAltDown() && e.isShiftDown() && e.isControlDown()) {
            if (code == 70) {
                this.fullscreen();
            }
            e.consume();
            return;
        }
        if (ch == '\uffff' || ch < ' ' || ch >= '\u007f') {
            ch = (char)VNCRobot.convertJavaKeyCode(code);
        }
        if (e.isControlDown() || e.isAltDown()) {
            ch = Character.toLowerCase(ch);
        }
        e.consume();
        this.keyDown(ch);
    }

    @Override
    public void keyReleased(KeyEvent e) {
        char ch = e.getKeyChar();
        int code = e.getKeyCode();
        if (debugKeys) {
            JFLog.log("VNC:KeyReleased:" + Integer.toString(ch) + ":" + code);
        }
        if (ch == '\uffff' || ch < ' ' || ch >= '\u007f') {
            ch = (char)VNCRobot.convertJavaKeyCode(code);
        }
        if (e.isControlDown() || e.isAltDown()) {
            ch = Character.toLowerCase(ch);
        }
        e.consume();
        this.keyUp(ch);
    }

    static {
        fast = true;
    }

    public class Connect
    extends Thread {
        @Override
        public void run() {
            try {
                while (true) {
                    if ((rfb = new RFB()).connect(VNC.this.host, VNC.this.port)) {
                        float server_version = rfb.readVersion();
                        rfb.writeVersion(RFB.VERSION_3_8);
                        byte[] auths = rfb.readAuthTypes();
                        if (auths == null || auths.length == 0) {
                            JFLog.log("VNC:No auth types available");
                            System.exit(0);
                        }
                        rfb.writeAuthType(auths[0]);
                        boolean ok = false;
                        switch (auths[0]) {
                            case 0: {
                                break;
                            }
                            case 1: {
                                ok = true;
                                break;
                            }
                            case 2: {
                                byte[] challenge = rfb.readAuthChallenge();
                                byte[] response = RFB.encodeResponse(challenge, VNC.this.pass.getBytes());
                                rfb.writeAuthResponse(response);
                                ok = rfb.readAuthResult();
                            }
                        }
                        if (ok) {
                            rfb.writeClientInit(true);
                            if (rfb.readServerInit()) {
                                int width = rfb.getWidth();
                                int height = rfb.getHeight();
                                image = new JFImage(width, height);
                                image.setResizeOperation(JFImage.ResizeOperation.NONE);
                                image.fill(0, 0, width, height, -16777216);
                                VNC.this.setupEvents();
                                VNC.this.setSize(width, height);
                                VNC.this.scroll.setViewportView(image);
                                new MainLoop().start();
                                break;
                            }
                        }
                    }
                    JFLog.log("Connection failed...");
                    rfb = null;
                    VNC.this.pass = JFAWT.getString("Enter Password", VNC.this.pass);
                    if (VNC.this.pass == null) {
                        VNC.this.dispose();
                        System.exit(0);
                    }
                    VNC.this.pass = RFB.checkPassword(VNC.this.pass);
                }
            }
            catch (Exception e) {
                JFLog.log(e);
            }
        }
    }

    public class MainLoop
    extends Thread {
        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            if (fast) {
                rfb.writeEncodingsFast();
            } else {
                rfb.writeEncodingsLean();
            }
            rfb.writePixelFormat();
            int width = rfb.getWidth();
            int height = rfb.getHeight();
            rfb.writeBufferUpdateRequest(0, 0, width, height, false);
            try {
                block9: while (true) {
                    int msg = rfb.readMessageType();
                    switch (msg) {
                        case -1: {
                            VNC.this.dispose();
                            System.exit(0);
                            continue block9;
                        }
                        case 0: {
                            RFB.Rectangle rect = rfb.readBufferUpdate();
                            if (debug) {
                                JFLog.log("VNC:Rectangle Update=" + String.valueOf(rect));
                            }
                            int width2 = rfb.getWidth();
                            int height2 = rfb.getHeight();
                            if (rect.newSize) {
                                if (debug) {
                                    JFLog.log("VNC:New Desktop Size:" + width2 + "x" + height2);
                                }
                                image.setSize(width2, height2);
                                rfb.writeBufferUpdateRequest(0, 0, width2, height2, false);
                            } else {
                                if (debug) {
                                    JFLog.log("VNC:DrawRect:" + String.valueOf(rect));
                                }
                                image.putPixels(rfb.getBuffer(), rect.x, rect.y, rect.width, rect.height, rect.y * width2 + rect.x, width2);
                                rfb.writeBufferUpdateRequest(0, 0, width2, height2, true);
                            }
                            EventQueue.invokeLater(() -> image.repaint());
                            continue block9;
                        }
                        case 2: {
                            rfb.readBell();
                            continue block9;
                        }
                        case 1: {
                            rfb.readColorMap();
                            continue block9;
                        }
                        case 3: {
                            rfb.readCutText();
                            continue block9;
                        }
                    }
                    JFLog.log("Unknown msg:" + msg);
                }
            }
            catch (Exception e) {
                JFLog.log(e);
                return;
            }
        }
    }
}

