/*
 * Decompiled with CFR 0.152.
 */
package javaforce.jni.lnx;

import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.jni.LnxNative;

public class LnxPty {
    private static final boolean debug = false;
    private boolean closed = false;
    private long ctx;
    private Process p;

    public static boolean init() {
        return true;
    }

    public static LnxPty exec(String cmd, String[] args, String[] env) {
        LnxPty pty = new LnxPty();
        if (!pty.fork(cmd, args, env)) {
            return null;
        }
        return pty;
    }

    public static String execOutput(String cmd, String[] args, String[] env) {
        int read;
        LnxPty pty = new LnxPty();
        if (!pty.fork(cmd, args, env)) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        byte[] data = new byte[1024];
        while ((read = pty.read(data)) != -1) {
            sb.append(new String(data, 0, read));
        }
        pty.close();
        return sb.toString();
    }

    public boolean isClosed() {
        return this.closed;
    }

    private boolean fork(String cmd, String[] args, String[] env) {
        int a;
        this.ctx = LnxNative.ptyAlloc();
        String slaveName = LnxNative.ptyOpen(this.ctx);
        if (slaveName == null) {
            return false;
        }
        ArrayList<String> cmdline = new ArrayList<String>();
        cmdline.add("/usr/bin/jfpty");
        cmdline.add(slaveName);
        cmdline.add(cmd);
        cmdline.add(Integer.toString(args.length - 1));
        for (a = 0; a < args.length && args[a] != null; ++a) {
            cmdline.add(args[a]);
        }
        for (a = 0; a < env.length && env[a] != null; ++a) {
            cmdline.add(env[a]);
        }
        String[] cl = cmdline.toArray(JF.StringArrayType);
        try {
            ProcessBuilder pb = new ProcessBuilder(cl);
            String user = System.getenv("USER");
            if (user != null) {
                if (user.equals("root")) {
                    pb.directory(new File("/root"));
                } else {
                    pb.directory(new File("/home/" + user));
                }
            }
            this.p = pb.start();
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
        new Thread(){

            @Override
            public void run() {
                try {
                    LnxPty.this.p.waitFor();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                LnxPty.this.close();
            }
        }.start();
        return true;
    }

    public static void main(String[] args) {
        if (args == null || args.length < 3) {
            System.out.println("Usage : LnxPty slaveName, cmd, #args, [args...], [env...]");
            return;
        }
        LnxPty.init();
        String slaveName = args[0];
        String cmd = args[1];
        int noArgs = JF.atoi(args[2]);
        int p = 3;
        ArrayList<String> process_args = new ArrayList<String>();
        ArrayList<String> process_env = new ArrayList<String>();
        for (int a = 0; a < noArgs; ++a) {
            process_args.add(args[p++]);
        }
        while (p < args.length) {
            process_env.add(args[p++]);
        }
        try {
            LnxNative.ptyChildExec(slaveName, cmd, process_args.toArray(JF.StringArrayType), process_env.toArray(JF.StringArrayType));
            throw new Exception("pty child returned");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
            return;
        }
    }

    public synchronized void close() {
        if (this.closed) {
            return;
        }
        LnxNative.ptyClose(this.ctx);
        this.closed = true;
    }

    public void write(byte[] buf) {
        LnxNative.ptyWrite(this.ctx, buf);
    }

    public int read(byte[] buf) {
        if (this.closed) {
            return -1;
        }
        return LnxNative.ptyRead(this.ctx, buf);
    }

    public void setSize(int x, int y) {
        LnxNative.ptySetSize(this.ctx, x, y);
    }

    public static String[] makeEnvironment(String[] extra) {
        int a;
        ArrayList<Object> env = new ArrayList<Object>();
        Map<String, String> old = System.getenv();
        Set<String> set = old.keySet();
        String[] keys = set.toArray(JF.StringArrayType);
        for (a = 0; a < keys.length; ++a) {
            String key = keys[a];
            env.add(key + "=" + old.get(key));
        }
        if (extra != null) {
            for (a = 0; a < extra.length; ++a) {
                int idx = extra[a].indexOf("=");
                if (idx == -1) continue;
                String key = extra[a].substring(0, idx + 1);
                int cnt = env.size();
                boolean found = false;
                for (int b = 0; b < cnt; ++b) {
                    if (!((String)env.get(b)).startsWith(key)) continue;
                    env.set(b, extra[a]);
                    found = true;
                    break;
                }
                if (found) continue;
                env.add(extra[a]);
            }
        }
        env.add(null);
        return env.toArray(JF.StringArrayType);
    }

    public static String[] makeEnvironment() {
        return LnxPty.makeEnvironment(null);
    }
}

