/*
 * Decompiled with CFR 0.152.
 */
package javaforce.service;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Random;
import javaforce.awt.JFAWT;
import javaforce.awt.JFImage;
import javaforce.awt.ViewLog;
import javaforce.jbus.JBusClient;
import javaforce.service.SMTPServer;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;

public class SMTPApp
extends JFrame {
    private JTextArea config;
    private JButton gen_keys;
    private JButton help;
    private JButton jButton1;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JButton save;
    public ViewLog viewer;
    public JBusClient busClient;

    public SMTPApp() {
        this.initComponents();
        JFImage img = new JFImage();
        img.loadPNG(this.getClass().getResourceAsStream("/javaforce/icons/smtp.png"));
        this.setIconImage(img.getImage());
        new Thread(){

            @Override
            public void run() {
                Random r = new Random();
                SMTPApp.this.busClient = new JBusClient("net.sf.jfsmtp.client" + r.nextInt(), new JBusMethods());
                SMTPApp.this.busClient.setPort(SMTPServer.getBusPort());
                SMTPApp.this.busClient.start();
                SMTPApp.this.busClient.call("net.sf.jfsmtp", "getConfig", "\"" + SMTPApp.this.busClient.pack + "\"");
            }
        }.start();
        JFAWT.centerWindow(this);
    }

    public void writeConfig() {
        this.busClient.call("net.sf.jfsmtp", "setConfig", JBusClient.quote(JBusClient.encodeString(this.config.getText())));
    }

    public void restart() {
        this.busClient.call("net.sf.jfsmtp", "restart", "");
    }

    private void initComponents() {
        this.save = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.config = new JTextArea();
        this.jLabel1 = new JLabel();
        this.jButton1 = new JButton();
        this.gen_keys = new JButton();
        this.help = new JButton();
        this.setDefaultCloseOperation(3);
        this.setTitle("SMTP Server");
        this.save.setText("Save");
        this.save.setEnabled(false);
        this.save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SMTPApp.this.saveActionPerformed(evt);
            }
        });
        this.config.setColumns(20);
        this.config.setRows(5);
        this.config.setText(" [ loading ... ]\n");
        this.config.setEnabled(false);
        this.jScrollPane1.setViewportView(this.config);
        this.jLabel1.setText("SMTP Configuration:");
        this.jButton1.setText("View Log");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SMTPApp.this.jButton1ActionPerformed(evt);
            }
        });
        this.gen_keys.setText("Generate SSL Key");
        this.gen_keys.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SMTPApp.this.gen_keysActionPerformed(evt);
            }
        });
        this.help.setText("Help");
        this.help.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SMTPApp.this.helpActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 583, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jButton1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.gen_keys).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.help).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.save)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 418, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.save).addComponent(this.jButton1).addComponent(this.gen_keys).addComponent(this.help)).addContainerGap()));
        this.pack();
    }

    private void saveActionPerformed(ActionEvent evt) {
        this.writeConfig();
        this.restart();
        JFAWT.showMessage("Notice", "Settings saved!");
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.showViewLog();
    }

    private void gen_keysActionPerformed(ActionEvent evt) {
        this.genKeys();
    }

    private void helpActionPerformed(ActionEvent evt) {
        this.showHelp();
    }

    public static void main(String[] args) {
        String[] stringArray = args;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String arg;
            switch (arg = stringArray[i]) {
                case "createKeys": {
                    SMTPServer.createKeys();
                    System.exit(0);
                }
            }
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new SMTPApp().setVisible(true);
            }
        });
    }

    public void showViewLog() {
        if (this.viewer == null || this.viewer.isClosed) {
            this.viewer = new ViewLog(new File(SMTPServer.getLogFile()));
            this.viewer.setTitle("SMTP Log");
        }
        this.viewer.setVisible(true);
    }

    private void genKeys() {
        this.busClient.call("net.sf.jfsmtp", "genKeys", "\"" + this.busClient.pack + "\"");
    }

    private void showHelp() {
        JFAWT.openURL("http://jfsmtp.sf.net/help.html");
    }

    public class JBusMethods {
        public void getConfig(String cfg) {
            final String _cfg = cfg;
            EventQueue.invokeLater(new Runnable(){
                final /* synthetic */ JBusMethods this$1;
                {
                    this.this$1 = this$1;
                }

                @Override
                public void run() {
                    this.this$1.SMTPApp.this.config.setText(JBusClient.decodeString(_cfg));
                    this.this$1.SMTPApp.this.config.setEnabled(true);
                    this.this$1.SMTPApp.this.save.setEnabled(true);
                }
            });
        }

        public void getKeys(final String status) {
            EventQueue.invokeLater(new Runnable(){
                final /* synthetic */ JBusMethods this$1;
                {
                    this.this$1 = this$1;
                }

                @Override
                public void run() {
                    if (status.equals("OK")) {
                        JFAWT.showMessage("GenKeys", "OK");
                    } else {
                        JFAWT.showError("GenKeys", "Error");
                    }
                }
            });
        }
    }
}

