/*
 * Decompiled with CFR 0.152.
 */
package javaforce.service;

import java.io.InputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import javaforce.Base64;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.KeyMgmt;
import javaforce.service.WebHandler;
import javaforce.service.WebRequest;
import javaforce.service.WebResponse;
import javaforce.service.WebSocket;
import javaforce.service.WebSocketHandler;
import javaforce.service.WebUpload;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLServerSocket;

public class WebServer {
    private WebHandler api;
    private WebSocketHandler wsapi;
    private ServerSocket ss;
    private boolean secure;
    private boolean active = true;
    private ArrayList<Connection> clients = new ArrayList();
    private Object clientsLock = new Object();
    public static boolean config_enable_gzip = true;
    public static boolean debug = false;
    private static String upload_folder;

    public boolean start(WebHandler api, int port) {
        return this.start(api, port, null);
    }

    public boolean start(WebHandler api, int port, KeyMgmt keys) {
        this.secure = true;
        this.api = api;
        try {
            this.ss = keys != null ? JF.createServerSocketSSL(port, keys) : new ServerSocket(port);
            if (this.ss == null) {
                throw new Exception("Failed to start server on port:" + port);
            }
            new Server(this).start();
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
        return true;
    }

    public void setWebSocketHandler(WebSocketHandler wsapi) {
        this.wsapi = wsapi;
    }

    public void setUploadFolder(String folder) {
        upload_folder = folder;
    }

    public void stop() {
        this.active = false;
        if (this.ss != null) {
            try {
                this.ss.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.ss = null;
        }
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (WebServer.this.clients.size() > 0) {
                    Object object = WebServer.this.clientsLock;
                    synchronized (object) {
                        if (WebServer.this.clients.size() == 0) {
                            break;
                        }
                        Connection conn = WebServer.this.clients.get(0);
                        conn.cancel();
                    }
                    JF.sleep(100);
                }
            }
        }.start();
    }

    public void setClientVerify(boolean state) {
        SSLServerSocket ssl = (SSLServerSocket)this.ss;
        ssl.setNeedClientAuth(state);
    }

    public static byte[] chunkHeader(byte[] in) {
        return String.format("%x\r\n", in.length).getBytes();
    }

    private static class Server
    extends Thread {
        private WebServer web;

        public Server(WebServer web2) {
            this.web = web2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.setName("WebServer.Server");
            while (this.web.active) {
                try {
                    Socket s = this.web.ss.accept();
                    Connection conn = new Connection(this.web, s);
                    Object object = this.web.clientsLock;
                    synchronized (object) {
                        this.web.clients.add(conn);
                    }
                    conn.start();
                }
                catch (SocketException e) {
                    if (!debug) continue;
                    JFLog.log("WebServer.Server:disconnected");
                }
                catch (Exception e) {
                    JFLog.log(e);
                }
            }
        }
    }

    private static class Connection
    extends Thread {
        private Socket s;
        private InputStream is;
        private WebServer web;

        public Connection(WebServer web2, Socket s) {
            this.web = web2;
            this.s = s;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.setName("WebServer.Connection");
            try {
                int ch;
                StringBuilder request = new StringBuilder();
                this.is = this.s.getInputStream();
                while (this.web.active && this.s.isConnected() && (ch = this.is.read()) != -1) {
                    request.append((char)ch);
                    if (!request.toString().endsWith("\r\n\r\n")) continue;
                    if (debug) {
                        JFLog.log("WebServer:Request detected!");
                    }
                    WebRequest req = new WebRequest();
                    req.secure = this.web.secure;
                    req.request = request.toString();
                    req.fields = req.request.split("\r\n");
                    req.is = this.is;
                    req.serverIP = this.s.getLocalAddress().getHostAddress();
                    if (req.serverIP.equals("0:0:0:0:0:0:0:1")) {
                        req.serverIP = "127.0.0.1";
                    }
                    req.serverPort = this.s.getLocalPort();
                    req.remoteIP = this.s.getInetAddress().getHostAddress();
                    req.remotePort = this.s.getPort();
                    WebResponse res = new WebResponse();
                    res.os = this.s.getOutputStream();
                    req.fields0 = req.fields[0].split(" ");
                    req.init(res);
                    if (this.isWebSocketRequest(req)) {
                        if (debug) {
                            JFLog.log("WebServer:WEB_SOCKET");
                        }
                        WebSocket socket = new WebSocket(this.s.getInetAddress().getHostAddress());
                        socket.is = this.is;
                        socket.os = res.os;
                        socket.url = req.fields0[1];
                        if (this.web.wsapi != null && this.web.wsapi.doWebSocketConnect(socket)) {
                            this.sendWebSocketAccepted(req, res);
                            this.processWebSocket(socket);
                            break;
                        }
                        this.sendWebSocketDenied(req, res);
                        break;
                    }
                    if (WebUpload.isMultipartContent(req)) {
                        if (debug) {
                            JFLog.log("WebServer:Upload detected!");
                        }
                        if (upload_folder == null) {
                            res.setStatus(501, "Error - Uploads disabled");
                        } else {
                            WebUpload upload = new WebUpload();
                            upload.processRequest(req, upload_folder);
                        }
                    } else if (req.fields0[0].equals("GET")) {
                        if (debug) {
                            JFLog.log("WebServer:GET:" + req.getQueryString());
                        }
                        req.method = "GET";
                        this.web.api.doGet(req, res);
                    } else if (req.fields0[0].equals("POST")) {
                        if (debug) {
                            JFLog.log("WebServer:POST:" + req.getQueryString());
                        }
                        req.method = "POST";
                        this.web.api.doPost(req, res);
                    } else {
                        if (debug) {
                            JFLog.log("WebServer:Unknown request!");
                        }
                        res.setStatus(501, "Error - Unsupported Method");
                    }
                    res.writeAll(req);
                    if (req.fields0[2].equals("HTTP/1.0")) break;
                    request.setLength(0);
                }
                if (this.s != null) {
                    this.s.close();
                    this.s = null;
                }
            }
            catch (SSLHandshakeException ssl) {
                if (debug) {
                    JFLog.log("WebServer.Connection:SSL error");
                }
            }
            catch (SocketException e) {
                if (debug) {
                    JFLog.log("WebServer.Connection:disconnected");
                }
            }
            catch (Exception e) {
                JFLog.log(e);
            }
            Object object = this.web.clientsLock;
            synchronized (object) {
                this.web.clients.remove(this);
            }
        }

        public void cancel() {
            if (this.s != null) {
                try {
                    this.s.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.s = null;
            }
        }

        private boolean isWebSocketRequest(WebRequest req) {
            boolean upgrade = false;
            boolean websocket = false;
            boolean haveKey = false;
            for (int a = 0; a < req.fields.length; ++a) {
                String field = req.fields[a];
                if (field.startsWith("Connection:") && field.indexOf("Upgrade") != -1) {
                    upgrade = true;
                }
                if (field.startsWith("Upgrade:") && field.indexOf("websocket") != -1) {
                    websocket = true;
                }
                if (!field.startsWith("Sec-WebSocket-Key:")) continue;
                haveKey = true;
            }
            return upgrade && websocket && haveKey;
        }

        private String encodeKey(String inKey) {
            inKey = (String)inKey + "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
            MessageDigest md = null;
            try {
                md = MessageDigest.getInstance("SHA-1");
            }
            catch (NoSuchAlgorithmException e) {
                JFLog.log(e);
            }
            byte[] sha1 = md.digest(((String)inKey).getBytes());
            String base64 = new String(Base64.encode(sha1));
            return base64;
        }

        private void sendWebSocketAccepted(WebRequest req, WebResponse res) {
            res.setStatus(101, "Switching Protocols");
            res.addHeader("Upgrade: websocket");
            res.addHeader("Connection: Upgrade");
            String inKey = null;
            String[] protocols = null;
            for (int a = 0; a < req.fields.length; ++a) {
                String field = req.fields[a];
                if (field.startsWith("Sec-WebSocket-Key:")) {
                    inKey = field.substring(18).trim();
                }
                if (!field.startsWith("Sec-WebSocket-Protcol:")) continue;
                protocols = field.substring(22).trim().split(",");
            }
            String outKey = this.encodeKey(inKey);
            res.addHeader("Sec-WebSocket-Accept: " + outKey);
            try {
                res.writeAll(req);
            }
            catch (Exception e) {
                JFLog.log(e);
            }
        }

        private void sendWebSocketDenied(WebRequest req, WebResponse res) {
            res.setStatus(403, "Access Denied");
            try {
                res.writeAll(req);
            }
            catch (Exception e) {
                JFLog.log(e);
            }
        }

        private void processWebSocket(WebSocket socket) {
            byte[] maskKey = new byte[4];
            try {
                while (this.web.active) {
                    boolean fin;
                    int opcode = socket.is.read();
                    if (opcode == -1) {
                        throw new Exception("socket error");
                    }
                    boolean bl = fin = (opcode & 0x80) == 128;
                    if ((opcode &= 0xF) != 8) {
                        int a;
                        long length = 0L;
                        int len7 = socket.is.read();
                        if (len7 == -1) {
                            throw new Exception("socket error");
                        }
                        boolean hasMask = (len7 & 0x80) == 128;
                        switch (len7 &= 0x7F) {
                            case 126: {
                                for (a = 0; a < 2; ++a) {
                                    int len8 = socket.is.read();
                                    if (len8 == -1) {
                                        throw new Exception("socket error");
                                    }
                                    length <<= 8;
                                    length |= (long)len8;
                                }
                                break;
                            }
                            case 127: {
                                for (int a2 = 0; a2 < 8; ++a2) {
                                    long len8 = socket.is.read();
                                    if (len8 == -1L) {
                                        throw new Exception("socket error");
                                    }
                                    length <<= 8;
                                    length |= len8;
                                }
                                break;
                            }
                            default: {
                                length = len7;
                            }
                        }
                        if (hasMask) {
                            for (a = 0; a < 4; ++a) {
                                int mask8 = socket.is.read();
                                if (mask8 == -1) {
                                    throw new Exception("socket error");
                                }
                                maskKey[a] = (byte)mask8;
                            }
                        } else {
                            throw new Exception("WebSocket message without mask");
                        }
                        if (length > 0x1000000L) {
                            throw new Exception("WebSocket message > 16MB");
                        }
                        byte[] data = JF.readAll(socket.is, (int)length);
                        int a3 = 0;
                        while ((long)a3 < length) {
                            int n = a3;
                            data[n] = (byte)(data[n] ^ maskKey[a3 % 4]);
                            ++a3;
                        }
                        if (opcode == 9) {
                            socket.write(data, 10);
                            continue;
                        }
                        if (opcode > 8) continue;
                        this.web.wsapi.doWebSocketMessage(socket, data, opcode);
                        continue;
                    }
                    break;
                }
            }
            catch (SocketException e) {
                if (debug) {
                    JFLog.log("WebServer.Websocket:disconnected");
                }
            }
            catch (Exception e) {
                JFLog.log(e);
            }
            this.web.wsapi.doWebSocketClosed(socket);
        }
    }
}

