/*
 * Decompiled with CFR 0.152.
 */
package javaforce.utils;

import java.io.File;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.utils.BuildTools;
import javaforce.utils.GenPkgInfo;

public class GenPAC {
    private BuildTools tools;

    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("Usage:GenPAC build.xml deps");
            System.exit(1);
        }
        try {
            new GenPAC().run(args[0], args[1]);
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    public void run(String buildfile, String deps) throws Exception {
        this.tools = new BuildTools();
        if (!this.tools.loadXML(buildfile)) {
            throw new Exception("error loading " + buildfile);
        }
        String files = "files.lst";
        if (new File("files-pac.lst").exists()) {
            files = "files-pac.lst";
        }
        if (!BuildTools.checkFiles(files)) {
            System.exit(1);
        }
        String arch = GenPAC.getArch();
        String archext = GenPAC.getArchExt();
        String app = this.tools.getProperty("app");
        Object apptype = this.tools.getProperty("apptype");
        String version = this.tools.getProperty("version");
        String home = this.tools.getProperty("home");
        switch (apptype) {
            case "client": 
            case "server": {
                apptype = "-" + (String)apptype;
                break;
            }
            default: {
                apptype = "";
            }
        }
        String out = app + (String)apptype + "-" + version + "-" + archext + ".pkg.tar.xz";
        String files_tmp = ".files.tmp";
        String data = ".MTREE";
        Runtime rt = Runtime.getRuntime();
        boolean debug = System.getenv("DEBUG") != null;
        try {
            GenPkgInfo.main(new String[]{"arch", arch, files, deps});
            new File(files_tmp).delete();
            JF.echoAppend(".PKGINFO\n", files_tmp);
            JF.echoAppend(".MTREE\n", files_tmp);
            JF.copyAllAppend(files, files_tmp);
            rt.exec(new String[]{"bsdtar", "-czf", data, "--format=mtree", "--options='!all,use-set,type,uid,gid,mode,time,size,md5,sha256,link'", "-T", files}).waitFor();
            rt.exec(new String[]{"tar", "cf", out, "-T", files_tmp}).waitFor();
            if (!debug) {
                new File(data).delete();
                new File(".PKGINFO").delete();
                new File(data).delete();
                new File(files_tmp).delete();
            }
            System.out.println(out + " created!");
            if (new File(home + "/repo/arch/readme.txt").exists() && !JF.moveFile(out, home + "/repo/arch/latest/" + archext + "/" + out)) {
                throw new Exception("move failed");
            }
            System.exit(0);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static String getArch() {
        String arch = System.getenv("HOSTTYPE");
        if (arch == null && (arch = System.getProperty("os.arch")) == null) {
            JFLog.log("Error:Unable to detect CPU from env:HOSTTYPE or property:os.arch");
        }
        switch (arch) {
            case "amd64": {
                return "x86_64";
            }
            case "arm64": {
                return "aarch64";
            }
        }
        return arch;
    }

    public static String getArchExt() {
        return GenPAC.getArch();
    }
}

