/*
 * Decompiled with CFR 0.152.
 */
package javaforce.voip;

import java.util.Random;
import javaforce.JFLog;
import javaforce.voip.Packet;
import javaforce.voip.PacketReceiver;
import javaforce.voip.RTP;
import javaforce.voip.RTPChannel;
import javaforce.voip.RTPVideoCoder;

public class RTPJPEG
implements RTPVideoCoder {
    private static final int mtu = 1438;
    private int seqnum;
    private int timestamp;
    private int ssrc = new Random().nextInt();
    private Packet packet = new Packet();
    public static final int maxSize = 0x400000;
    private static final int M = 128;
    private int rtp_id;

    public RTPJPEG() {
        this.packet.data = new byte[0x400000];
    }

    @Override
    public void setid(int id) {
        this.rtp_id = id;
    }

    @Override
    public void encode(byte[] jpeg, int offset, int length, int x, int y, PacketReceiver pr) {
        int cnt = (length + 1438 - 1) / 1438;
        int len = length;
        int pos = offset;
        for (int a = 0; a < cnt; ++a) {
            int packetLength = len > 1438 ? 1438 : len;
            this.packet.length = packetLength + 12 + 8;
            RTPChannel.buildHeader(this.packet.data, RTP.CODEC_JPEG.id, this.seqnum, this.timestamp, this.ssrc, a == cnt - 1);
            RTPJPEG.buildHeader(this.packet.data, x, y, pos);
            System.arraycopy(jpeg, pos, this.packet.data, 20, packetLength);
            pos += packetLength;
            len -= packetLength;
            if (a == cnt - 1) {
                this.packet.data[1] = (byte)(this.packet.data[1] | 0x80);
            }
            pr.onPacket(this.packet);
        }
        ++this.seqnum;
        this.packet.length = 0;
        this.timestamp += 100;
    }

    @Override
    public void decode(byte[] rtp, int offset, int length, PacketReceiver pr) {
        if (rtp.length < 20) {
            return;
        }
        int off = rtp[13] & 0xFF;
        off <<= 8;
        off += rtp[14] & 0xFF;
        off <<= 8;
        if ((off += rtp[15] & 0xFF) != this.packet.length) {
            JFLog.log("RTPJPEG:decode:lost a packet or not in order");
            this.packet.length = 0;
            return;
        }
        int jpegLength = rtp.length - 12 - 8;
        int partialLength = this.packet.length;
        System.arraycopy(rtp, 20, this.packet.data, partialLength, jpegLength);
        if ((rtp[1] & 0x80) == 128) {
            pr.onPacket(this.packet);
            this.packet.length = 0;
        }
    }

    private static void buildHeader(byte[] data, int x, int y, int offset) {
        data[12] = 0;
        data[13] = (byte)((offset & 0xFF0000) >> 16);
        data[14] = (byte)((offset & 0xFF00) >> 8);
        data[15] = (byte)(offset & 0xFF);
        data[16] = 0;
        data[17] = 0;
        data[18] = (byte)(x / 8);
        data[19] = (byte)(y / 8);
    }
}

