/*
 * Decompiled with CFR 0.152.
 */
package javaforce.webui.tasks;

import javaforce.BE;
import javaforce.JF;

public class TaskEvent {
    public long task_id;
    public long time_start;
    public long time_complete;
    public long time_duration;
    public String action = "";
    public String result = "";
    public boolean successful;
    public String user = "";
    public String ip = "";
    public static final TaskEvent[] ArrayType = new TaskEvent[0];
    private static byte VERSION = 1;
    private static int FLAG_SUCCESSFUL = 1;
    private static Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long gen_task_id() {
        Object object = lock;
        synchronized (object) {
            long task_id = System.currentTimeMillis();
            JF.sleep(3);
            return task_id;
        }
    }

    public TaskEvent() {
    }

    public TaskEvent(String action, String user, String ip) {
        this.task_id = TaskEvent.gen_task_id();
        this.action = action;
        this.user = user;
        this.ip = ip;
    }

    public static TaskEvent create(String action, String user, String ip) {
        TaskEvent event = new TaskEvent();
        event.task_id = TaskEvent.gen_task_id();
        event.action = action;
        event.user = user;
        event.ip = ip;
        return event;
    }

    public static TaskEvent fromByteArray(byte[] data, int offset, int length) {
        TaskEvent event = new TaskEvent();
        byte version = data[offset];
        event.task_id = BE.getuint64(data, ++offset);
        event.time_start = BE.getuint64(data, offset += 8);
        event.time_complete = BE.getuint64(data, offset += 8);
        event.time_duration = BE.getuint64(data, offset += 8);
        int flags = BE.getuint32(data, offset += 8);
        event.successful = (flags & FLAG_SUCCESSFUL) != 0;
        int action_length = BE.getuint32(data, offset += 4);
        event.action = BE.getString(data, offset += 4, action_length);
        int result_length = BE.getuint32(data, offset += action_length);
        event.result = BE.getString(data, offset += 4, result_length);
        int user_length = BE.getuint32(data, offset += result_length);
        event.user = BE.getString(data, offset += 4, user_length);
        int ip_length = BE.getuint32(data, offset += user_length);
        event.ip = BE.getString(data, offset += 4, ip_length);
        offset += ip_length;
        return event;
    }

    public byte[] toByteArray() {
        int action_length = this.action.length();
        int result_length = this.result.length();
        int user_length = this.user.length();
        int ip_length = this.ip.length();
        int length = 37 + (4 + action_length) + (4 + result_length) + (4 + user_length) + (4 + ip_length);
        byte[] data = new byte[4 + length];
        int offset = 0;
        BE.setuint32(data, offset, length);
        data[offset += 4] = VERSION;
        BE.setuint64(data, ++offset, this.task_id);
        BE.setuint64(data, offset += 8, this.time_start);
        BE.setuint64(data, offset += 8, this.time_complete);
        BE.setuint64(data, offset += 8, this.time_duration);
        offset += 8;
        int flags = 0;
        if (this.successful) {
            flags |= FLAG_SUCCESSFUL;
        }
        BE.setuint32(data, offset, flags);
        BE.setuint32(data, offset += 4, action_length);
        BE.setString(data, offset += 4, action_length, this.action);
        BE.setuint32(data, offset += action_length, result_length);
        BE.setString(data, offset += 4, result_length, this.result);
        BE.setuint32(data, offset += result_length, user_length);
        BE.setString(data, offset += 4, user_length, this.user);
        BE.setuint32(data, offset += user_length, ip_length);
        BE.setString(data, offset += 4, ip_length, this.ip);
        offset += ip_length;
        return data;
    }
}

