/*
 * Decompiled with CFR 0.152.
 */
package javaforce;

import java.util.Arrays;

public class JFArrayChar {
    private char[] buf = new char[initSize];
    private int count = 0;
    public static int initSize = 64;

    public int size() {
        return this.count;
    }

    public void clear() {
        this.count = 0;
        if (this.buf.length != initSize) {
            this.buf = new char[initSize];
        }
    }

    public void append(char f) {
        int newcount = this.count + 1;
        if (newcount > this.buf.length) {
            this.buf = Arrays.copyOf(this.buf, Math.max(this.buf.length << 1, newcount));
        }
        this.buf[this.count] = f;
        this.count = newcount;
    }

    public void append(char[] f) {
        int newcount = this.count + f.length;
        if (newcount > this.buf.length) {
            this.buf = Arrays.copyOf(this.buf, Math.max(this.buf.length << 1, newcount));
        }
        System.arraycopy(f, 0, this.buf, this.count, f.length);
        this.count = newcount;
    }

    public void set(char[] s, int pos) {
        int newcount = pos + s.length;
        if (newcount > this.buf.length) {
            this.buf = Arrays.copyOf(this.buf, Math.max(this.buf.length << 1, newcount));
        }
        System.arraycopy(s, 0, this.buf, pos, s.length);
    }

    public char[] toArray() {
        return Arrays.copyOf(this.buf, this.count);
    }

    public char[] toArray(int pos, int length) {
        return Arrays.copyOfRange(this.buf, pos, pos + length);
    }

    public char[] getBuffer() {
        return this.buf;
    }
}

