/*
 * Decompiled with CFR 0.152.
 */
package javaforce.ansi.client;

import java.util.Arrays;

public class Line {
    public int len;
    public char[] chs;
    public int[] fcs;
    public int[] bcs;
    public boolean[] blinks;
    public boolean dirty;
    public int y;

    public Line(int len, int fc, int bc) {
        this.len = len;
        this.chs = new char[len];
        this.fcs = new int[len];
        this.bcs = new int[len];
        this.blinks = new boolean[len];
        this.clear(fc, bc);
        this.dirty = true;
    }

    public void clear(int fc, int bc) {
        for (int x = 0; x < this.len; ++x) {
            this.chs[x] = 32;
            this.fcs[x] = fc;
            this.bcs[x] = bc;
            this.blinks[x] = false;
        }
    }

    public void set(int x, int fc, int bc) {
        this.chs[x] = 32;
        this.fcs[x] = fc;
        this.bcs[x] = bc;
        this.blinks[x] = false;
    }

    public void copy(int dst, int src) {
        this.chs[dst] = this.chs[src];
    }

    public void setlen(int len, int fc, int bc) {
        int oldlen = this.len;
        if (oldlen == len) {
            return;
        }
        this.chs = Arrays.copyOf(this.chs, len);
        this.fcs = Arrays.copyOf(this.fcs, len);
        this.bcs = Arrays.copyOf(this.bcs, len);
        this.blinks = Arrays.copyOf(this.blinks, len);
        for (int i = oldlen; i < len; ++i) {
            this.chs[i] = 32;
            this.fcs[i] = fc;
            this.bcs[i] = bc;
            this.blinks[i] = false;
        }
        this.len = len;
        this.dirty = true;
    }
}

