/*
 * Decompiled with CFR 0.152.
 */
package javaforce.controls.ni;

import javaforce.BE;
import javaforce.controls.Controller;

public class DAQmx {
    public static boolean loaded;
    private long handle;
    private types type;
    private int chs = 1;

    public static void load() {
        if (!loaded) {
            loaded = DAQmx.daqInit();
        }
    }

    private static native boolean daqInit();

    public static native long createTask();

    public static native boolean createChannelAnalog(long var0, String var2, double var3, long var5, double var7, double var9);

    public static native boolean createChannelDigital(long var0, String var2, double var3, long var5);

    public static native boolean createChannelCounter(long var0, String var2, double var3, long var5, double var7, double var9, String var11, double var12, int var14);

    public static native boolean startTask(long var0);

    public static native int readTaskAnalog(long var0, int var2, double[] var3);

    public static native int readTaskBinary(long var0, int var2, int[] var3);

    public static native int readTaskDigital(long var0, int var2, int[] var3);

    public static native int readTaskCounter(long var0, int var2, double[] var3);

    public static native boolean stopTask(long var0);

    public static native boolean clearTask(long var0);

    public static native void printError();

    public boolean connect(String url) {
        int idx = url.indexOf(47);
        Object device = url.substring(0, idx);
        Object port = url.substring(idx + 1);
        int samples = (int)Controller.rate;
        if (samples == 0) {
            samples = 1;
        }
        samples = 1;
        if (((String)port).startsWith("ai")) {
            this.type = types.AI;
            this.handle = DAQmx.createTask();
            if (!DAQmx.createChannelAnalog(this.handle, url, Controller.rate, samples, -10.0, 10.0)) {
                return false;
            }
            if (DAQmx.startTask(this.handle)) {
                return true;
            }
            DAQmx.printError();
            return false;
        }
        if (((String)port).startsWith("port")) {
            String ln;
            String[] yz;
            this.type = types.DI;
            this.handle = DAQmx.createTask();
            if (!DAQmx.createChannelDigital(this.handle, url, Controller.rate, samples)) {
                return false;
            }
            int li = url.lastIndexOf("/");
            if (li != -1 && (yz = (ln = url.substring(li + 1 + 4)).split(":")).length == 2) {
                int y = Integer.valueOf(yz[0]);
                int z = Integer.valueOf(yz[1]);
                this.chs = z - y + 1;
            }
            if (DAQmx.startTask(this.handle)) {
                return true;
            }
            DAQmx.printError();
            return false;
        }
        if (((String)port).startsWith("ctr")) {
            this.type = types.CI;
            this.handle = DAQmx.createTask();
            String[] p = url.split("/");
            device = p[0] + "/" + p[1];
            if (!DAQmx.createChannelCounter(this.handle, (String)device, 2.0E7, samples, 2.0, 1000.0, (String)(port = "/" + p[0] + "/" + p[2]), 1.0 / Controller.rate, 4)) {
                return false;
            }
            if (DAQmx.startTask(this.handle)) {
                return true;
            }
            DAQmx.printError();
            return false;
        }
        System.out.println("Unsupported DAQmx host:" + url);
        return false;
    }

    public void close() {
        if (this.handle != 0L) {
            DAQmx.stopTask(this.handle);
            DAQmx.clearTask(this.handle);
            this.handle = 0L;
        }
    }

    public byte[] read() {
        int read = 0;
        byte[] out = null;
        switch (this.type.ordinal()) {
            case 0: {
                double[] data = new double[this.chs];
                read = DAQmx.readTaskAnalog(this.handle, 1, data);
                out = new byte[this.chs * 8];
                int pos = 0;
                for (int a = 0; a < this.chs; ++a) {
                    BE.setuint64(out, pos, Double.doubleToLongBits(data[a]));
                    pos += 8;
                }
                break;
            }
            case 1: {
                int[] data = new int[this.chs];
                read = DAQmx.readTaskDigital(this.handle, this.chs, data);
                out = new byte[this.chs];
                int pos = 0;
                for (int a = 0; a < this.chs; ++a) {
                    int n = pos++;
                    out[n] = (byte)(out[n] | (byte)data[a]);
                    if (pos != this.chs) continue;
                    pos = 0;
                }
                break;
            }
            case 2: {
                double[] data = new double[this.chs];
                read = DAQmx.readTaskCounter(this.handle, 1, data);
                out = new byte[this.chs * 8];
                int pos = 0;
                for (int a = 0; a < this.chs; ++a) {
                    BE.setuint64(out, pos, Double.doubleToLongBits(data[a]));
                    pos += 8;
                }
                break;
            }
        }
        if (read != this.chs) {
            DAQmx.printError();
        }
        return out;
    }

    private static enum types {
        AI,
        DI,
        CI;

    }
}

