/*
 * Decompiled with CFR 0.152.
 */
package javaforce.jni;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Comparator;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.jni.Library;

public class JFNative {
    private static boolean loaded;

    public static void load() {
        if (loaded) {
            return;
        }
        String loader = System.getProperty("javaforce.loader");
        if (loader != null) {
            return;
        }
        System.out.println("Loading javaforce native library...");
        String path = JF.getCurrentPath();
        String file = "/jfnative64";
        String ext = Library.getExt();
        try {
            System.load(path + file + ext);
        }
        catch (Throwable t) {
            JFLog.log(t);
        }
        loaded = true;
    }

    public static boolean findLibraries(File[] folders, Library[] libs, String ext) {
        for (int i = 0; i < libs.length; ++i) {
            if (JF.isUnix()) {
                libs[i].name = "lib" + libs[i].name;
            }
            libs[i].match = libs[i].name + "([-][0-9]*)?" + ext + "([.][0-9]*)*";
        }
        for (int fn = 0; fn < folders.length; ++fn) {
            File[] files = folders[fn].listFiles();
            if (files == null || files.length == 0) continue;
            Arrays.sort(files, new Comparator<File>(){

                @Override
                public int compare(File f1, File f2) {
                    boolean d1 = f1.isDirectory();
                    boolean d2 = f2.isDirectory();
                    if (d1 && d2) {
                        return 0;
                    }
                    if (d1) {
                        return 1;
                    }
                    if (d2) {
                        return -1;
                    }
                    return 0;
                }
            });
            block2: for (int a = 0; a < files.length; ++a) {
                File file = files[a];
                String fileName = files[a].getName();
                if (file.isDirectory() || !fileName.contains(ext)) continue;
                for (int b = 0; b < libs.length; ++b) {
                    if (!fileName.matches(libs[b].match)) continue;
                    String path = file.getAbsolutePath();
                    if (libs[b].path != null && path.length() <= libs[b].path.length()) continue;
                    libs[b].path = path;
                    continue block2;
                }
            }
        }
        boolean ok = true;
        for (int i = 0; i < libs.length; ++i) {
            if (libs[i].path != null) continue;
            JFLog.log("Unable to find library:" + libs[i].name);
            ok = false;
        }
        return ok;
    }

    public static native ByteBuffer allocate(int var0);

    public static native void free(ByteBuffer var0);

    static {
        JFNative.load();
        loaded = false;
    }
}

