/*
 * Decompiled with CFR 0.152.
 */
package javaforce.tests.webui;

import java.io.ByteArrayOutputStream;
import java.util.Random;
import javaforce.HTTP;
import javaforce.JFLog;
import javaforce.awt.JFImage;
import javaforce.service.WebRequest;
import javaforce.service.WebResponse;
import javaforce.webui.Button;
import javaforce.webui.Canvas;
import javaforce.webui.CheckBox;
import javaforce.webui.Color;
import javaforce.webui.Column;
import javaforce.webui.ComboBox;
import javaforce.webui.Component;
import javaforce.webui.FlexBox;
import javaforce.webui.GridLayout;
import javaforce.webui.Icon;
import javaforce.webui.Image;
import javaforce.webui.InnerPanel;
import javaforce.webui.Label;
import javaforce.webui.ListBox;
import javaforce.webui.Menu;
import javaforce.webui.MenuBar;
import javaforce.webui.MenuItem;
import javaforce.webui.Panel;
import javaforce.webui.Point;
import javaforce.webui.PopupPanel;
import javaforce.webui.ProgressBar;
import javaforce.webui.Resource;
import javaforce.webui.Row;
import javaforce.webui.ScrollPanel;
import javaforce.webui.Slider;
import javaforce.webui.SplitPanel;
import javaforce.webui.TabPanel;
import javaforce.webui.Table;
import javaforce.webui.TextArea;
import javaforce.webui.TextField;
import javaforce.webui.ToggleButton;
import javaforce.webui.Tree;
import javaforce.webui.TreeNode;
import javaforce.webui.UploadButton;
import javaforce.webui.WebUIClient;
import javaforce.webui.WebUIHandler;
import javaforce.webui.WebUIServer;
import javaforce.webui.event.Changed;

public class TestWebUI
implements WebUIHandler {
    public Resource img;
    private int value = 50;

    public TestWebUI() {
        JFImage i = new JFImage(64, 64);
        i.line(0, 0, 63, 63, Color.red);
        i.line(63, 0, 0, 63, Color.red);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        i.savePNG(baos);
        this.img = Resource.registerResource(baos.toByteArray(), "image/png");
    }

    public static void main(String[] args) {
        WebUIServer svr = new WebUIServer();
        svr.start(new TestWebUI(), 8080);
        svr.setUploadFolder(".");
    }

    @Override
    public void clientConnected(WebUIClient client) {
    }

    @Override
    public void clientDisconnected(WebUIClient client) {
    }

    @Override
    public byte[] getResource(String url, HTTP.Parameters params, WebRequest request, WebResponse res) {
        return null;
    }

    @Override
    public Panel getPanel(String name, HTTP.Parameters params, WebUIClient client) {
        Panel panel = new Panel();
        MenuBar menubar = new MenuBar();
        panel.add(menubar);
        Menu m1 = new Menu("File");
        menubar.add(m1);
        MenuItem m1a = new MenuItem("Open");
        m1.add(m1a);
        MenuItem m1b = new MenuItem("Save");
        m1.add(m1b);
        MenuItem m1c = new MenuItem("Save As");
        m1.add(m1c);
        Menu m2 = new Menu("Edit");
        menubar.add(m2);
        MenuItem m2a = new MenuItem("Cut");
        m2.add(m2a);
        MenuItem m2b = new MenuItem("Copy");
        m2.add(m2b);
        MenuItem m2c = new MenuItem("Paste");
        m2.add(m2c);
        Menu m3 = new Menu("More");
        m2.add(m3);
        MenuItem m3a = new MenuItem("X1");
        m3.add(m3a);
        MenuItem m3b = new MenuItem("X2");
        m3.add(m3b);
        MenuItem m3c = new MenuItem("X3");
        m3.add(m3c);
        Row row0 = new Row();
        panel.add(row0);
        row0.add(new Label("Panel=" + name));
        Row row1 = new Row();
        panel.add(row1);
        ToggleButton t = new ToggleButton("Toggle Me!");
        row1.add(t);
        Button b = new Button(new Icon("add"), "Click Me!");
        row1.add(b);
        Label l = new Label("Ready!");
        row1.add(l);
        b.addClickListener((e, button) -> {
            Integer times = (Integer)client.getProperty("times");
            if (times == null) {
                times = 1;
            }
            l.setText("You clicked it " + times + " times!");
            client.setProperty("times", times + 1);
            ProgressBar bar = (ProgressBar)client.getProperty("bar");
            bar.setValue(++this.value);
        });
        Button b2 = new Button("Popup");
        row1.add(b2);
        PopupPanel pp = new PopupPanel("Test");
        panel.add(pp);
        b2.addClickListener((e, button) -> {
            System.out.println("Popup Panel");
            pp.setPosition(100, 100);
            pp.setVisible(true);
        });
        Label ppl1 = new Label("Popup Panel!");
        pp.add(ppl1);
        ComboBox comboBox = new ComboBox();
        comboBox.add("option1", "Option #1");
        comboBox.add("option2", "Option #2");
        comboBox.add("option3", "Option #3");
        comboBox.addChangedListener(comp -> {
            ComboBox cb = (ComboBox)comp;
            System.out.println("comboxbox index=" + cb.getSelectedIndex());
        });
        row1.add(comboBox);
        CheckBox checkBox = new CheckBox("Enable Option");
        row1.add(checkBox);
        row1.add(new FlexBox());
        row1.add(new Button("Far Right"));
        TabPanel tab = new TabPanel();
        panel.add(tab);
        Table table = new Table(50, 50, 3, 3);
        table.setBorder(true);
        table.add(new Label("cell_0_0"), 0, 0);
        table.add(new Label("cell_1_1"), 1, 1);
        table.add(new Label("cell_2_2_______________too_long"), 2, 2);
        Panel t1 = new Panel();
        tab.addTab(t1, "Tab#1");
        t1.add(table);
        Column col = new Column();
        Label l2 = new Label("Another Label");
        col.add(l2);
        TextField tf1 = new TextField("init text");
        tf1.addChangedListener(comp -> {
            TextField tf = (TextField)comp;
            System.out.println("textfield text=" + tf.getText());
        });
        col.add(tf1);
        TextArea ta1 = new TextArea("init text");
        ta1.addChangedListener(comp -> {
            TextArea ta = (TextArea)comp;
            System.out.println("textarea text=" + ta.getText());
        });
        col.add(ta1);
        Panel t2 = new Panel();
        tab.addTab(t2, "Tab#2");
        t2.add(col);
        final ListBox list = new ListBox();
        list.setSize(256, 256);
        list.add("Option #1");
        list.add("Option #2");
        list.add("Option #3");
        Button b_add = new Button("Add");
        Button b_remove = new Button("Remove");
        Panel t3 = new Panel();
        t3.add(list);
        t3.add(b_add);
        t3.add(b_remove);
        tab.addTab(t3, "Tab#3");
        list.addChangedListener(new Changed(){
            final /* synthetic */ TestWebUI this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void onChanged(Component c) {
                JFLog.log("list.onChanged:" + list.getSelectedItem());
            }
        });
        b_add.addClickListener((e, button) -> list.add("Option #" + (list.count() + 1)));
        b_remove.addClickListener((e, button) -> {
            int idx = list.getSelectedIndex();
            if (idx == -1) {
                return;
            }
            list.remove(idx);
        });
        Tree tree = new Tree();
        tree.setSize(256, 256);
        TreeNode node = tree.getRootNode();
        node.setData("root");
        TreeNode child = new TreeNode();
        child.setData("t1");
        node.addNode(child);
        child = new TreeNode();
        child.setData("t2");
        node.addNode(child);
        node = child;
        child = new TreeNode();
        child.setData("t3");
        node.addNode(child);
        Panel t4 = new Panel();
        t4.add(tree);
        tab.addTab(t4, "Tab#4");
        ScrollPanel scroll = new ScrollPanel();
        for (int a = 0; a < 50; ++a) {
            Row r = new Row();
            r.add(new Label("X" + a));
            scroll.add(r);
        }
        scroll.setSize(256, 256);
        Panel t5 = new Panel();
        t5.add(scroll);
        tab.addTab(t5, "Tab#5");
        Panel tab6 = new Panel();
        tab.addTab(tab6, "Tab#6");
        Image i1 = new Image(this.img);
        tab6.add(i1);
        SplitPanel sp = new SplitPanel(1);
        sp.setLeftComponent(new Label("AA<br>aa"));
        sp.setRightComponent(new Label("BB<br>bb"));
        tab6.add(sp);
        Panel tab7 = new Panel();
        tab.addTab(tab7, "Tab#7");
        Button load = new Button("load image");
        load.addClass("row");
        tab7.add(load);
        Canvas canvas = new Canvas();
        canvas.setSize(512, 512);
        tab7.add(canvas);
        load.addClickListener((e, c) -> {
            JFImage image = new JFImage(512, 512);
            Random r = new Random();
            int[] buffer = image.getBuffer();
            for (int px = 0; px < 262144; ++px) {
                buffer[px] = r.nextInt() | 0xFF000000;
            }
            canvas.drawImage(image, new Point(0, 0));
        });
        canvas.addMouseDownListener((me, cmp) -> JFLog.log("canvas:mousedown:" + me.x + "," + me.y + "," + me.buttons));
        canvas.addMouseUpListener((me, cmp) -> JFLog.log("canvas:mouseup:" + me.x + "," + me.y + "," + me.buttons));
        canvas.addMouseMoveListener((me, cmp) -> JFLog.log("canvas:mousemove:" + me.x + "," + me.y + "," + me.buttons));
        canvas.addKeyDownListener((ke, cmp) -> JFLog.log("canvas:keydown:" + ke.keyChar + "," + ke.keyCode));
        canvas.addKeyUpListener((ke, cmp) -> JFLog.log("canvas:key up:" + ke.keyChar + "," + ke.keyCode));
        Panel tab8 = new Panel();
        tab.addTab(tab8, "Tab#8");
        Slider vslider = new Slider(1, 0, 100, 50);
        vslider.addChangedListener(Slider2 -> System.out.println("vslider=" + vslider.getPos()));
        tab8.add(vslider);
        Slider hslider = new Slider(2, 0, 100, 50);
        hslider.addChangedListener(Slider2 -> System.out.println("hslider=" + hslider.getPos()));
        tab8.add(hslider);
        ProgressBar bar = new ProgressBar(2, 100.0f, 100, 16);
        bar.setValue(50.0f);
        tab8.add(bar);
        client.setProperty("bar", bar);
        Panel tab9 = new Panel();
        tab.addTab(tab9, "Tab#9");
        GridLayout grid = new GridLayout(2, 2, new int[]{3, 1});
        tab9.add(grid);
        grid.add(new Label("Username"), 0, 0);
        grid.add(new TextField(""), 1, 0);
        grid.add(new Label("Pass"), 0, 1);
        grid.add(new TextField(""), 1, 1);
        Panel tab10 = new Panel();
        tab.addTab(tab10, "Tab#10");
        InnerPanel inner = new InnerPanel("Inner Panel");
        tab10.add(inner);
        Panel tab11 = new Panel();
        tab.addTab(tab11, "Tab#11");
        Row row = new Row();
        tab11.add(row);
        UploadButton upload = new UploadButton("Upload");
        row.add(upload);
        Button example = new Button("Download");
        row.add(example);
        return panel;
    }
}

