/*
 * Decompiled with CFR 0.152.
 */
package javaforce.ui;

import javaforce.ui.ActionListener;
import javaforce.ui.Image;
import javaforce.ui.Label;

public class ListItem
extends Label {
    private boolean selected;
    private ActionListener action;

    public ListItem(String text) {
        super(text);
    }

    @Override
    public void render(Image image) {
        int x = this.pos.x;
        int y = this.pos.y;
        int w = this.size.width;
        int h = this.size.height;
        if (w == 0 || h == 0) {
            return;
        }
        if (this.isSelected()) {
            image.setForeColor(this.getSelectedColor());
            image.fill(x, y, w, h);
        }
        super.render(image);
    }

    protected void doAction() {
        if (!this.isEnabled()) {
            return;
        }
        if (this.action != null) {
            this.action.actionPerformed(this);
        }
    }

    @Override
    public void mouseDown(int button) {
        if (button == 1) {
            this.selected = !this.selected;
            this.doAction();
        }
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean state) {
        this.selected = state;
    }

    public void setActionListener(ActionListener action) {
        this.action = action;
    }
}

