/*
 * Decompiled with CFR 0.152.
 */
package javaforce.vm;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Properties;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.LE;
import javaforce.ShellProcess;
import javaforce.linux.Linux;
import javaforce.vm.Size;

public class Storage
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final Storage[] ArrayType = new Storage[0];
    public int type;
    public String name;
    public String uuid;
    public String host;
    public String target;
    public String path;
    public String user;
    private transient LatencyMonitor latencyMonitor;
    public transient double read_latency;
    public transient double write_latency;
    public static final int TYPE_LOCAL_PART = 1;
    public static final int TYPE_LOCAL_DISK = 2;
    public static final int TYPE_NFS = 3;
    public static final int TYPE_ISCSI = 4;
    public static final int TYPE_GLUSTER = 5;
    public static final int TYPE_CEPHFS = 6;
    public static final int STATE_OFF = 0;
    public static final int STATE_ON = 1;
    public static final int STATE_BUILD = 2;
    public static final int STATE_ERROR = 3;
    public static final int FORMAT_EXT4 = 1;
    public static final int FORMAT_GFS2 = 2;
    public static final int FORMAT_OCFS2 = 3;
    public static final int FORMAT_XFS = 4;

    public Storage(int type, String name, String uuid) {
        this.type = type;
        this.name = name;
        this.uuid = uuid == null ? JF.generateUUID() : uuid;
    }

    public Storage(int type, String name, String uuid, String path) {
        this.type = type;
        this.name = name;
        this.uuid = uuid == null ? JF.generateUUID() : uuid;
        this.path = path;
    }

    private static native String[] nlist();

    public static String[] list() {
        String[] list = Storage.nlist();
        if (list == null) {
            list = new String[]{};
        }
        return list;
    }

    private static native boolean nregister(String var0);

    public boolean register() {
        String xml2 = this.createXML();
        JFLog.log("Storage.xml=" + xml2);
        return Storage.nregister(xml2);
    }

    private static native boolean nunregister(String var0);

    public boolean unregister() {
        return Storage.nunregister(this.name);
    }

    private static native boolean nstart(String var0);

    public boolean start() {
        new File(this.getPath()).mkdir();
        this.create_stats_folder();
        if (this.type == 5) {
            new File(this.getGlusterBrick()).mkdirs();
        }
        boolean res = Storage.nstart(this.name);
        if (this.type == 5 && this.mounted()) {
            new File(this.getGlusterVolume()).mkdirs();
        }
        if (!this.isMountedManually()) {
            this.start_latency_monitor();
        }
        return res;
    }

    private static native boolean nstop(String var0);

    public boolean stop() {
        this.stop_latency_monitor();
        boolean res = Storage.nstop(this.name);
        if (res) {
            new File(this.getPath()).delete();
        }
        return res;
    }

    public static void shutdown(Storage[] pools) {
        for (Storage pool : pools) {
            pool.stop_latency_monitor();
        }
    }

    private static native int ngetState(String var0);

    public int getState() {
        return Storage.ngetState(this.name);
    }

    private static native String ngetUUID(String var0);

    public String getUUID() {
        return Storage.ngetUUID(this.name);
    }

    public static String getSystemIQN() {
        try {
            FileInputStream fis = new FileInputStream("/etc/iscsi/initiatorname.iscsi");
            Properties props = new Properties();
            props.load(fis);
            fis.close();
            return props.getProperty("InitiatorName");
        }
        catch (Exception e) {
            JFLog.log(e);
            return null;
        }
    }

    public static boolean setSystemIQN(String iqn) {
        if (iqn.equals(Storage.getSystemIQN())) {
            return true;
        }
        try {
            FileOutputStream fos = new FileOutputStream("/etc/iscsi/initiatorname.iscsi");
            fos.write("##Modifed by JavaForce\n".getBytes());
            fos.write(("InitiatorName= " + iqn + "\n").getBytes());
            fos.close();
            ShellProcess sp = new ShellProcess();
            sp.run(new String[]{"/usr/bin/systemctl", "restart", "iscsid"}, true);
            return true;
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    public String getName() {
        return this.name;
    }

    public String getStateString() {
        int state = this.getState();
        switch (state) {
            case 0: {
                return "off";
            }
            case 1: {
                return "on";
            }
            case 2: {
                return "building";
            }
            case 3: {
                return "error";
            }
        }
        return "???";
    }

    public String getTypeString() {
        switch (this.type) {
            case 1: {
                return "LocalPart";
            }
            case 2: {
                return "LocalDisk";
            }
            case 3: {
                return "NFS";
            }
            case 4: {
                return "iSCSI";
            }
            case 5: {
                return "Gluster";
            }
            case 6: {
                return "CephFS";
            }
        }
        return "???";
    }

    public String[] getStates() {
        String free;
        String size;
        boolean on = this.getState() == 1;
        boolean mounted = this.mounted();
        if (on && mounted) {
            size = this.getTotalSize().toString();
            free = this.getFreeSize().toString();
        } else {
            size = on ? this.getDeviceSize().toString() : "n/a";
            free = "n/a";
        }
        String sread = String.format("%.1fms", this.read_latency);
        String swrite = String.format("%.1fms", this.write_latency);
        return new String[]{this.name, this.getTypeString(), this.getStateString(), Boolean.toString(mounted), size, free, sread, swrite};
    }

    private String getiSCSIPath() {
        int lun = 1;
        return String.format("ip-%s:3260-iscsi-%s-lun-%d", this.host, this.target, lun);
    }

    private String getDevice() {
        switch (this.type) {
            case 1: {
                return this.path;
            }
            case 2: {
                return this.path;
            }
            case 3: {
                return this.host + ":" + this.path;
            }
            case 4: {
                return "/dev/disk/by-path/" + this.getiSCSIPath();
            }
            case 5: {
                return this.path;
            }
            case 6: {
                return this.path;
            }
        }
        return null;
    }

    private String getDevice2() {
        switch (this.type) {
            case 5: {
                return this.host + ":/" + this.name;
            }
        }
        return null;
    }

    private static String resolveLinks(String file) {
        Path path = new File(file).toPath();
        if (Files.isSymbolicLink(path)) {
            try {
                String resolved = path.toRealPath(new LinkOption[0]).toString();
                return resolved;
            }
            catch (Exception e) {
                JFLog.log(e);
                return file;
            }
        }
        return file;
    }

    public static String getDiskUUID(String dev) {
        ShellProcess sp = new ShellProcess();
        String output = sp.run(new String[]{"/usr/bin/lsblk", "-o", "UUID", dev}, true);
        if (sp.getErrorLevel() != 0) {
            JFLog.log("Error:" + output);
            return null;
        }
        String[] lns = output.split("\n");
        return lns[1].trim();
    }

    public static String[] listLocalParts() {
        ShellProcess sp = new ShellProcess();
        String output = sp.run(new String[]{"/usr/bin/lsblk", "-l", "-o", "NAME,TYPE,SIZE,MOUNTPOINTS"}, true);
        if (sp.getErrorLevel() != 0) {
            JFLog.log("Error:" + output);
            return null;
        }
        String[] lns = output.split("\n");
        ArrayList<CallSite> parts = new ArrayList<CallSite>();
        for (int a = 1; a < lns.length; ++a) {
            String[] fs = lns[a].split("[ ]+");
            String name = fs[0];
            String type = fs[1];
            String size = fs[2];
            if (fs.length > 3 || !type.equals("part")) continue;
            parts.add((CallSite)((Object)("/dev/" + name)));
        }
        return parts.toArray(JF.StringArrayType);
    }

    public boolean mount() {
        boolean res;
        if (!this.isMountedManually()) {
            return false;
        }
        String dev = null;
        String mount = null;
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add("/usr/bin/mount");
        switch (this.type) {
            case 4: {
                dev = this.getDevice();
                mount = this.getPath();
                break;
            }
            case 5: {
                dev = this.getDevice2();
                mount = this.getPath();
                cmd.add("-t");
                cmd.add("glusterfs");
                break;
            }
            case 6: {
                dev = this.getDevice();
                mount = this.getPath();
                cmd.add("-t");
                cmd.add("ceph");
            }
        }
        cmd.add(dev);
        cmd.add(mount);
        new File(mount).mkdir();
        ShellProcess sp = new ShellProcess();
        JFLog.log("cmd=" + JF.join(" ", cmd.toArray(JF.StringArrayType)));
        String output = sp.run(cmd.toArray(JF.StringArrayType), true);
        JFLog.log(output);
        boolean bl = res = sp.getErrorLevel() == 0;
        if (res) {
            this.start_latency_monitor();
        }
        return res;
    }

    private String getUnmountPath() {
        switch (this.type) {
            case 6: {
                return this.getPath();
            }
        }
        return this.getDevice();
    }

    public boolean unmount() {
        if (!this.isMountedManually()) {
            return false;
        }
        this.stop_latency_monitor();
        ShellProcess sp = new ShellProcess();
        String output = sp.run(new String[]{"/usr/bin/umount", this.getUnmountPath()}, true);
        JFLog.log(output);
        new File(this.getPath()).delete();
        return sp.getErrorLevel() == 0;
    }

    public boolean mounted() {
        String dev = null;
        String path = this.getPath();
        switch (this.type) {
            default: {
                dev = this.getDevice();
                dev = Storage.resolveLinks(dev);
                break;
            }
            case 5: {
                dev = this.getDevice2();
            }
        }
        try {
            String[] lns;
            FileInputStream fis = new FileInputStream("/proc/mounts");
            byte[] data = fis.readAllBytes();
            fis.close();
            for (String ln : lns = new String(data).split("\n")) {
                if (ln.length() == 0) continue;
                String[] fs = ln.split("[ ]");
                if (fs[0].equals(dev)) {
                    return true;
                }
                if (fs.length == 1 || !fs[1].equals(path)) continue;
                return true;
            }
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
        return false;
    }

    public static String getFormatString(int fmt) {
        switch (fmt) {
            case 1: {
                return "ext4";
            }
            case 2: {
                return "gfs2";
            }
            case 3: {
                return "ocfs2";
            }
            case 4: {
                return "xfs";
            }
        }
        return null;
    }

    public boolean format(int fmt) {
        if (this.type == 3) {
            return false;
        }
        if (this.type == 6) {
            return false;
        }
        if (fmt < 1 || fmt > 4) {
            return false;
        }
        ArrayList<String> cmd = new ArrayList<String>();
        switch (fmt) {
            default: {
                return false;
            }
            case 1: {
                for (String str : new String[]{"/usr/sbin/mkfs", "-t", Storage.getFormatString(fmt), "-F", this.getDevice()}) {
                    cmd.add(str);
                }
                break;
            }
            case 3: {
                for (String str : new String[]{"/usr/sbin/mkfs", "-t", Storage.getFormatString(fmt), "-F", this.getDevice()}) {
                    cmd.add(str);
                }
                break;
            }
            case 2: {
                for (String str : new String[]{"/usr/sbin/mkfs", "-t", Storage.getFormatString(fmt), "-O", "-p", "lock_dlm", "-t", "jfkvm:" + this.name, "-j", "3", this.getDevice()}) {
                    cmd.add(str);
                }
                break;
            }
            case 4: {
                for (String str : new String[]{"/usr/sbin/mkfs", "-t", Storage.getFormatString(fmt), "-f", this.getDevice()}) {
                    cmd.add(str);
                }
            }
        }
        ShellProcess sp = new ShellProcess();
        JFLog.log("cmd=" + JF.join(" ", cmd.toArray(JF.StringArrayType)));
        String output = sp.run(cmd.toArray(JF.StringArrayType), true);
        JFLog.log(output);
        return sp.getErrorLevel() == 0;
    }

    public String getPath() {
        return "/volumes/" + this.name;
    }

    public String getGlusterBrick() {
        return "/gluster/volumes/" + this.name;
    }

    public String getGlusterVolume() {
        return "/gluster/volumes/" + this.name + "/" + this.name;
    }

    public static boolean format_supported(int fmt) {
        switch (fmt) {
            case 1: {
                return true;
            }
            case 2: {
                return new File("/usr/sbin/mkfs.gfs2").exists();
            }
            case 3: {
                return new File("/usr/sbin/mkfs.ocfs2").exists();
            }
            case 4: {
                return new File("/usr/sbin/mkfs.xfs").exists();
            }
        }
        return false;
    }

    public Size getDeviceSize() {
        ShellProcess sp = new ShellProcess();
        String output = sp.run(new String[]{"/usr/sbin/blockdev", "--getsize64", this.getDevice()}, true);
        if ((output = JF.filter(output, JF.filter_numeric)).length() == 0) {
            return new Size(0L);
        }
        return new Size(Long.valueOf(output));
    }

    public Size getTotalSize() {
        try {
            File file = new File(this.getPath());
            return new Size(file.getTotalSpace());
        }
        catch (Exception e) {
            JFLog.log(e);
            return new Size(0L);
        }
    }

    public Size getFreeSize() {
        try {
            File file = new File(this.getPath());
            return new Size(file.getFreeSpace());
        }
        catch (Exception e) {
            JFLog.log(e);
            return new Size(0L);
        }
    }

    public Size getFolderSize(String folder) {
        File[] files = new File(this.getPath() + "/" + folder).listFiles();
        long total = 0L;
        for (File file : files) {
            if (file.isDirectory()) continue;
            total += file.length();
        }
        return new Size(total);
    }

    public boolean gluster_volume_create(String[] hosts) {
        ShellProcess sp = new ShellProcess();
        ArrayList<Object> cmd = new ArrayList<Object>();
        cmd.add("/usr/sbin/gluster");
        cmd.add("volume");
        cmd.add("create");
        cmd.add(this.name);
        cmd.add("replica");
        cmd.add(Integer.toString(hosts.length));
        for (String host : hosts) {
            cmd.add(host + ":" + this.getGlusterVolume());
        }
        cmd.add("force");
        JFLog.log("cmd=" + JF.join(" ", cmd.toArray(JF.StringArrayType)));
        String output = sp.run(cmd.toArray(JF.StringArrayType), true);
        JFLog.log(output);
        return sp.getErrorLevel() == 0;
    }

    public boolean isMountedManually() {
        if (this.type == 4) {
            return true;
        }
        if (this.type == 5) {
            return true;
        }
        return this.type == 6;
    }

    private String createXML() {
        switch (this.type) {
            case 4: {
                return Storage.createXML_iSCSI(this.name, this.uuid, this.host, this.target, this.user);
            }
            case 3: {
                return Storage.createXML_NFS(this.name, this.uuid, this.host, this.path, this.getPath());
            }
            case 1: {
                return Storage.createXML_Local_Part(this.name, this.uuid, this.path, this.getPath());
            }
            case 2: {
                return Storage.createXML_Local_Disk(this.name, this.uuid, this.path, this.getPath());
            }
            case 5: {
                return Storage.createXML_Gluster(this.name, this.uuid, this.path, this.getGlusterBrick());
            }
            case 6: {
                return Storage.createXML_Ceph(this.name, this.uuid, this.path, this.getPath());
            }
        }
        return null;
    }

    private static String createXML_iSCSI(String name, String uuid, String host, String target, String chap_user) {
        StringBuilder sb = new StringBuilder();
        sb.append("<pool type='iscsi' xmlns:fs='http://libvirt.org/schemas/storagepool/fs/1.0'>");
        sb.append("  <name>" + name + "</name>");
        sb.append("  <uuid>" + uuid + "</uuid>");
        sb.append("  <source>");
        sb.append("    <host name='" + host + "'/>");
        sb.append("    <device path='" + target + "'/>");
        if (chap_user != null) {
            sb.append("      <auth type='chap' username='" + chap_user + "'>");
            sb.append("        <secret type='iscsi' usage='" + name + "'/>");
            sb.append("      </auth>");
        }
        sb.append("  </source>");
        sb.append("  <target>");
        sb.append("    <path>/dev/disk/by-path</path>");
        sb.append("  </target>");
        sb.append("</pool>");
        return sb.toString();
    }

    private static String createXML_NFS(String name, String uuid, String host, String srcPath, String mountPath) {
        StringBuilder sb = new StringBuilder();
        sb.append("<pool type='netfs' xmlns:fs='http://libvirt.org/schemas/storagepool/fs/1.0'>");
        sb.append("  <name>" + name + "</name>");
        sb.append("  <uuid>" + uuid + "</uuid>");
        sb.append("  <source>");
        sb.append("    <host name='" + host + "'/>");
        sb.append("    <dir path='" + srcPath + "'/>");
        sb.append("    <format type='nfs'/>");
        sb.append("  </source>");
        sb.append("  <target>");
        sb.append("    <path>" + mountPath + "</path>");
        sb.append("  </target>");
        sb.append("  <fs:mount_opts>");
        sb.append("    <fs:option name='noexec'/>");
        sb.append("    <fs:option name='nosuid'/>");
        sb.append("    <fs:option name='nodev'/>");
        sb.append("  </fs:mount_opts>");
        sb.append("</pool>");
        return sb.toString();
    }

    private static String createXML_Local_Part(String name, String uuid, String localDevice, String mountPath) {
        StringBuilder sb = new StringBuilder();
        sb.append("<pool type='fs' xmlns:fs='http://libvirt.org/schemas/storagepool/fs/1.0'>");
        sb.append("  <name>" + name + "</name>");
        sb.append("  <uuid>" + uuid + "</uuid>");
        sb.append("  <source>");
        sb.append("    <device path='" + localDevice + "'/>");
        sb.append("    <format type='ext4'/>");
        sb.append("  </source>");
        sb.append("  <target>");
        sb.append("    <path>" + mountPath + "</path>");
        sb.append("  </target>");
        sb.append("  <fs:mount_opts>");
        sb.append("    <fs:option name='noexec'/>");
        sb.append("    <fs:option name='nosuid'/>");
        sb.append("    <fs:option name='nodev'/>");
        sb.append("  </fs:mount_opts>");
        sb.append("</pool>");
        return sb.toString();
    }

    private static String createXML_Local_Disk(String name, String uuid, String localDevice, String mountPath) {
        StringBuilder sb = new StringBuilder();
        sb.append("<pool type='disk' xmlns:fs='http://libvirt.org/schemas/storagepool/fs/1.0'>");
        sb.append("  <name>" + name + "</name>");
        sb.append("  <uuid>" + uuid + "</uuid>");
        sb.append("  <source>");
        sb.append("    <device path='" + localDevice + "'/>");
        sb.append("    <format type='gpt'/>");
        sb.append("  </source>");
        sb.append("  <target>");
        sb.append("    <path>/dev</path>");
        sb.append("  </target>");
        sb.append("  <fs:mount_opts>");
        sb.append("    <fs:option name='noexec'/>");
        sb.append("    <fs:option name='nosuid'/>");
        sb.append("    <fs:option name='nodev'/>");
        sb.append("  </fs:mount_opts>");
        sb.append("</pool>");
        return sb.toString();
    }

    private static String createXML_Gluster(String name, String uuid, String localDevice, String brickPath) {
        StringBuilder sb = new StringBuilder();
        sb.append("<pool type='fs' xmlns:fs='http://libvirt.org/schemas/storagepool/fs/1.0'>");
        sb.append("  <name>" + name + "</name>");
        sb.append("  <uuid>" + uuid + "</uuid>");
        sb.append("  <source>");
        sb.append("    <device path='" + localDevice + "'/>");
        sb.append("    <format type='xfs'/>");
        sb.append("  </source>");
        sb.append("  <target>");
        sb.append("    <path>" + brickPath + "</path>");
        sb.append("  </target>");
        sb.append("  <fs:mount_opts>");
        sb.append("    <fs:option name='noexec'/>");
        sb.append("    <fs:option name='nosuid'/>");
        sb.append("    <fs:option name='nodev'/>");
        sb.append("  </fs:mount_opts>");
        sb.append("</pool>");
        return sb.toString();
    }

    private static String createXML_Ceph(String name, String uuid, String path, String mountPath) {
        StringBuilder sb = new StringBuilder();
        sb.append("<pool type='dir' xmlns:fs='http://libvirt.org/schemas/storagepool/fs/1.0'>");
        sb.append("  <name>" + name + "</name>");
        sb.append("  <uuid>" + uuid + "</uuid>");
        sb.append("  <target>");
        sb.append("    <path>" + mountPath + "</path>");
        sb.append("  </target>");
        sb.append("  <fs:mount_opts>");
        sb.append("    <fs:option name='noexec'/>");
        sb.append("    <fs:option name='nosuid'/>");
        sb.append("    <fs:option name='nodev'/>");
        sb.append("  </fs:mount_opts>");
        sb.append("</pool>");
        return sb.toString();
    }

    private void start_latency_monitor() {
        this.stop_latency_monitor();
        this.latencyMonitor = new LatencyMonitor();
        this.latencyMonitor.start();
    }

    private void stop_latency_monitor() {
        if (this.latencyMonitor != null) {
            this.latencyMonitor.close();
            this.latencyMonitor = null;
        }
        this.read_latency = 0.0;
        this.write_latency = 0.0;
    }

    public void create_stats_folder() {
        new File("/var/jfkvm/stats/" + this.uuid).mkdir();
    }

    public static void get_all_stats(Storage[] pools, int year, int month, int day, int hour, int sample) {
        byte[] record = new byte[32];
        for (Storage pool : pools) {
            if (pool.getState() != 1 || pool.uuid == null || pool.uuid.length() == 0) continue;
            String filename = String.format("/var/jfkvm/stats/%s/%s-%04d-%02d-%02d-%02d.stat", pool.uuid, "sto", year, month, day, hour);
            try {
                LE.setuint64(record, 0, sample);
                LE.setuint64(record, 8, (long)pool.read_latency);
                LE.setuint64(record, 16, (long)pool.write_latency);
                FileOutputStream fos = new FileOutputStream(filename, true);
                fos.write(record);
                fos.close();
            }
            catch (Exception e) {
                JFLog.log(e);
            }
        }
    }

    private static void usage() {
        JFLog.log("Usage: Storage {command} [args]");
        JFLog.log("  mount {type} ...");
        JFLog.log("    mount part {device}");
        JFLog.log("    mount iscsi {host} {target}");
        JFLog.log("    mount nfs {host} {srcPath}");
        JFLog.log("    mount cephfs {device}");
        JFLog.log("  unmount {mountPath}");
        System.exit(1);
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            Storage.usage();
        }
        block5 : switch (args[0]) {
            case "mount": {
                if (args.length < 3) {
                    Storage.usage();
                }
                switch (args[1]) {
                    case "iscsi": {
                        if (args.length < 4) {
                            Storage.usage();
                        }
                        Storage store = new Storage(4, args[1], null);
                        store.host = args[2];
                        store.target = args[3];
                        boolean res = store.register();
                        JFLog.log("res=" + res);
                        break block5;
                    }
                    case "nfs": {
                        if (args.length < 4) {
                            Storage.usage();
                        }
                        Storage store = new Storage(3, args[1], null);
                        store.host = args[2];
                        store.path = args[3];
                        boolean res = store.register();
                        JFLog.log("res=" + res);
                        break block5;
                    }
                    case "part": {
                        if (args.length < 3) {
                            Storage.usage();
                        }
                        Storage store = new Storage(1, args[1], null);
                        store.path = args[2];
                        boolean res = store.register();
                        JFLog.log("res=" + res);
                        break block5;
                    }
                    case "cephfs": {
                        if (args.length < 3) {
                            Storage.usage();
                        }
                        Storage store = new Storage(6, args[1], null);
                        store.path = args[2];
                        boolean res = store.register();
                        JFLog.log("res=" + res);
                        break block5;
                    }
                }
                break;
            }
            case "unmount": {
                if (args.length < 2) {
                    Storage.usage();
                }
                try {
                    Storage store = new Storage(0, args[1], null);
                    boolean res = store.unregister();
                    JFLog.log("res=" + res);
                }
                catch (Exception e) {
                    JFLog.log(e);
                }
                break;
            }
            default: {
                JFLog.log("Unknown command:" + args[0]);
            }
        }
    }

    private class LatencyMonitor
    extends Thread {
        private boolean active;
        private boolean exit;
        private RandomAccessFile file;
        private String filename;
        private byte[] write_data;
        private byte[] read_data;
        private byte seq;
        private long[] write_latency_array = new long[4];
        private int write_idx;
        private long[] read_latency_array = new long[4];
        private int read_idx;

        private LatencyMonitor() {
        }

        @Override
        public void run() {
            this.active = true;
            this.filename = Storage.this.getPath() + "/.perf-" + Linux.getHostname() + ".io";
            this.write_data = new byte[512];
            this.read_data = new byte[512];
            while (this.active) {
                try {
                    if (this.file == null) {
                        this.file = new RandomAccessFile(this.filename, "rws");
                    }
                    this.write_test();
                    this.read_test();
                    this.seq = (byte)(this.seq + 1);
                }
                catch (Exception e) {
                    JFLog.log(e);
                    this.close_file();
                }
                for (int a = 0; a < 5 && this.active; ++a) {
                    JF.sleep(1000);
                }
            }
            this.exit = true;
        }

        public void close() {
            this.active = false;
            while (!this.exit) {
                JF.sleep(100);
            }
        }

        private void close_file() {
            if (this.file != null) {
                try {
                    this.file.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.file = null;
            }
        }

        private void fill_buffer(byte[] buf) {
            int len = buf.length;
            for (int i = 0; i < len; ++i) {
                this.seq = (byte)(this.seq + 1);
            }
        }

        private void write_test() {
            if (this.file == null) {
                return;
            }
            try {
                long latency;
                this.fill_buffer(this.write_data);
                this.file.seek(0L);
                long begin = System.currentTimeMillis();
                this.file.write(this.write_data);
                long end = System.currentTimeMillis();
                this.write_latency_array[this.write_idx] = latency = end - begin;
                ++this.write_idx;
                int len = this.write_latency_array.length;
                if (this.write_idx == len) {
                    this.write_idx = 0;
                }
                long total = 0L;
                for (int i = 0; i < len; ++i) {
                    total += this.write_latency_array[i];
                }
                double dtotal = total;
                double dlen = len;
                Storage.this.write_latency = dtotal / dlen;
            }
            catch (Exception e) {
                JFLog.log(e);
                this.close_file();
            }
        }

        private void read_test() {
            if (this.file == null) {
                return;
            }
            try {
                long latency;
                this.file.seek(0L);
                long begin = System.currentTimeMillis();
                this.file.read(this.read_data);
                long end = System.currentTimeMillis();
                this.read_latency_array[this.read_idx] = latency = end - begin;
                ++this.read_idx;
                int len = this.read_latency_array.length;
                if (this.read_idx == len) {
                    this.read_idx = 0;
                }
                long total = 0L;
                for (int i = 0; i < len; ++i) {
                    total += this.read_latency_array[i];
                }
                double dtotal = total;
                double dlen = len;
                Storage.this.read_latency = dtotal / dlen;
            }
            catch (Exception e) {
                JFLog.log(e);
                this.close_file();
            }
        }
    }
}

