/*
 * Decompiled with CFR 0.152.
 */
package javaforce.webui;

import javaforce.webui.Column;
import javaforce.webui.Component;
import javaforce.webui.Label;
import javaforce.webui.Panel;
import javaforce.webui.Row;

public class TabPanel
extends Panel {
    private Column tabs;
    private Row row;
    private int idx;
    private boolean borders = true;
    private boolean tabsVisible = true;

    public TabPanel() {
        this.addClass("tab");
        this.setBorderGray(true);
        this.row = new Row();
        this.add(this.row);
        this.tabs = new Column();
        this.tabs.setMaxWidth();
        this.tabs.setMaxHeight();
        this.add(this.tabs);
        this.setAlign(1);
    }

    public void setBorders(boolean state) {
        this.borders = state;
        this.setBorderGray(state);
    }

    public void addTab(Panel panel, String text) {
        int cnt = this.row.count();
        Label label = new Label(text);
        label.setClass("tab" + (cnt == 0 ? "active" : "inactive"));
        if (this.borders) {
            label.setBorderGray(true);
        }
        this.row.add(label);
        this.tabs.add(panel);
        panel.setClass("tabcontent" + (cnt == 0 ? "shown" : "hidden"));
        if (this.borders) {
            panel.setBorderGray(true);
        }
    }

    public void setTabsVisible(boolean state) {
        if (this.tabsVisible == state) {
            return;
        }
        this.tabsVisible = state;
        if (state) {
            this.add(0, this.row);
        } else {
            this.remove(this.row);
        }
    }

    @Override
    public void init() {
        super.init();
        int cnt = this.row.count();
        for (int a = 0; a < cnt; ++a) {
            Component c = this.row.get(a);
            c.addEvent("onclick", "openTab(event," + a + ",\"" + this.id + "\",\"" + this.row.id + "\",\"" + this.tabs.id + "\");");
        }
    }

    @Override
    public void onLoaded(String[] args) {
        super.onLoaded(args);
        this.sendOnResize();
    }

    public void setTabIndex(int idx) {
        if (idx == this.idx) {
            return;
        }
        Label currentLbl = (Label)this.row.get(this.idx);
        currentLbl.removeClass("tabactive");
        currentLbl.addClass("tabinactive");
        Label newLbl = (Label)this.row.get(idx);
        newLbl.removeClass("tabinactive");
        newLbl.addClass("tabactive");
        Panel currentPanel = (Panel)this.tabs.get(this.idx);
        currentPanel.removeClass("tabcontentshown");
        currentPanel.addClass("tabcontenthidden");
        Panel newPanel = (Panel)this.tabs.get(idx);
        newPanel.removeClass("tabcontenthidden");
        newPanel.addClass("tabcontentshown");
        this.idx = idx;
    }

    public int getTabIndex() {
        return this.idx;
    }

    public int getTabsCount() {
        return this.tabs.count();
    }

    public void removeTab(int idx) {
        this.row.remove(idx);
        this.tabs.remove(idx);
    }
}

