/*
 * Decompiled with CFR 0.152.
 */
package javaforce.webui.tasks;

import java.util.Calendar;
import javaforce.webui.Button;
import javaforce.webui.Label;
import javaforce.webui.Panel;
import javaforce.webui.Row;
import javaforce.webui.ScrollPanel;
import javaforce.webui.tasks.TaskEvent;
import javaforce.webui.tasks.TaskLog;
import javaforce.webui.tasks.TaskUI;

public class TaskLogUI
extends Panel {
    private TaskLog log;
    private ScrollPanel rows;
    private int year;
    private int month;
    private Label period;

    public TaskLogUI(TaskLog log) {
        this.log = log;
        Row row = new Row();
        row.add(new Label("Tasks Log"));
        Button prev = new Button("<");
        row.add(prev);
        this.period = new Label("YYYY-MM");
        row.add(this.period);
        Button next = new Button(">");
        row.add(next);
        Button refresh = new Button("Refresh");
        row.add(refresh);
        this.add(row);
        this.rows = new ScrollPanel();
        this.add(this.rows);
        prev.addClickListener((e, c) -> {
            if (this.year == 0) {
                return;
            }
            --this.month;
            if (this.month == 0) {
                --this.year;
                this.month = 12;
            }
            this.reload();
        });
        next.addClickListener((e, c) -> {
            if (this.year == 0) {
                return;
            }
            ++this.month;
            if (this.month == 13) {
                ++this.year;
                this.month = 1;
            }
            this.reload();
        });
        refresh.addClickListener((e, c) -> {
            if (this.year == 0) {
                return;
            }
            this.reload();
        });
        Calendar now = Calendar.getInstance();
        this.year = now.get(1);
        this.month = now.get(2) + 1;
        this.reload();
    }

    private void reload() {
        this.period.setText(String.format("%d-%02d", this.year, this.month));
        TaskEvent[] events = this.log.getEvents(this.year, this.month);
        this.rows.removeAll();
        if (events.length == 0) {
            Row row = new Row();
            row.add(new Label("No tasks found"));
            this.rows.add(row);
        } else {
            this.addTasks(events);
        }
    }

    private void addTasks(TaskEvent[] events) {
        for (TaskEvent event : events) {
            TaskUI ui = new TaskUI(event);
            ui.update(event);
            this.rows.add(ui);
        }
    }
}

