/*
 * Decompiled with CFR 0.152.
 */
package javaforce.ansi.server.games;

import java.awt.Color;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import javaforce.ASCII8;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.ansi.server.ANSI;
import javaforce.ansi.server.KeyEvents;

public class Tetris
implements KeyEvents {
    private boolean debug = false;
    private ANSI ansi;
    private int height;
    private int width;
    private int padding;
    private int[][] lines;
    private int score;
    private int thisPiece;
    private int nextPiece;
    private Random r;
    private Timer timer;
    private int posx;
    private int posy;
    private int rotation;
    private boolean active;
    private boolean gameover;
    private boolean rotate;
    private boolean moveLeft;
    private boolean moveRight;
    private boolean moveDown;
    private boolean pause;
    private boolean toggle;
    private boolean redraw;
    private boolean refresh;
    private int[] colors = new int[]{Color.red.getRGB(), Color.green.getRGB(), Color.blue.getRGB(), Color.yellow.getRGB(), Color.pink.getRGB(), Color.orange.getRGB(), Color.magenta.getRGB(), Color.cyan.getRGB()};
    private int[] maxShift = new int[]{3, 1, 1, 1, 1, 1, 1, 1};
    private int[][][] shapes = new int[][][]{new int[][]{{1, 0, 0, 0}, {1, 0, 0, 0}, {1, 0, 0, 0}, {1, 0, 0, 0}}, new int[][]{{1, 0, 0, 0}, {1, 0, 0, 0}, {1, 1, 0, 0}, {0, 0, 0, 0}}, new int[][]{{0, 1, 0, 0}, {0, 1, 0, 0}, {1, 1, 0, 0}, {0, 0, 0, 0}}, new int[][]{{1, 1, 1, 0}, {0, 1, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}}, new int[][]{{0, 1, 1, 0}, {1, 1, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}}, new int[][]{{1, 1, 0, 0}, {0, 1, 1, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}}, new int[][]{{1, 1, 0, 0}, {1, 1, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}}, new int[][]{{1, 1, 0, 0}, {1, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}}};
    private int[][][][] rotations;

    public static void main(String[] args) {
        Tetris game = new Tetris();
        ANSI.enableConsoleMode();
        ANSI ansi = new ANSI(game);
        ansi.getConsoleSize();
        game.run(ansi);
        ANSI.disableConsoleMode();
    }

    public void run(ANSI ansi) {
        this.ansi = ansi;
        this.r = new Random();
        this.width = 18;
        this.height = ansi.height - 2;
        this.padding = (ansi.width - this.width) / 2;
        this.initRotations();
        this.initLevel();
        this.initPosition();
        this.drawLevel();
        this.startTimer();
        this.nextPiece = this.r.nextInt(this.shapes.length);
        this.getNextPiece();
        ANSI.setBackColor(0);
        this.active = true;
        while (this.active) {
            if (ansi.kbhit()) {
                ansi.process();
            }
            if (this.gameover) {
                ANSI.gotoPos(this.padding + 5, this.height / 2);
                ANSI.setForeColor(this.colors[this.r.nextInt(this.colors.length)]);
                System.out.print("GAME OVER");
                JF.sleep(10);
                continue;
            }
            if (this.pause) {
                ANSI.gotoPos(this.padding + 6, this.height / 2);
                ANSI.setForeColor(this.colors[this.r.nextInt(this.colors.length)]);
                System.out.print("PAUSED");
                JF.sleep(10);
                continue;
            }
            if (!(this.moveLeft || this.moveRight || this.moveDown || this.rotate || this.toggle)) {
                JF.sleep(10);
                continue;
            }
            if (this.rotate) {
                if (this.rotatePiece()) {
                    this.redraw = true;
                }
                this.rotate = false;
            }
            if (this.moveLeft) {
                if (!this.pieceCollide(this.posx - 1, this.posy, this.rotation)) {
                    this.erasePiece(this.thisPiece, this.posx, this.posy, this.rotation);
                    --this.posx;
                    this.redraw = true;
                }
                this.moveLeft = false;
            }
            if (this.moveRight) {
                if (!this.pieceCollide(this.posx + 1, this.posy, this.rotation)) {
                    this.erasePiece(this.thisPiece, this.posx, this.posy, this.rotation);
                    ++this.posx;
                    this.redraw = true;
                }
                this.moveRight = false;
            }
            if (this.toggle) {
                this.erasePiece(this.thisPiece, this.posx, this.posy, this.rotation);
                ++this.thisPiece;
                if (this.thisPiece == this.shapes.length) {
                    this.thisPiece = 0;
                }
                this.toggle = false;
            }
            if (this.moveDown) {
                if (!this.pieceCollide(this.posx, this.posy + 1, this.rotation)) {
                    this.erasePiece(this.thisPiece, this.posx, this.posy, this.rotation);
                    ++this.posy;
                } else {
                    this.placePiece();
                    this.checkCompletedLines();
                    this.getNextPiece();
                }
                this.redraw = true;
                this.moveDown = false;
            }
            if (this.refresh) {
                this.drawLevel();
                this.redraw = true;
                this.refresh = false;
            }
            if (!this.redraw) continue;
            this.drawPiece(this.thisPiece, this.posx, this.posy, this.rotation);
        }
        this.stopTimer();
        ANSI.setForeColor(Color.white.getRGB());
        ANSI.setBackColor(Color.black.getRGB());
    }

    private int[][] deepCopy(int[][] array) {
        int[][] ret = new int[4][4];
        for (int y = 0; y < 4; ++y) {
            for (int x = 0; x < 4; ++x) {
                ret[y][x] = array[y][x];
            }
        }
        return ret;
    }

    private void rotate(int[][] array) {
        for (int x = 0; x < 2; ++x) {
            for (int y = x; y < 4 - x - 1; ++y) {
                int tmp = array[y][x];
                array[y][x] = array[3 - x][y];
                array[3 - x][y] = array[3 - y][3 - x];
                array[3 - y][3 - x] = array[x][3 - y];
                array[x][3 - y] = tmp;
            }
        }
    }

    private boolean hasSpacingTop(int[][] array) {
        for (int x = 0; x < 4; ++x) {
            if (array[0][x] != 1) continue;
            return false;
        }
        return true;
    }

    private boolean hasSpacingLeft(int[][] array) {
        for (int y = 0; y < 4; ++y) {
            if (array[y][0] != 1) continue;
            return false;
        }
        return true;
    }

    private void moveTopLeft(int[][] array) {
        int x;
        int y;
        while (this.hasSpacingTop(array)) {
            for (y = 1; y < 4; ++y) {
                for (x = 0; x < 4; ++x) {
                    array[y - 1][x] = array[y][x];
                }
            }
            for (int x2 = 0; x2 < 4; ++x2) {
                array[3][x2] = 0;
            }
        }
        while (this.hasSpacingLeft(array)) {
            for (y = 0; y < 4; ++y) {
                for (x = 1; x < 4; ++x) {
                    array[y][x - 1] = array[y][x];
                }
            }
            for (y = 0; y < 4; ++y) {
                array[y][3] = 0;
            }
        }
    }

    private void initRotations() {
        this.rotations = new int[this.shapes.length][4][][];
        for (int shape = 0; shape < this.shapes.length; ++shape) {
            block7: for (int rotate = 0; rotate < 4; ++rotate) {
                switch (rotate) {
                    case 0: {
                        this.rotations[shape][rotate] = this.deepCopy(this.shapes[shape]);
                        continue block7;
                    }
                    case 1: {
                        this.rotations[shape][rotate] = this.deepCopy(this.shapes[shape]);
                        this.rotate(this.rotations[shape][rotate]);
                        this.moveTopLeft(this.rotations[shape][rotate]);
                        continue block7;
                    }
                    case 2: {
                        this.rotations[shape][rotate] = this.deepCopy(this.shapes[shape]);
                        this.rotate(this.rotations[shape][rotate]);
                        this.rotate(this.rotations[shape][rotate]);
                        this.moveTopLeft(this.rotations[shape][rotate]);
                        continue block7;
                    }
                    case 3: {
                        this.rotations[shape][rotate] = this.deepCopy(this.shapes[shape]);
                        this.rotate(this.rotations[shape][rotate]);
                        this.rotate(this.rotations[shape][rotate]);
                        this.rotate(this.rotations[shape][rotate]);
                        this.moveTopLeft(this.rotations[shape][rotate]);
                    }
                }
            }
        }
    }

    private void initLevel() {
        this.lines = new int[this.height][this.width];
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                if (y == this.height - 1) {
                    this.lines[y][x] = 1;
                    continue;
                }
                if (x > 0 && x < 11) {
                    this.lines[y][x] = -1;
                    continue;
                }
                if (y > 3 && y < 9) {
                    if (x == 0 || x == 11) {
                        this.lines[y][x] = 1;
                        continue;
                    }
                    this.lines[y][x] = -1;
                    continue;
                }
                this.lines[y][x] = 1;
            }
        }
    }

    private void drawLevel() {
        ANSI.setForeColor(Color.white.getRGB());
        ANSI.setBackColor(Color.black.getRGB());
        ANSI.drawBox1(this.padding, 1, this.width + 2, this.height + 2);
        StringBuilder sb = new StringBuilder();
        for (int y = 0; y < this.height; ++y) {
            ANSI.gotoPos(this.padding + 1, y + 2);
            int clr = this.lines[y][0];
            sb.setLength(0);
            sb.append(ANSI.makeForeColor(this.colors[clr]));
            for (int x = 0; x < this.width; ++x) {
                if (this.lines[y][x] == -1) {
                    sb.append(' ');
                    continue;
                }
                if (this.lines[y][x] != clr) {
                    clr = this.lines[y][x];
                    sb.append(ANSI.makeForeColor(this.colors[clr]));
                }
                sb.append(ASCII8.convert(219));
            }
            switch (y) {
                case 0: {
                    sb.replace(sb.length() - 6, sb.length() - 1, "Score");
                    break;
                }
                case 1: {
                    String ss = Integer.toString(this.score);
                    sb.replace(sb.length() - 6, sb.length() - 6 + ss.length(), ss);
                    break;
                }
                case 2: {
                    sb.replace(sb.length() - 6, sb.length() - 2, "Next");
                }
            }
            System.out.print(sb.toString());
        }
        ANSI.drawBox1(this.padding + 13, 5, 6, 6);
    }

    private void drawScore() {
        if (this.score > 99999) {
            this.score = 0;
        }
        ANSI.gotoPos(this.padding + 13, 3);
        ANSI.setForeColor(this.colors[1]);
        System.out.print(Integer.toString(this.score));
    }

    private void initPosition() {
        this.posx = 5;
        this.posy = 0;
        this.rotation = 0;
    }

    private void getNextPiece() {
        this.thisPiece = this.nextPiece;
        this.nextPiece = this.r.nextInt(this.shapes.length);
        this.initPosition();
        if (this.pieceCollide(this.posx, this.posy, this.rotation)) {
            this.gameover = true;
        } else {
            this.drawNextPiece();
        }
    }

    private void drawNextPiece() {
        this.drawPiece(this.nextPiece, 13, 4, 0);
    }

    private void drawPiece(int piece, int x, int y, int rotation) {
        this.drawPiece(piece, x, y, ASCII8.convert(219), rotation);
    }

    private void erasePiece(int piece, int x, int y, int rotation) {
        this.drawPiece(piece, x, y, ' ', rotation);
    }

    private void drawPiece(int piece, int px, int py, char ch, int rotation) {
        int[][] shape = this.getShape(piece, rotation);
        ANSI.setForeColor(this.colors[piece]);
        for (int y = 0; y < 4; ++y) {
            for (int x = 0; x < 4; ++x) {
                if (shape[y][x] != 1) continue;
                ANSI.gotoPos(this.padding + 1 + px + x, py + y + 2);
                System.out.print(ch);
            }
        }
        ANSI.gotoPos(1, 1);
    }

    private void placePiece() {
        int[][] shape = this.getShape(this.thisPiece, this.rotation);
        for (int y = 0; y < 4; ++y) {
            for (int x = 0; x < 4; ++x) {
                if (shape[y][x] == 0) continue;
                this.lines[this.posy + y][this.posx + x] = this.thisPiece;
            }
        }
        this.drawLevel();
        ++this.score;
        this.drawScore();
        this.ansi.flushConsole();
    }

    private boolean pieceCollide(int px, int py, int rotation) {
        if (py > this.height) {
            return true;
        }
        int[][] shape = this.getShape(this.thisPiece, rotation);
        for (int y = 0; y < 4; ++y) {
            for (int x = 0; x < 4; ++x) {
                if (shape[y][x] == 0) continue;
                if (py + y > this.lines.length) {
                    return true;
                }
                if (px + x >= this.width) {
                    return true;
                }
                if (this.lines[py + y][px + x] == -1) continue;
                return true;
            }
        }
        return false;
    }

    private int[][] getShape(int piece, int rotation) {
        return this.rotations[piece][rotation];
    }

    private boolean rotatePiece() {
        int newrotation = this.rotation + 1;
        if (newrotation == 4) {
            newrotation = 0;
        }
        int mx = this.maxShift[this.thisPiece];
        for (int dx = 0; dx <= mx; ++dx) {
            if (!this.pieceCollide(this.posx + dx, this.posy, newrotation)) {
                this.erasePiece(this.thisPiece, this.posx, this.posy, this.rotation);
                this.posx += dx;
                this.rotation = newrotation;
                return true;
            }
            if (this.pieceCollide(this.posx - dx, this.posy, newrotation)) continue;
            this.erasePiece(this.thisPiece, this.posx, this.posy, this.rotation);
            this.posx -= dx;
            this.rotation = newrotation;
            return true;
        }
        return false;
    }

    private void startTimer() {
        this.timer = new Timer();
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                if (!Tetris.this.pause) {
                    Tetris.this.moveDown = true;
                }
            }
        }, 500L, 500L);
    }

    private void stopTimer() {
        this.timer.cancel();
        this.timer = null;
    }

    private void checkCompletedLines() {
        int total = 0;
        for (int y = 0; y < this.height - 1; ++y) {
            int cnt = 0;
            for (int x = 1; x < 11 && this.lines[y][x] != -1; ++x) {
                ++cnt;
            }
            if (cnt != 10) continue;
            this.deleteLine(y);
            ++total;
        }
        if (total == 4) {
            this.score += 100;
            this.drawScore();
        }
        if (total > 0) {
            this.drawLevel();
        }
    }

    private void deleteLine(int py) {
        for (int a = 0; a < 15; ++a) {
            ANSI.gotoPos(this.padding + 2, py + 2);
            ANSI.setForeColor(this.colors[this.r.nextInt(this.colors.length)]);
            System.out.print(ANSI.repeat(10, ASCII8.convert(219)));
            JF.sleep(10);
            ANSI.gotoPos(1, 1);
        }
        for (int y = py; y > 0; --y) {
            for (int x = 1; x < 11; ++x) {
                this.lines[y][x] = this.lines[y - 1][x];
            }
        }
        for (int x = 1; x < 11; ++x) {
            this.lines[0][x] = -1;
        }
        this.drawLevel();
    }

    @Override
    public void keyPressed(int keyCode, int keyMods) {
        if (this.debug) {
            JFLog.log("keyPressed:" + keyCode + ":" + keyMods + ":" + this.ansi.getKeyBuffer());
        }
        if (keyMods != 0) {
            return;
        }
        switch (keyCode) {
            case 37: {
                if (this.pause) break;
                this.moveLeft = true;
                break;
            }
            case 39: {
                if (this.pause) break;
                this.moveRight = true;
                break;
            }
            case 40: {
                if (this.pause) break;
                this.moveDown = true;
                break;
            }
            case 38: {
                if (this.pause) break;
                this.rotate = true;
                break;
            }
            case 27: {
                this.active = false;
            }
        }
    }

    @Override
    public void keyTyped(char key) {
        switch (key) {
            case 'p': {
                this.pause = !this.pause;
                this.refresh = true;
                break;
            }
            case ' ': {
                if (this.pause) break;
                this.rotate = true;
                break;
            }
            case 't': {
                if (this.pause) break;
                this.toggle = true;
                break;
            }
            case 'n': {
                this.initLevel();
                this.initPosition();
                this.pause = false;
                this.gameover = false;
                this.refresh = true;
                this.score = 0;
                break;
            }
            case 'q': {
                this.active = false;
            }
        }
    }
}

