/*
 * Decompiled with CFR 0.152.
 */
package javaforce.net;

import java.net.InetAddress;
import javaforce.JFLog;
import javaforce.net.IP4;

public class Subnet4 {
    private IP4 ip = new IP4();
    private IP4 mask = new IP4();
    private IP4 inverse = new IP4();

    public Subnet4() {
    }

    public Subnet4(String address, String netmask) {
        this.setIP(address);
        this.setMask(netmask);
    }

    public static boolean isSubnet(String str) {
        if (!IP4.isIP(str)) {
            return false;
        }
        try {
            IP4 ip = new IP4();
            ip.setIP(str);
            char[] bin = Integer.toBinaryString(ip.toInt()).toCharArray();
            boolean zero = false;
            for (int i = 0; i < bin.length; ++i) {
                if (bin[i] == '0') {
                    zero = true;
                    continue;
                }
                if (!zero) continue;
                return false;
            }
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
        return true;
    }

    public static String fromCIDR(int cidr) {
        int mask = Integer.MIN_VALUE;
        --cidr;
        while (cidr > 0) {
            mask >>= 1;
            --cidr;
        }
        return String.format("%d.%d.%d.%d", (mask & 0xFF000000) >>> 24, (mask & 0xFF0000) >> 16, (mask & 0xFF00) >> 8, mask & 0xFF);
    }

    public static int toCIDR(IP4 ip) {
        int bits = ip.toInt();
        int mask = Integer.MIN_VALUE;
        int cidr = 0;
        while ((bits & mask) != 0) {
            ++cidr;
            if ((mask >>>= 1) != 0) continue;
            break;
        }
        return cidr;
    }

    public boolean setIP(String str) {
        return this.ip.setIP(str);
    }

    public boolean setIP(InetAddress addr) {
        return this.setIP(addr.getHostAddress());
    }

    public boolean setMask(String str) {
        if (!this.mask.setIP(str)) {
            JFLog.log("setMask:setIP failed");
            return false;
        }
        IP4 tmp = new IP4();
        tmp.setIP(this.ip);
        tmp.mask(this.mask);
        if (tmp.compareTo(this.ip) != 0) {
            JFLog.log("setMask:matches failed");
            return false;
        }
        this.setInverseMask();
        return true;
    }

    public boolean setMask(InetAddress addr) {
        return this.setMask(addr.getHostAddress());
    }

    private void setInverseMask() {
        for (int a = 0; a < 4; ++a) {
            this.inverse.ip[a] = ~this.mask.ip[a];
        }
    }

    public boolean isWithin(IP4 in) {
        IP4 tmp = new IP4();
        tmp.setIP(in);
        tmp.mask(this.mask);
        return tmp.compareTo(this.ip) == 0;
    }

    public boolean isDevice(IP4 in) {
        IP4 device = new IP4();
        device.setIP(in);
        device.or(this.mask);
        if (device.allOne()) {
            return false;
        }
        device.setIP(in);
        device.mask(this.inverse);
        return !device.allZero();
    }

    public String toString() {
        return this.ip.toString() + "/" + this.mask.toString();
    }

    public String toStringCIDR() {
        return this.ip.toString() + "/" + Subnet4.toCIDR(this.mask);
    }

    public static void test_matches(Subnet4 net, String ip, boolean expect) {
        IP4 ip4 = new IP4();
        ip4.setIP(ip);
        boolean res = net.isWithin(ip4);
        JFLog.log("matches(" + ip + ")=" + res + ":" + ip);
        if (res != expect) {
            JFLog.log("test failed!");
        }
    }

    public static void test_subnet(String ip, boolean expect) {
        boolean res = Subnet4.isSubnet(ip);
        JFLog.log("isSubnet(" + ip + ")=" + res);
        if (res != expect) {
            JFLog.log("test failed!");
        }
    }

    public static void test_device(Subnet4 net, String ip, boolean expect) {
        boolean res = net.isDevice(new IP4(ip));
        JFLog.log("isDevice(" + ip + ")=" + res);
        if (res != expect) {
            JFLog.log("test failed!");
        }
    }

    public static void main(String[] args) {
        Subnet4 net = new Subnet4();
        if (!net.setIP("192.168.1.0")) {
            JFLog.log("setIP failed");
        }
        if (!net.setMask("255.255.255.0")) {
            JFLog.log("setMask failed");
        }
        Subnet4.test_matches(net, "192.168.1.5", true);
        Subnet4.test_matches(net, "192.168.5.5", false);
        Subnet4.test_subnet("255.255.255.0", true);
        Subnet4.test_subnet("255.255.128.0", true);
        Subnet4.test_subnet("255.255.0.8", false);
        Subnet4.test_device(net, "192.168.1.0", false);
        Subnet4.test_device(net, "192.168.1.1", true);
        Subnet4.test_device(net, "192.168.1.255", false);
        JFLog.log("CIDR/26=" + Subnet4.fromCIDR(26));
        JFLog.log("CIDR/24=" + Subnet4.fromCIDR(24));
        JFLog.log("CIDR/16=" + Subnet4.fromCIDR(16));
    }
}

