/*
 * Decompiled with CFR 0.152.
 */
package javaforce.service;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.SocketException;
import java.util.ArrayList;
import javaforce.BE;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.jbus.JBusClient;
import javaforce.jbus.JBusServer;

public class DHCPServer {
    public static final String busPack = "net.sf.jfdhcp";
    public static boolean debug = false;
    private static int maxmtu = 1472;
    private Server server;
    private ArrayList<Pool> pools = new ArrayList();
    private Pool global = new Pool();
    private Inet4Address broadcastAddress;
    private Notify notify;
    private ArrayList<Host> hosts = new ArrayList();
    private static final String defaultConfig = "#comments start with a # symbol\n[global]\n#dns=8.8.8.8\n\n#[pool_192_168_0_x]\n#server_ip=192.168.0.2\n#bind_ip=0.0.0.0\n#pool_first=192.168.0.100\n#pool_last=192.168.0.199\n#mask=255.255.255.0\n#router=192.168.0.1\n#dns=8.8.8.8\n#lease=86400  #24 hrs (1hr=min 24hrs=max)\n#option=128:string:your_string\n#option=129:ip4:1.2.3.4\n#option=130:int:12345678\n#option=131:short:1234\n#option=132:byte:12\n\n#[pool_192_168_1_x]\n#server_ip=192.168.1.2\n#bind_ip=0.0.0.0\n#pool_first=192.168.1.100\n#pool_last=192.168.1.250\n#mask=255.255.255.0\n#router=192.168.1.1\n#dns=8.8.8.8\n#lease=7200  #2 hrs\n\n#[pool_10_1_1_x_for_relay_agents_only]\n#server_ip=192.168.2.2\n#bind_ip=192.168.2.2\n#pool_first=10.1.1.100\n#pool_last=10.1.1.250\n#mask=255.255.255.0\n#router=10.1.1.1\n\n#[pool_192_168_3_x_pxe]\n#server_ip=192.168.3.2\n#bind_ip=0.0.0.0\n#pool_first=192.168.3.100\n#pool_last=192.168.3.250\n#mask=255.255.255.0\n#router=192.168.3.1\n#pxe_server=192.168.3.50\n#pxe_bootfile=boot/pxelinux\n\n#[pool_192_168_4_x_pxe_proxy]\n#server_ip=192.168.4.2\n#bind_ip=0.0.0.0\n#pxe_proxy=true\n#pxe_server=192.168.4.50\n#pxe_bootfile=boot/pxelinux\n";
    private static final int cookie = 1669485411;
    public static final int DHCP_OPCODE_REQUEST = 1;
    public static final int DHCP_OPCODE_REPLY = 2;
    public static final int DHCPDISCOVER = 1;
    public static final int DHCPOFFER = 2;
    public static final int DHCPREQUEST = 3;
    public static final int DHCPDECLINE = 4;
    public static final int DHCPACK = 5;
    public static final int DHCPNAK = 6;
    public static final int DHCPRELEASE = 7;
    public static final int DHCPINFORM = 8;
    private static final byte OPT_PAD = 0;
    private static final byte OPT_SUBNET_MASK = 1;
    private static final byte OPT_ROUTER = 3;
    private static final byte OPT_DNS = 6;
    private static final byte OPT_REQUEST_IP = 50;
    private static final byte OPT_LEASE_TIME = 51;
    private static final byte OPT_DHCP_MSG_TYPE = 53;
    private static final byte OPT_DHCP_SERVER_IP = 54;
    private static final byte OPT_PARAM_REQ_LIST = 55;
    private static final byte OPT_MAX_MSG_SIZE = 57;
    private static final byte OPT_RENEWAL_TIME = 58;
    private static final byte OPT_VENDOR_CLASS = 60;
    private static final byte OPT_PXE_SERVER = 66;
    private static final byte OPT_PXE_BOOTFILE = 67;
    private static final byte OPT_REBINDING_TIME = 59;
    private static final byte OPT_CLIENT_ARCH = 93;
    private static final byte OPT_CLIENT_NET_DEV_INT = 94;
    private static final byte OPT_CLIENT_ID = 97;
    private static final byte OPT_END = -1;
    public static final short ARCH_BIOS_X86 = 0;
    public static final short ARCH_UEFI_X86 = 7;
    public static final short ARCH_UEFI_ARM = 11;
    public static final String RASPBERRY_PI_MAC = "dca632";
    private static JBusServer busServer;
    private JBusClient busClient;
    private String config;
    private static DHCPServer dhcp;

    public static String getConfigFile() {
        return JF.getConfigPath() + "/jfdhcp.cfg";
    }

    public static String getLogFile() {
        return JF.getLogPath() + "/jfdhcp.log";
    }

    public void setNotify(Notify notify) {
        this.notify = notify;
    }

    public void start() {
        this.stop();
        this.server = new Server();
        this.server.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.server == null) {
            return;
        }
        int cnt = this.hosts.size();
        for (int a = 0; a < cnt; ++a) {
            DatagramSocket ds = this.hosts.get((int)a).ds;
            if (ds == null) continue;
            ds.close();
        }
        if (this.busClient != null) {
            this.busClient.close();
            this.busClient = null;
        }
        this.server.active = false;
        Server server = this.server;
        synchronized (server) {
            this.server.notify();
        }
        this.server = null;
    }

    private void addOption(Pool pool, String str) {
        int i1 = str.indexOf(":");
        if (i1 == -1) {
            JFLog.log("bad option:" + str);
            return;
        }
        int i2 = str.substring(i1 + 1).indexOf(":");
        if (i2 == -1) {
            JFLog.log("bad option:" + str);
            return;
        }
        String num = str.substring(0, i1);
        String type = str.substring(i1 + 1, i2 += i1 + 1);
        String data = str.substring(i2 + 1);
        Option opt = new Option();
        opt.num = Integer.valueOf(num);
        opt.type = type.equals("int") ? OptionType.int32 : (type.equals("short") ? OptionType.int16 : (type.equals("byte") ? OptionType.int8 : (type.equals("ip4") ? OptionType.ip4 : OptionType.string)));
        opt.data = data;
        pool.options.add(opt);
    }

    private int clampLeaseTime(int value) {
        if (value < 3600) {
            value = 3600;
        }
        if (value > 86400) {
            value = 86400;
        }
        return value;
    }

    private void loadConfig() {
        this.pools.clear();
        this.hosts.clear();
        Pool pool = null;
        try {
            String ln;
            StringBuilder cfg = new StringBuilder();
            BufferedReader br = new BufferedReader(new FileReader(DHCPServer.getConfigFile()));
            while ((ln = br.readLine()) != null) {
                cfg.append(ln);
                cfg.append("\n");
                ln = ln.trim();
                int cmt = ln.indexOf(35);
                if (cmt != -1) {
                    ln = ln.substring(0, cmt).trim();
                }
                if (ln.length() == 0) continue;
                if (ln.startsWith("[") && ln.endsWith("]")) {
                    String sectionName = ln.substring(1, ln.length() - 1);
                    if (sectionName.equals("global")) {
                        pool = this.global;
                        continue;
                    }
                    pool = new Pool();
                    pool.name = sectionName;
                    this.pools.add(pool);
                    continue;
                }
                int idx = ln.indexOf("=");
                if (idx == -1) continue;
                String key = ln.substring(0, idx).toLowerCase().trim();
                String value = ln.substring(idx + 1).trim();
                switch (key) {
                    case "pool_first": {
                        pool.pool_first = value;
                        break;
                    }
                    case "pool_last": {
                        pool.pool_last = value;
                        break;
                    }
                    case "server_ip": {
                        pool.server_ip = value;
                        break;
                    }
                    case "bind_ip": {
                        pool.bind_ip = value;
                        break;
                    }
                    case "mask": {
                        pool.mask = value;
                        break;
                    }
                    case "dns": {
                        pool.dns = value;
                        break;
                    }
                    case "router": {
                        pool.router = value;
                        break;
                    }
                    case "lease": {
                        pool.leaseTime = this.clampLeaseTime(JF.atoi(value));
                        break;
                    }
                    case "option": {
                        this.addOption(pool, value);
                        break;
                    }
                    case "pxe_server": {
                        pool.pxe_server = value;
                        break;
                    }
                    case "pxe_bootfile": {
                        pool.pxe_bootfile = value;
                        break;
                    }
                    case "pxe_proxy": {
                        pool.pxe_proxy = value.equals("true");
                        break;
                    }
                    case "debug": {
                        debug = value.equals("true");
                    }
                }
            }
            this.config = cfg.toString();
        }
        catch (FileNotFoundException e) {
            try {
                FileOutputStream fos = new FileOutputStream(DHCPServer.getConfigFile());
                fos.write(defaultConfig.getBytes());
                fos.close();
                this.config = defaultConfig;
            }
            catch (Exception e2) {
                JFLog.log(e2);
            }
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    private boolean validConfig() {
        try {
            Pool pool;
            int a;
            if (this.pools.size() == 0) {
                throw new Exception("no pools defined");
            }
            if (this.global.server_ip != null) {
                if (!this.validIP4(this.global.server_ip)) {
                    throw new Exception("global : invalid server_ip");
                }
                this.global.server_ip_int = DHCPServer.IP4toInt(this.global.server_ip);
            }
            if (this.global.bind_ip == null) {
                this.global.bind_ip = "0.0.0.0";
            }
            this.global.bind_ip_int = DHCPServer.IP4toInt(this.global.bind_ip);
            int cnt = this.pools.size();
            for (a = 0; a < cnt; ++a) {
                pool = this.pools.get(a);
                if (pool.server_ip == null) {
                    pool.server_ip = this.global.server_ip;
                }
                if (pool.router == null) {
                    pool.router = this.global.router;
                }
                if (pool.dns == null) {
                    pool.dns = this.global.dns;
                }
                if (pool.bind_ip == null) {
                    pool.bind_ip = this.global.bind_ip;
                }
                if (!this.validIP4(pool.server_ip)) {
                    throw new Exception(pool.name + " : invalid server_ip");
                }
                if (!this.validIP4(pool.pool_first)) {
                    throw new Exception(pool.name + " : invalid pool_first");
                }
                if (!this.validIP4(pool.pool_last)) {
                    throw new Exception(pool.name + " : invalid pool_last");
                }
                if (!this.validIP4(pool.router)) {
                    throw new Exception(pool.name + " : invalid router");
                }
                if (!this.validIP4(pool.mask)) {
                    throw new Exception(pool.name + " : invalid mask");
                }
                if (!this.validIP4(pool.dns)) {
                    throw new Exception(pool.name + " : invalid dns");
                }
                if (pool.leaseTime < 3600 || pool.leaseTime > 86400) {
                    JFLog.log(pool.name + " : leaseTime invalid, using 24 hrs");
                    pool.leaseTime = 86400;
                }
                pool.server_ip_int = DHCPServer.IP4toInt(pool.server_ip);
                pool.bind_ip_int = DHCPServer.IP4toInt(pool.bind_ip);
                pool.pool_first_int = DHCPServer.IP4toInt(pool.pool_first);
                pool.pool_last_int = DHCPServer.IP4toInt(pool.pool_last);
                pool.mask_int = DHCPServer.IP4toInt(pool.mask);
                if ((pool.pool_first_int & pool.mask_int) != (pool.pool_last_int & pool.mask_int)) {
                    throw new Exception(pool.name + " : invalid pool range : " + pool.pool_first + "-" + pool.pool_last + ",mask=" + pool.mask);
                }
                pool.host_mask_int = ~pool.mask_int;
                pool.count = (pool.pool_last_int & pool.host_mask_int) - (pool.pool_first_int & pool.host_mask_int) + 1;
                pool.pool_time = new long[pool.count];
                pool.pool_hwlen = new int[pool.count];
                pool.pool_hwaddr = new byte[pool.count][16];
                if (pool.pxe_proxy) {
                    if (!debug) continue;
                    JFLog.log("pool:pxe_proxy:" + pool.pxe_server);
                    continue;
                }
                if (!debug) continue;
                JFLog.log("pool:" + DHCPServer.IP4toString(pool.pool_first_int) + "-" + DHCPServer.IP4toString(pool.pool_last_int) + ":" + pool.count + " IPs");
            }
            for (a = 0; a < cnt; ++a) {
                Pool poola = this.pools.get(a);
                if (poola.pxe_proxy) continue;
                for (int b = 0; b < cnt; ++b) {
                    if (b == a) continue;
                    Pool poolb = this.pools.get(b);
                    if (poolb.pxe_proxy || (poola.pool_first_int & poola.mask_int) != (poolb.pool_first_int & poolb.mask_int)) continue;
                    throw new Exception("multiple pools overlap");
                }
            }
            for (a = 0; a < cnt; ++a) {
                pool = this.pools.get(a);
                boolean hasHost_67 = false;
                boolean hasHost_4011 = false;
                for (int b = 0; b < this.hosts.size(); ++b) {
                    Host host = this.hosts.get(b);
                    if (host.ip == pool.bind_ip && host.port == 67) {
                        hasHost_67 = true;
                        break;
                    }
                    if (host.ip != pool.bind_ip || host.port != 4011) continue;
                    hasHost_4011 = true;
                    break;
                }
                if (!hasHost_67) {
                    Host host = new Host();
                    host.ip = pool.bind_ip;
                    host.ip_int = DHCPServer.IP4toInt(host.ip);
                    host.port = 67;
                    this.hosts.add(host);
                }
                if (hasHost_4011) continue;
                Host host = new Host();
                host.ip = pool.bind_ip;
                host.ip_int = DHCPServer.IP4toInt(host.ip);
                host.port = 4011;
                this.hosts.add(host);
            }
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
        return true;
    }

    private boolean validIP4(String ip) {
        if (ip == null) {
            return true;
        }
        String[] o = ip.split("[.]");
        if (o.length != 4) {
            return false;
        }
        for (int a = 0; a < 4; ++a) {
            int v = Integer.valueOf(o[a]);
            if (v < 0) {
                return false;
            }
            if (v <= 255) continue;
            return false;
        }
        return true;
    }

    private static int IP4toInt(String ip) {
        if (ip == null) {
            return 0;
        }
        String[] o = ip.split("[.]");
        int ret = 0;
        for (int a = 0; a < 4; ++a) {
            ret <<= 8;
            ret += JF.atoi(o[a]);
        }
        return ret;
    }

    private static byte[] IP4toByteArray(String ip) {
        String[] o = ip.split("[.]");
        byte[] ret = new byte[4];
        for (int a = 0; a < 4; ++a) {
            ret[a] = (byte)JF.atoi(o[a]);
        }
        return ret;
    }

    private static byte[] IP4toByteArray(int ip) {
        return DHCPServer.IP4toByteArray(DHCPServer.IP4toString(ip));
    }

    private static String IP4toString(int ip) {
        return String.format("%d.%d.%d.%d", ip >>> 24, ip >> 16 & 0xFF, ip >> 8 & 0xFF, ip & 0xFF);
    }

    private static String IP4toString(byte[] ip) {
        return DHCPServer.IP4toString(BE.getuint32(ip, 0));
    }

    public static String IP4toString(byte[] ip, int offset) {
        return DHCPServer.IP4toString(BE.getuint32(ip, offset));
    }

    private static String MACtoString(byte[] mac) {
        StringBuilder sb = new StringBuilder();
        for (int a = 0; a < 6; ++a) {
            sb.append(String.format("%02x", mac[a]));
        }
        return sb.toString();
    }

    private static String getMsgType(int type) {
        switch (type) {
            case 1: {
                return "DHCPDISCOVER";
            }
            case 2: {
                return "DHCPOFFER";
            }
            case 3: {
                return "DHCPREQUEST";
            }
            case 4: {
                return "DHCPDECLINE";
            }
            case 5: {
                return "DHCPACK";
            }
            case 6: {
                return "DHCPNAK";
            }
            case 7: {
                return "DHCPRELEASE";
            }
            case 8: {
                return "DHCPINFORM";
            }
        }
        return "???";
    }

    public static int getBusPort() {
        if (JF.isWindows()) {
            return 33004;
        }
        return 777;
    }

    public static void serviceStart(String[] args) {
        if (JF.isWindows()) {
            busServer = new JBusServer(DHCPServer.getBusPort());
            busServer.start();
            while (true) {
                if (JBusServer.ready) break;
                JF.sleep(10);
            }
        }
        dhcp = new DHCPServer();
        dhcp.start();
    }

    public static void serviceStop() {
        JFLog.log("DHCP : Stopping service");
        if (busServer != null) {
            busServer.close();
            busServer = null;
        }
        dhcp.stop();
    }

    private static class Pool {
        public Object lock = new Object();
        public String name;
        public String server_ip;
        public int server_ip_int;
        public String bind_ip;
        public int bind_ip_int;
        public String pool_first;
        public int pool_first_int;
        public String pool_last;
        public int pool_last_int;
        public String mask;
        public int mask_int;
        public int host_mask_int;
        public int count = 0;
        public long[] pool_time;
        public int[] pool_hwlen;
        public byte[][] pool_hwaddr;
        public int next = 0;
        public String router;
        public String dns;
        public int leaseTime = 86400;
        public boolean pxe_proxy;
        public String pxe_server;
        public String pxe_bootfile;
        public ArrayList<Option> options = new ArrayList();

        private Pool() {
        }
    }

    public static interface Notify {
        public void dhcpEvent(int var1, String var2, String var3, short var4);
    }

    private class Server
    extends Thread {
        public boolean active;

        private Server() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            this.active = true;
            JFLog.append(DHCPServer.getLogFile(), true);
            JFLog.setRetention(30);
            JFLog.log("DHCP : Starting service");
            try {
                DHCPServer.this.loadConfig();
                DHCPServer.this.busClient = new JBusClient(DHCPServer.busPack, new JBusMethods());
                DHCPServer.this.busClient.setPort(DHCPServer.getBusPort());
                DHCPServer.this.busClient.start();
                if (!DHCPServer.this.validConfig()) {
                    throw new Exception("invalid config");
                }
                DHCPServer.this.broadcastAddress = (Inet4Address)Inet4Address.getByName("255.255.255.255");
                for (int a = 0; a < DHCPServer.this.hosts.size(); ++a) {
                    new HostWorker(DHCPServer.this.hosts.get(a)).start();
                }
                while (this.active) {
                    Server a = this;
                    synchronized (a) {
                        this.wait();
                    }
                }
                return;
            }
            catch (Exception e) {
                JFLog.log(e);
            }
        }
    }

    private static class Host {
        public String ip;
        public int ip_int;
        public int port;
        public DatagramSocket ds;

        private Host() {
        }
    }

    private static class Option {
        public int num;
        public OptionType type;
        public String data;

        private Option() {
        }
    }

    private static enum OptionType {
        string,
        ip4,
        int8,
        int16,
        int32;

    }

    public static class JBusMethods {
        public void getConfig(String pack) {
            JBusClient cfr_ignored_0 = DHCPServer.dhcp.busClient;
            JBusClient cfr_ignored_1 = DHCPServer.dhcp.busClient;
            DHCPServer.dhcp.busClient.call(pack, "getConfig", JBusClient.quote(JBusClient.encodeString(DHCPServer.dhcp.config)));
        }

        public void setConfig(String cfg) {
            try {
                FileOutputStream fos = new FileOutputStream(DHCPServer.getConfigFile());
                fos.write(JBusClient.decodeString(cfg).getBytes());
                fos.close();
            }
            catch (Exception e) {
                JFLog.log(e);
            }
        }

        public void restart() {
            dhcp.stop();
            dhcp = new DHCPServer();
            dhcp.start();
        }
    }

    private class RequestWorker
    extends Thread {
        private DatagramPacket packet;
        private Host host;
        private byte[] req;
        private int reqOffset;
        private byte[] reply;
        private int replyOffset;
        private Pool pool;

        public RequestWorker(DatagramPacket packet, Host host) {
            this.packet = packet;
            this.host = host;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                if (debug) {
                    JFLog.log("Received request from:" + this.packet.getAddress().getHostAddress() + ":" + this.packet.getPort());
                }
                this.req = this.packet.getData();
                this.reqOffset = 0;
                byte opcode = this.getByte();
                if (opcode != 1) {
                    throw new Exception("not a request");
                }
                byte hwtype = this.getByte();
                byte hwlen = this.getByte();
                byte hop = this.getByte();
                int id = this.getInt();
                short seconds = this.getShort();
                short flags = this.getShort();
                boolean broadcast = (flags & 0x8000) == 32768;
                int cip = this.getInt();
                int yip = this.getInt();
                int sip = this.getInt();
                int rip = this.getInt();
                int server_ip = 0;
                int msgType = -1;
                int yipOffset = -1;
                int cnt = DHCPServer.this.pools.size();
                int from_ip = rip;
                short pxe_arch = -1;
                byte[] req_list = new byte[]{};
                byte[] client_id = new byte[17];
                if (from_ip == 0) {
                    String src = this.packet.getAddress().getHostAddress();
                    from_ip = DHCPServer.IP4toInt(src);
                }
                if (from_ip == 0) {
                    from_ip = this.host.ip_int;
                }
                if (from_ip == 0 && DHCPServer.this.pools.size() == 1) {
                    from_ip = DHCPServer.this.pools.get((int)0).server_ip_int;
                }
                if (from_ip == 0) {
                    throw new Exception("can not determine pool for request");
                }
                if (debug) {
                    JFLog.log("DHCP:from_ip=" + DHCPServer.IP4toString(from_ip));
                }
                for (int a = 0; a < cnt; ++a) {
                    this.pool = DHCPServer.this.pools.get(a);
                    if ((this.pool.pool_first_int & this.pool.mask_int) == (from_ip & this.pool.mask_int)) break;
                    this.pool = null;
                }
                if (this.pool == null) {
                    throw new Exception("no pool for request");
                }
                if (yip != 0 && (yip & this.pool.mask_int) == (this.pool.pool_first_int & this.pool.mask_int)) {
                    yipOffset = yip - this.pool.pool_first_int;
                }
                byte[] mac = new byte[6];
                this.getBytes(mac);
                this.reqOffset = 240;
                while (true) {
                    byte opt;
                    if ((opt = this.getByte()) == 0) {
                        continue;
                    }
                    int len = this.getByte() & 0xFF;
                    switch (opt) {
                        case 53: {
                            if (len != 1) {
                                throw new Exception("bad dhcp msg type (size != 1)");
                            }
                            msgType = this.getByte();
                            break;
                        }
                        case 50: {
                            if (len != 4) {
                                throw new Exception("bad request ip (size != 4)");
                            }
                            cip = yip = this.getInt();
                            if ((yip & this.pool.mask_int) == (this.pool.pool_first_int & this.pool.mask_int)) {
                                yipOffset = yip - this.pool.pool_first_int;
                                break;
                            }
                            JFLog.log("DHCP:invalid requested ip:" + DHCPServer.IP4toString(yip));
                            break;
                        }
                        case 93: {
                            if (len != 2) {
                                throw new Exception("bad arch id");
                            }
                            pxe_arch = this.getShort();
                            break;
                        }
                        case 55: {
                            req_list = new byte[len];
                            System.arraycopy(this.req, this.reqOffset, req_list, 0, len);
                            this.reqOffset += len;
                            break;
                        }
                        case 54: {
                            if (len != 4) {
                                throw new Exception("bad request dhcp server ip (size != 4)");
                            }
                            server_ip = this.getInt();
                            break;
                        }
                        case 97: {
                            if (len != 17) {
                                throw new Exception("invalid client uuid");
                            }
                            System.arraycopy(this.req, this.reqOffset, client_id, 0, len);
                            this.reqOffset += len;
                            break;
                        }
                        default: {
                            this.reqOffset += len;
                        }
                    }
                    if (opt == -1) break;
                }
                if (msgType == -1) {
                    throw new Exception("no dhcp msg type");
                }
                if (debug) {
                    JFLog.log("DHCP:MsgType=" + DHCPServer.getMsgType(msgType));
                }
                long now = System.currentTimeMillis();
                switch (msgType) {
                    case 1: {
                        if (this.pool.pxe_proxy) {
                            if (!this.req_opt(req_list, (byte)66)) break;
                            if (DHCPServer.this.notify != null) {
                                DHCPServer.this.notify.dhcpEvent(1, DHCPServer.MACtoString(mac), DHCPServer.IP4toString(cip), pxe_arch);
                            }
                            this.sendReply(new byte[4], 2, id, this.pool, cip, rip, req_list, client_id);
                            break;
                        }
                        Object object = this.pool.lock;
                        synchronized (object) {
                            int i = this.pool.next++;
                            for (int c = 0; c < this.pool.count; ++c) {
                                if (this.pool.pool_time[i] != 0L && this.pool.pool_time[i] < now) {
                                    this.pool.pool_time[i] = 0L;
                                }
                                if (this.pool.pool_time[i] != 0L) continue;
                                byte[] addr = DHCPServer.IP4toByteArray(this.pool.pool_first_int + i);
                                Inet4Address inet = (Inet4Address)Inet4Address.getByAddress(addr);
                                if (inet.isReachable(1000)) {
                                    this.pool.pool_time[i] = now + (long)(this.pool.leaseTime * 1000);
                                    JFLog.log("DHCP:warning:IP in use but not in database:" + DHCPServer.IP4toString(addr));
                                    continue;
                                }
                                if (DHCPServer.this.notify != null) {
                                    DHCPServer.this.notify.dhcpEvent(1, DHCPServer.MACtoString(mac), DHCPServer.IP4toString(cip), pxe_arch);
                                }
                                this.sendReply(addr, 2, id, this.pool, cip, rip, req_list, client_id);
                                this.pool.next = i + 1;
                                if (this.pool.next == this.pool.count) {
                                    this.pool.next = 0;
                                }
                                return;
                            }
                        }
                        JFLog.log("DHCP:no free IPs in pool for request");
                        break;
                    }
                    case 3: {
                        if (this.pool.pxe_proxy) {
                            if (!this.req_opt(req_list, (byte)66) || broadcast && server_ip != this.pool.server_ip_int) break;
                            if (DHCPServer.this.notify != null) {
                                DHCPServer.this.notify.dhcpEvent(3, DHCPServer.MACtoString(mac), DHCPServer.IP4toString(cip), pxe_arch);
                            }
                            this.sendReply(new byte[4], 5, id, this.pool, cip, rip, req_list, client_id);
                            break;
                        }
                        if (yipOffset < 0 || yipOffset >= this.pool.count) {
                            JFLog.log("DHCP:request out of range:" + yipOffset);
                            break;
                        }
                        Object object = this.pool.lock;
                        synchronized (object) {
                            byte[] addr = DHCPServer.IP4toByteArray(this.pool.pool_first);
                            addr[3] = (byte)(addr[3] + yipOffset);
                            if (this.pool.pool_time[yipOffset] != 0L) {
                                boolean same = true;
                                for (int a = 0; a < this.pool.pool_hwlen[yipOffset]; ++a) {
                                    if (this.pool.pool_hwaddr[yipOffset][a] == this.req[28 + a]) continue;
                                    same = false;
                                    break;
                                }
                                if (same) {
                                    this.pool.pool_time[yipOffset] = 0L;
                                }
                            }
                            if (this.pool.pool_time[yipOffset] == 0L) {
                                this.pool.pool_time[yipOffset] = now + (long)(this.pool.leaseTime * 1000);
                                this.pool.pool_hwlen[yipOffset] = hwlen;
                                System.arraycopy(this.req, 28, this.pool.pool_hwaddr[yipOffset], 0, 16);
                                if (DHCPServer.this.notify != null) {
                                    DHCPServer.this.notify.dhcpEvent(3, DHCPServer.MACtoString(mac), DHCPServer.IP4toString(cip), pxe_arch);
                                }
                                this.sendReply(addr, 5, id, this.pool, cip, rip, req_list, client_id);
                            } else {
                                this.sendReply(addr, 6, id, this.pool, cip, rip, req_list, client_id);
                            }
                            break;
                        }
                    }
                    case 7: {
                        if (DHCPServer.this.notify != null) {
                            DHCPServer.this.notify.dhcpEvent(7, DHCPServer.MACtoString(mac), DHCPServer.IP4toString(cip), pxe_arch);
                        }
                        if (yipOffset < 0 || yipOffset >= this.pool.count) {
                            JFLog.log("DHCP:release out of range");
                            break;
                        }
                        Object object = this.pool.lock;
                        synchronized (object) {
                            if (this.pool.pool_time[yipOffset] != 0L) {
                                boolean same = true;
                                for (int a = 0; a < this.pool.pool_hwlen[yipOffset]; ++a) {
                                    if (this.pool.pool_hwaddr[yipOffset][a] == this.req[28 + a]) continue;
                                    same = false;
                                    break;
                                }
                                if (!same) {
                                    break;
                                }
                                this.pool.pool_time[yipOffset] = 0L;
                            }
                            break;
                        }
                    }
                    case 8: {
                        break;
                    }
                    case 4: {
                        break;
                    }
                    default: {
                        throw new Exception("unsupported dhcp msg type");
                    }
                }
            }
            catch (Exception e) {
                JFLog.log(e);
            }
        }

        private void sendReply(byte[] outData, int outDataLength, int rip) {
            try {
                DatagramPacket out = new DatagramPacket(outData, outDataLength);
                if (rip == 0) {
                    out.setAddress(DHCPServer.this.broadcastAddress);
                } else {
                    out.setAddress(Inet4Address.getByAddress(new byte[]{(byte)(rip >> 24), (byte)(rip >> 16 & 0xFF), (byte)(rip >> 8 & 0xFF), (byte)(rip & 0xFF)}));
                }
                int port = this.packet.getPort();
                out.setPort(port);
                if (debug) {
                    JFLog.log("DHCP:ReplyTo:" + out.getAddress().getHostAddress() + ":" + out.getPort() + ":data.length=" + outDataLength);
                }
                this.host.ds.send(out);
            }
            catch (Exception e) {
                JFLog.log(e);
            }
        }

        private boolean req_opt(byte[] req_list, byte req) {
            for (int a = 0; a < req_list.length; ++a) {
                if (req_list[a] != req) continue;
                return true;
            }
            return false;
        }

        private void sendReply(byte[] yip, int msgType, int id, Pool pool, int cip, int rip, byte[] req_list, byte[] client_id) {
            if (debug) {
                JFLog.log("DHCP:ReplyFor:" + DHCPServer.IP4toString(yip) + ":" + DHCPServer.getMsgType(msgType));
            }
            this.reply = new byte[maxmtu];
            this.replyOffset = 0;
            this.reply[this.replyOffset++] = 2;
            this.reply[this.replyOffset++] = this.req[1];
            this.reply[this.replyOffset++] = this.req[2];
            this.reply[this.replyOffset++] = 0;
            this.putInt(id);
            this.putShort((short)0);
            this.putShort((short)Short.MIN_VALUE);
            this.putInt(cip);
            this.putByteArray(yip);
            this.putIP4(pool.server_ip);
            this.putInt(rip);
            System.arraycopy(this.req, this.replyOffset, this.reply, this.replyOffset, 16);
            this.replyOffset += 16;
            this.replyOffset += 64;
            this.replyOffset += 128;
            this.putInt(1669485411);
            this.reply[this.replyOffset++] = 53;
            this.reply[this.replyOffset++] = 1;
            this.reply[this.replyOffset++] = (byte)msgType;
            if (pool.mask != null && !pool.pxe_proxy) {
                this.reply[this.replyOffset++] = 1;
                this.reply[this.replyOffset++] = 4;
                this.putIP4(pool.mask);
            }
            if (pool.dns != null && !pool.pxe_proxy) {
                this.reply[this.replyOffset++] = 6;
                this.reply[this.replyOffset++] = 4;
                this.putIP4(pool.dns);
            }
            if (pool.router != null && !pool.pxe_proxy) {
                this.reply[this.replyOffset++] = 3;
                this.reply[this.replyOffset++] = 4;
                this.putIP4(pool.router);
            }
            if (!pool.pxe_proxy) {
                this.reply[this.replyOffset++] = 50;
                this.reply[this.replyOffset++] = 4;
                this.putByteArray(yip);
            }
            this.reply[this.replyOffset++] = 54;
            this.reply[this.replyOffset++] = 4;
            this.putIP4(pool.server_ip);
            if (!pool.pxe_proxy) {
                this.reply[this.replyOffset++] = 58;
                this.reply[this.replyOffset++] = 4;
                this.putInt(pool.leaseTime - 1800);
            }
            if (!pool.pxe_proxy) {
                this.reply[this.replyOffset++] = 59;
                this.reply[this.replyOffset++] = 4;
                this.putInt(pool.leaseTime - 900);
            }
            if (!pool.pxe_proxy) {
                this.reply[this.replyOffset++] = 51;
                this.reply[this.replyOffset++] = 4;
                this.putInt(pool.leaseTime);
            }
            if (pool.pxe_server != null) {
                this.reply[this.replyOffset++] = 60;
                this.reply[this.replyOffset++] = 9;
                this.putByteArray("PXEClient".getBytes());
                this.reply[this.replyOffset++] = 97;
                this.reply[this.replyOffset++] = 17;
                this.putByteArray(client_id);
            }
            if (pool.pxe_server != null && this.req_opt(req_list, (byte)66)) {
                this.reply[this.replyOffset++] = 66;
                this.reply[this.replyOffset++] = (byte)pool.pxe_server.length();
                this.putByteArray(pool.pxe_server.getBytes());
            }
            if (pool.pxe_bootfile != null && this.req_opt(req_list, (byte)67)) {
                this.reply[this.replyOffset++] = 67;
                this.reply[this.replyOffset++] = (byte)pool.pxe_bootfile.length();
                this.putByteArray(pool.pxe_bootfile.getBytes());
            }
            block7: for (int a = 0; a < pool.options.size(); ++a) {
                Option opt = pool.options.get(a);
                this.reply[this.replyOffset++] = (byte)opt.num;
                switch (opt.type.ordinal()) {
                    case 0: {
                        this.reply[this.replyOffset++] = (byte)opt.data.length();
                        this.putByteArray(opt.data.getBytes());
                        continue block7;
                    }
                    case 4: {
                        this.reply[this.replyOffset++] = 4;
                        this.putInt(Integer.valueOf(opt.data));
                        continue block7;
                    }
                    case 3: {
                        this.reply[this.replyOffset++] = 2;
                        this.putShort(Short.valueOf(opt.data));
                        continue block7;
                    }
                    case 2: {
                        this.reply[this.replyOffset++] = 1;
                        this.putByte(Byte.valueOf(opt.data));
                        continue block7;
                    }
                    case 1: {
                        this.reply[this.replyOffset++] = 4;
                        this.putIP4(opt.data);
                    }
                }
            }
            this.reply[this.replyOffset++] = -1;
            this.sendReply(this.reply, this.replyOffset, rip);
        }

        private byte getByte() {
            return this.req[this.reqOffset++];
        }

        private short getShort() {
            short value = (short)BE.getuint16(this.req, this.reqOffset);
            this.reqOffset += 2;
            return value;
        }

        private int getInt() {
            int value = BE.getuint32(this.req, this.reqOffset);
            this.reqOffset += 4;
            return value;
        }

        private void getBytes(byte[] out) {
            for (int a = 0; a < out.length; ++a) {
                out[a] = this.getByte();
            }
        }

        private void putByteArray(byte[] ba) {
            for (int a = 0; a < ba.length; ++a) {
                this.reply[this.replyOffset++] = ba[a];
            }
        }

        private void putIP4(String ip) {
            String[] p = ip.split("[.]");
            for (int a = 0; a < 4; ++a) {
                this.reply[this.replyOffset++] = (byte)JF.atoi(p[a]);
            }
        }

        private void putIP6(String ip) {
            String[] p = ip.split(":");
            for (int a = 0; a < 8; ++a) {
                this.putShort((short)JF.atox(p[a]));
            }
        }

        private void putByte(byte value) {
            this.reply[this.replyOffset++] = value;
        }

        private void putShort(short value) {
            BE.setuint16(this.reply, this.replyOffset, value);
            this.replyOffset += 2;
        }

        private void putInt(int value) {
            BE.setuint32(this.reply, this.replyOffset, value);
            this.replyOffset += 4;
        }
    }

    static enum Section {
        None,
        Global,
        Pool;

    }

    private class HostWorker
    extends Thread {
        private Host host;

        public HostWorker(Host host) {
            this.host = host;
        }

        @Override
        public void run() {
            JFLog.log("DHCP starting on : " + this.host.ip + ":" + this.host.port + "...");
            try {
                this.host.ds = new DatagramSocket(this.host.port, Inet4Address.getByName(this.host.ip));
                while (true) {
                    byte[] data = new byte[maxmtu];
                    DatagramPacket packet = new DatagramPacket(data, maxmtu);
                    this.host.ds.receive(packet);
                    new RequestWorker(packet, this.host).start();
                }
            }
            catch (SocketException e) {
                if (DHCPServer.this.server != null && DHCPServer.this.server.active) {
                    JFLog.log(e);
                }
            }
            catch (Exception e) {
                JFLog.log(e);
            }
        }

        public void close() {
            try {
                this.host.ds.close();
                this.host.ds = null;
            }
            catch (Exception e) {
                JFLog.log(e);
            }
        }
    }
}

