/*
 * Decompiled with CFR 0.152.
 */
package javaforce.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class updatedesktopdatabase {
    public static ArrayList<ActionGroup> actionsList = new ArrayList();
    public static boolean recursive = true;

    public static void main(String[] args) {
        String folderPath = "/usr/share/applications";
        for (int a = 0; a < args.length; ++a) {
            if (args[a].equals("--no-recursive")) {
                recursive = false;
                continue;
            }
            if (args[a].startsWith("-")) continue;
            if (args[a].equals("--help")) {
                System.out.println("usage : update-desktop-database <folder> [--no-recursive]");
                System.exit(0);
            }
            folderPath = args[a];
        }
        File folder = new File(folderPath);
        updatedesktopdatabase.parseFolder(folder);
        updatedesktopdatabase.writeCache(folder);
    }

    public static void parseFolder(File folder) {
        try {
            File[] files = folder.listFiles();
            for (int f = 0; f < files.length; ++f) {
                String[] mimes;
                String ln;
                if (files[f].isDirectory()) {
                    if (!recursive) continue;
                    updatedesktopdatabase.parseFolder(files[f]);
                    continue;
                }
                String name = files[f].getName();
                if (!name.endsWith(".desktop")) continue;
                FileInputStream fis = new FileInputStream(files[f]);
                BufferedReader br = new BufferedReader(new InputStreamReader(fis));
                String mimetype = null;
                String action = null;
                while ((ln = br.readLine()) != null) {
                    if (ln.startsWith("MimeType=")) {
                        mimetype = ln.substring(9).trim();
                    }
                    if (!ln.startsWith("Action=")) continue;
                    action = ln.substring(7).trim().toLowerCase();
                }
                if (mimetype == null || mimetype.length() == 0 || (mimes = mimetype.split(";")).length == 0) continue;
                if (action == null) {
                    action = "open";
                }
                String[] actions = action.split(",");
                for (int m = 0; m < mimes.length; ++m) {
                    for (int a = 0; a < actions.length; ++a) {
                        updatedesktopdatabase.add(mimes[m], actions[a], folder.getAbsolutePath(), files[f].getAbsolutePath());
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void add(String mime, String action, String folder, String desktop) {
        if (!((String)folder).endsWith("/")) {
            folder = (String)folder + "/";
        }
        int idx = -1;
        if (desktop.endsWith("/audacity.desktop")) {
            action = "edit";
        }
        for (int a = 0; a < actionsList.size(); ++a) {
            if (!updatedesktopdatabase.actionsList.get((int)a).action.equals(action)) continue;
            idx = a;
            break;
        }
        ActionGroup agroup = null;
        if (idx == -1) {
            agroup = new ActionGroup();
            agroup.action = action;
            actionsList.add(agroup);
        } else {
            agroup = actionsList.get(idx);
        }
        idx = -1;
        for (int m = 0; m < agroup.mimeList.size(); ++m) {
            if (!agroup.mimeList.get((int)m).mime.equals(mime)) continue;
            idx = m;
            break;
        }
        MimeGroup mgroup = null;
        if (idx == -1) {
            mgroup = new MimeGroup();
            mgroup.mime = mime;
            agroup.mimeList.add(mgroup);
        } else {
            mgroup = agroup.mimeList.get(idx);
        }
        mgroup.desktopsList.add(desktop.substring(((String)folder).length()));
    }

    public static void writeCache(File folder) {
        File cache = new File(folder.getAbsolutePath() + "/mimeinfo.cache");
        try {
            FileOutputStream fos = new FileOutputStream(cache);
            for (int a = 0; a < actionsList.size(); ++a) {
                ActionGroup agroup = actionsList.get(a);
                fos.write(("[" + agroup.action + "]\n").getBytes());
                for (int m = 0; m < agroup.mimeList.size(); ++m) {
                    MimeGroup mgroup = agroup.mimeList.get(m);
                    fos.write((mgroup.mime + "=").getBytes());
                    for (int d = 0; d < mgroup.desktopsList.size(); ++d) {
                        if (d > 0) {
                            fos.write(";".getBytes());
                        }
                        fos.write(mgroup.desktopsList.get(d).getBytes());
                    }
                    fos.write("\n".getBytes());
                }
            }
            fos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class ActionGroup {
        public String action;
        public ArrayList<MimeGroup> mimeList = new ArrayList();
    }

    public static class MimeGroup {
        public String mime;
        public ArrayList<String> desktopsList = new ArrayList();
    }
}

