/*
 * Decompiled with CFR 0.152.
 */
package javaforce.webui;

import javaforce.webui.Icon;
import javaforce.webui.Image;
import javaforce.webui.Resource;
import javaforce.webui.TextComponent;

public class Button
extends TextComponent {
    protected String url;
    protected Image img;
    protected Icon icon;

    public Button(String text) {
        this.text = text;
        this.setClass("button");
    }

    public Button(Resource img) {
        this.img = new Image(img);
        this.add(this.img);
        this.setClass("button");
    }

    public Button(Icon icon) {
        this.icon = icon;
        this.add(this.icon);
        this.setClass("button");
    }

    public Button(Resource img, String text) {
        this.img = new Image(img);
        this.add(this.img);
        this.text = text;
        this.setClass("button");
    }

    public Button(Icon icon, String text) {
        this.icon = icon;
        this.add(this.icon);
        this.text = text;
        this.setClass("button");
    }

    @Override
    public String html() {
        StringBuilder html = new StringBuilder();
        html.append("<button" + this.getAttrs() + ">");
        html.append(this.innerHTML());
        html.append("</button>");
        return html.toString();
    }

    public String innerHTML() {
        StringBuilder html = new StringBuilder();
        if (this.img != null) {
            html.append(this.img.html());
        }
        if (this.icon != null) {
            html.append(this.icon.html());
        }
        if (this.text != null) {
            html.append(this.text);
        }
        return html.toString();
    }

    @Override
    public void update() {
        this.sendEvent("sethtml", new String[]{"html=" + this.innerHTML()});
    }

    public void setURL(String url) {
        this.addEvent("onclick", "window.open(\"" + url + "\");");
        this.url = url;
    }

    public String getURL() {
        return this.url;
    }

    public void setImage(Resource img) {
        this.img.setImage(img);
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
        this.update();
    }
}

