/*
 * Decompiled with CFR 0.152.
 */
package javaforce;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import javaforce.Condition;
import javaforce.Console;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.KeyMgmt;
import javaforce.RelayStream;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.channel.ClientChannel;
import org.apache.sshd.client.channel.PtyCapableChannelSession;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.future.CancelOption;

public class SSH {
    public static final int TYPE_SHELL = 0;
    public static final int TYPE_EXEC = 1;
    public static final int TYPE_SUBSYSTEM = 2;
    public static boolean debug = false;
    private SshClient client;
    private ClientSession session;
    private ClientChannel channel;
    private PtyCapableChannelSession pty;
    private InputStream in;
    private OutputStream out;
    private Object[] pipes;

    public boolean connect(String host, int port, Options options) {
        if (!debug) {
            JFLog.setEnabled(1, false);
            JFLog.setEnabled(2, false);
            JFLog.setEnabled(3, false);
            JFLog.setEnabled(4, false);
        }
        try {
            this.client = SshClient.setUpDefaultClient();
            this.client.start();
            ConnectFuture cf = this.client.connect(options.username, host, port);
            this.session = (ClientSession)((ConnectFuture)cf.verify(new CancelOption[0])).getSession();
            if (options.password != null) {
                this.session.addPasswordIdentity(options.password);
            } else {
                this.session.addPublicKeyIdentity(options.keys.getKeyPair(options.keyalias, options.keypass));
            }
            this.session.auth().verify(30000L, new CancelOption[0]);
            switch (options.type) {
                case 0: {
                    this.pty = this.session.createShellChannel();
                    this.channel = this.pty;
                    break;
                }
                case 1: {
                    this.pty = this.session.createExecChannel(options.command);
                    this.channel = this.pty;
                    break;
                }
            }
            this.pipes = this.createPipes();
            if (this.pipes == null) {
                return false;
            }
            this.out = (OutputStream)this.pipes[1];
            this.channel.setIn((InputStream)this.pipes[0]);
            this.pipes = this.createPipes();
            if (this.pipes == null) {
                return false;
            }
            this.in = (InputStream)this.pipes[0];
            this.channel.setOut((OutputStream)this.pipes[1]);
            this.channel.open();
            return true;
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    public void disconnect() {
        try {
            if (this.channel != null) {
                this.channel.close();
                this.channel = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.session != null) {
                this.session.close();
                this.session = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.client != null) {
                this.client.close();
                this.client = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.out != null) {
                this.out.close();
                this.out = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.in != null) {
                this.in.close();
                this.in = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isConnected() {
        return this.client.isOpen();
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public InputStream getInputStream() {
        return this.in;
    }

    public void setSize(int cols, int rows) {
        try {
            this.pty.sendWindowChange(cols, rows);
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    public String getOutput() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Condition connected = () -> this.isConnected();
        RelayStream rs2 = new RelayStream(this.getInputStream(), baos, connected);
        rs2.start();
        try {
            rs2.join();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new String(baos.toByteArray());
    }

    public String script(String[] cmds) {
        return this.script(cmds, 60000);
    }

    public String script(String[] cmds, int timeout) {
        InputStream is = this.getInputStream();
        OutputStream os = this.getOutputStream();
        Timer timer = null;
        if (timeout > 0) {
            timer = new Timer();
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    if (SSH.this.client != null) {
                        SSH.this.disconnect();
                    }
                }
            }, timeout);
        }
        try {
            int read;
            for (String cmd : cmds) {
                if (debug) {
                    JFLog.log(cmd);
                }
                os.write(cmd.getBytes());
                os.write("\r\n".getBytes());
            }
            StringBuilder sb = new StringBuilder();
            byte[] data = new byte[1024];
            while (this.isConnected()) {
                read = is.read(data);
                if (debug) {
                    JFLog.log("read=" + read);
                }
                if (read == -1) break;
                if (read <= 0) continue;
                sb.append(new String(data, 0, read));
            }
            while (is.available() > 0) {
                read = is.read(data);
                if (debug) {
                    JFLog.log("read=" + read);
                }
                if (read == -1) break;
                if (read <= 0) continue;
                sb.append(new String(data, 0, read));
            }
            this.disconnect();
            if (timer != null) {
                timer.cancel();
            }
            return sb.toString();
        }
        catch (Exception e) {
            JFLog.log(e);
            if (timer != null) {
                timer.cancel();
            }
            return null;
        }
    }

    private Object[] createPipes() {
        Object[] ret = new Object[2];
        try {
            ret[0] = new PipedInputStream();
            ret[1] = new PipedOutputStream((PipedInputStream)ret[0]);
            return ret;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void usage() {
        System.out.println("jfssh [user@]host[:port] [-p port]");
        System.exit(1);
    }

    public static void error(String msg) {
        System.out.println("Error:" + msg);
        System.exit(2);
    }

    private static void output(String file, String output) {
        try {
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(output.getBytes());
            fos.close();
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    public static void main(String[] args) {
        String dest = null;
        int port = 22;
        String outfile = null;
        ArrayList<String> cmd = new ArrayList<String>();
        String argtype = null;
        boolean script = false;
        for (String arg : args) {
            if (argtype != null) {
                switch (argtype) {
                    case "-p": {
                        port = Integer.valueOf(arg);
                        break;
                    }
                    case "-o": {
                        outfile = arg;
                    }
                }
                argtype = null;
                continue;
            }
            if (arg.startsWith("-")) {
                switch (arg) {
                    case "-p": {
                        argtype = arg;
                        break;
                    }
                    case "-o": {
                        argtype = arg;
                        break;
                    }
                    case "-s": {
                        script = true;
                        break;
                    }
                    case "-debug": {
                        debug = true;
                        break;
                    }
                    default: {
                        SSH.usage();
                        break;
                    }
                }
                continue;
            }
            if (dest == null) {
                dest = arg;
                continue;
            }
            cmd.add(arg);
        }
        if (dest == null) {
            SSH.usage();
        }
        String user = null;
        String host = null;
        int idx = dest.indexOf(64);
        if (idx == -1) {
            host = dest;
        } else {
            user = dest.substring(0, idx);
            host = dest.substring(idx + 1);
        }
        idx = host.indexOf(58);
        if (idx != -1) {
            port = Integer.valueOf(host.substring(idx + 1));
            host = host.substring(0, idx);
        }
        System.out.print("Enter Password:");
        String pass = new String(System.console().readPassword());
        SSH ssh = new SSH();
        Options opts = new Options();
        opts.username = user;
        opts.password = pass;
        if (cmd.size() > 0 && !script) {
            StringBuilder command = new StringBuilder();
            for (String str : cmd) {
                if (command.length() > 0) {
                    command.append(" ");
                }
                command.append(str);
            }
            opts.command = command.toString();
            opts.type = 1;
        }
        if (!ssh.connect(host, port, opts)) {
            SSH.error("Connection failed");
        }
        Condition connected = () -> {
            boolean conn = ssh.isConnected();
            if (debug) {
                JFLog.log("isConnected=" + conn);
            }
            return conn;
        };
        if (debug) {
            RelayStream.debug = true;
        }
        switch (opts.type) {
            case 0: {
                String output;
                if (script) {
                    output = ssh.script(cmd.toArray(JF.StringArrayType));
                    System.out.println(output);
                    if (outfile == null) break;
                    SSH.output(outfile, output);
                    break;
                }
                RelayStream rs1 = new RelayStream(Console.getInputStream(), ssh.getOutputStream(), connected);
                RelayStream rs2 = new RelayStream(ssh.getInputStream(), Console.getOutputStream(), connected);
                rs1.start();
                rs2.start();
                try {
                    rs1.join();
                    rs2.join();
                }
                catch (Exception exception) {}
                break;
            }
            case 1: {
                String output = ssh.getOutput();
                if (outfile != null) {
                    SSH.output(outfile, output);
                }
                System.out.print(output);
            }
        }
        ssh.disconnect();
    }

    public static class Options {
        public int type;
        public String username;
        public String password;
        public KeyMgmt keys;
        public String keyalias;
        public String keypass;
        public String command;
    }
}

