/*
 * Decompiled with CFR 0.152.
 */
package javaforce.awt;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Random;
import javaforce.JFLog;
import javaforce.awt.JFAWT;
import javaforce.awt.JFImage;
import javaforce.awt.VNCServer;
import javaforce.awt.ViewLog;
import javaforce.jbus.JBusClient;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;

public class VNCApp
extends JFrame {
    private static boolean debug = false;
    private JButton bStatus;
    private JButton bViewLog;
    private JTextArea config;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JButton save;
    public ViewLog viewLog;
    public ViewLog viewStatus;
    public JBusClient busClient;

    public VNCApp() {
        this.initComponents();
        JFImage img = new JFImage();
        img.loadPNG(this.getClass().getResourceAsStream("/javaforce/icons/vnc.png"));
        new Thread(){

            @Override
            public void run() {
                Random r = new Random();
                VNCApp.this.busClient = new JBusClient("net.sf.jfvnc.client" + r.nextInt(), new JBusMethods());
                VNCApp.this.busClient.setPort(VNCServer.getBusPort());
                VNCApp.this.busClient.start();
                VNCApp.this.busClient.call("net.sf.jfvnc", "getConfig", JBusClient.quote(VNCApp.this.busClient.pack));
            }
        }.start();
        JFAWT.centerWindow(this);
    }

    public void writeConfig() {
        this.busClient.call("net.sf.jfvnc", "setConfig", JBusClient.quote(JBusClient.encodeString(this.config.getText())));
    }

    public void restart() {
        this.busClient.call("net.sf.jfvnc", "restart", "");
    }

    private void initComponents() {
        this.save = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.config = new JTextArea();
        this.jLabel1 = new JLabel();
        this.bViewLog = new JButton();
        this.bStatus = new JButton();
        this.setDefaultCloseOperation(3);
        this.setTitle("VNC Server");
        this.save.setText("Save");
        this.save.setEnabled(false);
        this.save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VNCApp.this.saveActionPerformed(evt);
            }
        });
        this.config.setColumns(20);
        this.config.setRows(5);
        this.config.setText(" [ loading ... ]");
        this.config.setEnabled(false);
        this.jScrollPane1.setViewportView(this.config);
        this.jLabel1.setText("VNC Configuration:");
        this.bViewLog.setText("View Log");
        this.bViewLog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VNCApp.this.bViewLogActionPerformed(evt);
            }
        });
        this.bStatus.setText("Status");
        this.bStatus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VNCApp.this.bStatusActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 583, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.bViewLog).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bStatus).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.save)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 424, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.save).addComponent(this.bViewLog).addComponent(this.bStatus)).addContainerGap()));
        this.pack();
    }

    private void saveActionPerformed(ActionEvent evt) {
        this.writeConfig();
        this.restart();
        JFAWT.showMessage("Notice", "Settings saved!");
    }

    private void bViewLogActionPerformed(ActionEvent evt) {
        this.showViewLog();
    }

    private void bStatusActionPerformed(ActionEvent evt) {
        this.showViewStatus();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new VNCApp().setVisible(true);
            }
        });
    }

    public void showViewLog() {
        if (this.viewLog == null || this.viewLog.isClosed) {
            this.viewLog = new ViewLog(new File(VNCServer.getLogFile()));
            this.viewLog.setTitle("VNC Log");
        }
        this.viewLog.setVisible(true);
    }

    public void showViewStatus() {
        if (this.viewStatus == null || this.viewStatus.isClosed()) {
            this.viewStatus = new ViewLog("loading");
            this.viewStatus.setTitle("VNC Status");
            this.viewStatus.setRefresh(new Runnable(){

                @Override
                public void run() {
                    VNCApp.this.requestStatus();
                }
            });
            this.requestStatus();
            this.viewStatus.setVisible(true);
        }
    }

    public void requestStatus() {
        this.busClient.call("net.sf.jfvnc", "getStatus", JBusClient.quote(this.busClient.pack));
    }

    public class JBusMethods {
        public void getConfig(String cfg) {
            final String _cfg = cfg;
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    VNCApp.this.config.setText(JBusClient.decodeString(_cfg));
                    VNCApp.this.config.setEnabled(true);
                    VNCApp.this.save.setEnabled(true);
                }
            });
        }

        public void getStatus(String status) {
            if (debug) {
                JFLog.log("gotStatus=" + status);
            }
            status = JBusClient.decodeString(status);
            if (VNCApp.this.viewStatus != null) {
                VNCApp.this.viewStatus.setText(status);
            }
        }
    }
}

