/*
 * Decompiled with CFR 0.152.
 */
package javaforce.media;

import javaforce.JFLog;
import javaforce.media.MediaAudioEncoder;
import javaforce.media.MediaFormat;
import javaforce.media.MediaIO;
import javaforce.media.MediaVideoEncoder;
import javaforce.voip.CodecInfo;
import javaforce.voip.Packet;

public class MediaOutput
extends MediaFormat {
    private boolean header;

    private static native long ncreateFile(String var0, String var1);

    public boolean create(String file, String format) {
        if (this.ctx != 0L) {
            return false;
        }
        this.ctx = MediaOutput.ncreateFile(file, format);
        if (this.ctx == 0L) {
            JFLog.log("MediaOutput.ncreateFile() == 0");
        }
        return this.ctx != 0L;
    }

    private static native long ncreateIO(MediaIO var0, String var1);

    public boolean create(MediaIO io, String format) {
        if (this.ctx != 0L) {
            return false;
        }
        this.ctx = MediaOutput.ncreateIO(io, format);
        if (this.ctx == 0L) {
            JFLog.log("MediaOutput.ncreateIO() == 0");
        }
        return this.ctx != 0L;
    }

    private static native int naddVideoStream(long var0, int var2, int var3, int var4, int var5, float var6, int var7);

    public boolean addVideoStream(CodecInfo info) {
        info.video_stream = MediaOutput.naddVideoStream(this.ctx, info.video_codec, info.video_bit_rate, info.width, info.height, info.fps, info.keyFrameInterval);
        if (info.video_stream == -1) {
            JFLog.log("addVideoStream == -1");
            return false;
        }
        if (info.video_codec == 0) {
            info.video_codec = this.getVideoCodecID();
        }
        return true;
    }

    private static native int naddAudioStream(long var0, int var2, int var3, int var4, int var5);

    public boolean addAudioStream(CodecInfo info) {
        info.audio_stream = MediaOutput.naddAudioStream(this.ctx, info.audio_codec, info.audio_bit_rate, info.chs, info.freq);
        if (info.audio_stream == -1) {
            JFLog.log("addAudioStream == -1");
            return false;
        }
        if (info.audio_codec == 0) {
            info.audio_codec = this.getAudioCodecID();
        }
        return true;
    }

    public MediaVideoEncoder createVideoEncoder(CodecInfo info) {
        if (!this.addVideoStream(info)) {
            return null;
        }
        MediaVideoEncoder encoder = new MediaVideoEncoder(this);
        encoder.setStream(info.video_stream);
        return encoder;
    }

    public MediaAudioEncoder createAudioEncoder(CodecInfo info) {
        if (!this.addAudioStream(info)) {
            return null;
        }
        MediaAudioEncoder encoder = new MediaAudioEncoder(this);
        encoder.setStream(info.audio_stream);
        return encoder;
    }

    private static native boolean nclose(long var0);

    public boolean close() {
        if (this.ctx == 0L) {
            return false;
        }
        boolean res = MediaOutput.nclose(this.ctx);
        this.ctx = 0L;
        return res;
    }

    private static native boolean nwriteHeader(long var0);

    private static native boolean nwritePacket(long var0, int var2, byte[] var3, int var4, int var5, boolean var6);

    public boolean writePacket(Packet packet) {
        if (!this.header) {
            MediaOutput.nwriteHeader(this.ctx);
            this.header = true;
        }
        return MediaOutput.nwritePacket(this.ctx, packet.stream, packet.data, packet.offset, packet.length, packet.keyFrame);
    }
}

