/*
 * Decompiled with CFR 0.152.
 */
package javaforce.tests.webui;

import java.awt.Color;
import java.awt.Font;
import java.util.Timer;
import java.util.TimerTask;
import javaforce.HTTP;
import javaforce.LE;
import javaforce.awt.JFImage;
import javaforce.gl.Matrix;
import javaforce.service.WebRequest;
import javaforce.service.WebResponse;
import javaforce.webui.Canvas;
import javaforce.webui.Panel;
import javaforce.webui.WebUIClient;
import javaforce.webui.WebUIHandler;
import javaforce.webui.WebUIServer;

public class TestGLCube
implements WebUIHandler {
    private static String vs = "  attribute vec3 aVertexPosition;\n  attribute vec2 aTextureCoord;\n\n  uniform mat4 uPMatrix;\n  uniform mat4 uMVMatrix;\n\n  varying highp vec2 vTextureCoord;\n\n  void main(void) {\n    gl_Position = uPMatrix * uMVMatrix * vec4(aVertexPosition, 1.0);\n    vTextureCoord = aTextureCoord;\n  }\n";
    private static String fs = "  varying highp vec2 vTextureCoord;\n\n  uniform sampler2D uSampler;\n  void main(void) {\n    gl_FragColor = texture2D(uSampler, vec2(vTextureCoord.s, vTextureCoord.t));\n  }\n";
    private static float[] vertices = new float[]{1.0f, -1.0f, 0.0f, -1.0f, -1.0f, 0.0f, 1.0f, 1.0f, 0.0f, -1.0f, 1.0f, 0.0f};
    private static float[] textCoords = new float[]{1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f};

    public static void main(String[] args) {
        new WebUIServer().start(new TestGLCube(), 8080);
    }

    @Override
    public void clientConnected(WebUIClient client) {
        Context context = new Context(client);
        client.setProperty("context", context);
    }

    @Override
    public void clientDisconnected(WebUIClient client) {
        Context context = (Context)client.getProperty("context");
        context.close();
        System.exit(0);
    }

    @Override
    public byte[] getResource(String url, HTTP.Parameters params, WebRequest request, WebResponse res) {
        return null;
    }

    public static byte[] convertFloatArray(float[] m) {
        byte[] data = new byte[m.length * 4];
        int off = 0;
        for (int a = 0; a < m.length; ++a) {
            LE.setuint32(data, off, Float.floatToIntBits(m[a]));
            off += 4;
        }
        return data;
    }

    public static byte[] convertIntArray(int[] i) {
        byte[] data = new byte[i.length * 4];
        int offset = 0;
        for (int a = 0; a < i.length; ++a) {
            int num = i[a];
            data[offset + 2] = (byte)(num & 0xFF);
            data[offset + 1] = (byte)((num >>= 8) & 0xFF);
            data[offset + 0] = (byte)((num >>= 8) & 0xFF);
            data[offset + 3] = (byte)((num >>= 8) & 0xFF);
            offset += 4;
        }
        return data;
    }

    @Override
    public Panel getPanel(String name, HTTP.Parameters params, WebUIClient client) {
        Panel panel = new Panel(){

            @Override
            public void onLoaded(String[] args) {
                Context context = (Context)this.client.getProperty("context");
                context.send();
            }
        };
        Canvas canvas = new Canvas();
        canvas.setSize(640, 480);
        panel.add(canvas);
        client.setProperty("canvas", canvas);
        return panel;
    }

    public static class Context
    extends TimerTask {
        public WebUIClient client;
        public Matrix pMatrix;
        public Matrix mMatrix;
        public Timer timer;
        public Canvas canvas;

        public Context(WebUIClient client) {
            this.client = client;
        }

        @Override
        public void run() {
            Canvas canvas = (Canvas)this.client.getProperty("canvas");
            this.mMatrix.addRotate(5.0f, 1.0f, 0.0f, 0.0f);
            this.mMatrix.addRotate(10.0f, 0.0f, 1.0f, 0.0f);
            this.mMatrix.addRotate(3.0f, 0.0f, 0.0f, 1.0f);
            canvas.sendData(TestGLCube.convertFloatArray(this.mMatrix.m));
            canvas.sendEvent("matrix", new String[]{"idx=1"});
        }

        public void send() {
            this.pMatrix = new Matrix();
            this.pMatrix.perspective(45.0f, 1.3333334f, 0.1f, 100.0f);
            this.mMatrix = new Matrix();
            this.mMatrix.addTranslate(0.0f, 0.0f, -4.0f);
            this.canvas = (Canvas)this.client.getProperty("canvas");
            this.canvas.sendEvent("initwebgl", null);
            this.canvas.sendEvent("loadvs", new String[]{"src=" + vs});
            this.canvas.sendEvent("loadfs", new String[]{"src=" + fs});
            this.canvas.sendEvent("link", null);
            this.canvas.sendEvent("getuniform", new String[]{"idx=0", "name=uPMatrix"});
            this.canvas.sendEvent("getuniform", new String[]{"idx=1", "name=uMVMatrix"});
            this.canvas.sendEvent("getattrib", new String[]{"idx=0", "name=aVertexPosition"});
            this.canvas.sendEvent("getattrib", new String[]{"idx=1", "name=aTextureCoord"});
            this.canvas.sendData(TestGLCube.convertFloatArray(this.pMatrix.m));
            this.canvas.sendEvent("matrix", new String[]{"idx=0"});
            this.canvas.sendData(TestGLCube.convertFloatArray(this.mMatrix.m));
            this.canvas.sendEvent("matrix", new String[]{"idx=1"});
            this.canvas.sendData(TestGLCube.convertFloatArray(vertices));
            this.canvas.sendEvent("buffer", new String[]{"idx=0"});
            this.canvas.sendData(TestGLCube.convertFloatArray(textCoords));
            this.canvas.sendEvent("buffer", new String[]{"idx=1"});
            JFImage img = new JFImage(256, 256);
            img.fill(0, 0, 256, 256, 0xFFFFFF);
            img.setFont(new Font("Dialog", 0, 40));
            img.getGraphics().setColor(Color.BLACK);
            img.getGraphics().drawBytes("WebGL".getBytes(), 0, 5, 50, 100);
            this.canvas.sendData(TestGLCube.convertIntArray(img.getBuffer()));
            this.canvas.sendEvent("loadt", new String[]{"idx=0", "x=" + img.getWidth(), "y=" + img.getHeight()});
            this.canvas.sendEvent("array", new String[]{"idx=0"});
            this.canvas.sendEvent("array", new String[]{"idx=1"});
            this.canvas.sendEvent("array", new String[]{"idx=2"});
            this.canvas.sendEvent("r_matrix", new String[]{"idx=0", "uidx=0", "midx=0"});
            this.canvas.sendEvent("r_matrix", new String[]{"idx=0", "uidx=1", "midx=1"});
            this.canvas.sendEvent("r_attrib", new String[]{"idx=0", "aidx=0", "bufidx=0", "cnt=3"});
            this.canvas.sendEvent("r_attrib", new String[]{"idx=1", "aidx=1", "bufidx=1", "cnt=2"});
            this.canvas.sendEvent("r_bindt", new String[]{"idx=2", "tidx=0"});
            this.canvas.sendEvent("r_drawArrays", new String[]{"idx=2", "type=5", "cnt=4"});
            this.timer = new Timer();
            this.timer.schedule((TimerTask)this, 100L, 100L);
        }

        public void close() {
            this.timer.cancel();
        }
    }
}

