/*
 * Decompiled with CFR 0.152.
 */
package javaforce.utils;

import java.io.File;
import java.io.FileInputStream;
import javaforce.JF;
import javaforce.linux.Linux;

public class OpenFile {
    private static String mimetypes;

    public static void main(String[] args) {
        String file;
        if (args.length < 1 || args[0].length() == 0) {
            System.out.println("usage : jfopen file\ndesc : open program associated with file type");
            return;
        }
        String action = "open";
        if (args[0].equals("--edit")) {
            action = "edit";
            file = args[1];
        } else {
            file = args[0];
        }
        try {
            OpenFile.openFile(file, action);
        }
        catch (Exception e) {
            System.out.println(String.valueOf(e));
        }
    }

    public static void openFile(String file, String action) throws Exception {
        int idx = file.lastIndexOf(".");
        if (idx == -1) {
            throw new Exception("file has no extension");
        }
        String ext = file.substring(idx + 1);
        String mime = OpenFile.getMimeType(ext);
        if (mime == null) {
            throw new Exception("mime-type not found");
        }
        String desktop = OpenFile.getHandler(mime, action);
        if (desktop == null) {
            if (!action.equals("open")) {
                desktop = OpenFile.getHandler(mime, "open");
            }
            if (desktop == null) {
                throw new Exception("handler not found");
            }
        }
        Linux.executeDesktop(desktop, new String[]{file});
    }

    public static String getMimeType(String ext) throws Exception {
        if (mimetypes == null) {
            FileInputStream fis = new FileInputStream("/etc/mime.types");
            byte[] data = JF.readAll(fis);
            fis.close();
            mimetypes = new String(data);
        }
        String[] lns = mimetypes.split("\n");
        for (int a = 0; a < lns.length; ++a) {
            String[] f = lns[a].split("\t+");
            if (f.length < 2) continue;
            String[] exts = f[1].split(" ");
            for (int b = 0; b < exts.length; ++b) {
                if (!exts[b].equalsIgnoreCase(ext)) continue;
                return f[0];
            }
        }
        return null;
    }

    public static String getHandler(String mime, String action) throws Exception {
        String desktop = OpenFile.getDesktop(mime, "/usr/share/applications", action);
        if (desktop != null) {
            return desktop;
        }
        return OpenFile.getDesktop(mime, JF.getUserPath() + "/.local/share/applications", action);
    }

    public static String getIcon(String mime, String action) throws Exception {
        String desktop = OpenFile.getDesktop(mime, "/usr/share/applications", action);
        if (desktop == null && (desktop = OpenFile.getDesktop(mime, JF.getUserPath() + "/.local/share/applications", action)) == null) {
            return null;
        }
        FileInputStream fis = new FileInputStream(desktop);
        byte[] data = JF.readAll(fis);
        fis.close();
        String str = new String(data);
        String[] lns = str.split("\n");
        for (int a = 0; a < lns.length; ++a) {
            if (!lns[a].startsWith("Icon=")) continue;
            return lns[a].substring(5).trim();
        }
        return null;
    }

    public static String getDesktop(String mime, String folder, String action) throws Exception {
        File file = new File(folder + "/mimeinfo.cache");
        if (!file.exists()) {
            return null;
        }
        FileInputStream fis = new FileInputStream(file);
        byte[] data = JF.readAll(fis);
        fis.close();
        String str = new String(data);
        String[] lns = str.split("\n");
        String cacheAction = "open";
        for (int a = 0; a < lns.length; ++a) {
            String[] desktops;
            int idx;
            String ln = lns[a].trim();
            if (ln.startsWith("[") || ln.endsWith("]")) {
                cacheAction = ln.substring(1, ln.length() - 1);
                continue;
            }
            if (!cacheAction.equals(action) || (idx = lns[a].indexOf("=")) == -1 || !lns[a].substring(0, idx).equals(mime) || (desktops = lns[a].substring(idx + 1).trim().split(";")) == null || desktops.length == 0) continue;
            return folder + "/" + desktops[0];
        }
        return null;
    }
}

