/*
 * Decompiled with CFR 0.152.
 */
package javaforce.voip;

import java.util.ArrayList;
import java.util.Random;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.STUN;
import javaforce.voip.Codec;
import javaforce.voip.Packet;
import javaforce.voip.RTPChannel;
import javaforce.voip.RTPInterface;
import javaforce.voip.SDP;
import javaforce.voip.SRTPChannel;
import javaforce.voip.Transport;
import javaforce.voip.TransportTCPClient;
import javaforce.voip.TransportType;
import javaforce.voip.TransportUDP;

public class RTP
implements STUN.Listener {
    private static int nextlocalrtpport = 32768;
    private static int rtpmin = 32768;
    private static int rtpmax = 65536;
    protected Transport sock1;
    protected Transport sock2;
    private Worker worker1;
    private Worker worker2;
    private int localrtpport;
    public volatile boolean active = false;
    protected RTPInterface iface;
    private int mtu = 1500;
    protected boolean rawMode;
    public ArrayList<RTPChannel> channels = new ArrayList();
    public static long now = 0L;
    private static boolean hasBouncyCastle;
    public int log;
    protected static boolean useTURN;
    protected static String turnHost;
    protected static String turnIP;
    protected static String turnUser;
    protected static String turnPass;
    protected STUN stun1;
    protected STUN stun2;
    protected byte[] turnToken;
    protected long turnAllocExpires;
    public Object userobj;
    public static boolean debug;
    public static final Codec CODEC_UNKNOWN;
    public static final Codec CODEC_G711u;
    public static final Codec CODEC_GSM;
    public static final Codec CODEC_G711a;
    public static final Codec CODEC_G722;
    public static final Codec CODEC_G729a;
    public static final Codec CODEC_JPEG;
    public static final Codec CODEC_H263;
    public static final Codec CODEC_RFC2833;
    public static final Codec CODEC_SPEEX;
    public static final Codec CODEC_SPEEX16;
    public static final Codec CODEC_SPEEX32;
    public static final Codec CODEC_VP8;
    public static final Codec CODEC_VP9;
    public static final Codec CODEC_H263_1998;
    public static final Codec CODEC_H263_2000;
    public static final Codec CODEC_OPUS;
    public static final Codec CODEC_H264;
    public static final Codec CODEC_H265;
    private boolean turnSuccess;
    private boolean turnFailed;
    protected volatile RTPChannel bindingChannel;
    protected final Object bindLock = new Object();
    Random r = new Random();

    public void setLog(int id) {
        this.log = id;
    }

    public static void enableTURN(String host, String user, String pass) {
        useTURN = true;
        turnHost = host;
        turnUser = user;
        turnPass = pass;
    }

    public static void disableTURN() {
        useTURN = false;
    }

    public static synchronized int getnextlocalrtpport() {
        int ret = nextlocalrtpport;
        if ((nextlocalrtpport += 2) + 1 > rtpmax) {
            nextlocalrtpport = rtpmin;
        }
        return ret;
    }

    public int getlocalrtpport() {
        if (useTURN) {
            return this.stun1.getPort();
        }
        return this.localrtpport;
    }

    @Override
    public void stunPublicIP(STUN stun, String ip, int port) {
    }

    @Override
    public void turnAlloc(STUN stun, String ip, int port, byte[] token, int lifetime) {
        this.turnToken = token;
        this.turnSuccess = true;
        turnIP = ip;
        this.turnAllocExpires = System.currentTimeMillis() + (long)(lifetime * 1000);
    }

    @Override
    public void turnBind(STUN stun) {
        this.turnSuccess = true;
        this.bindingChannel.turnBindExpires = System.currentTimeMillis() + 300000L;
    }

    @Override
    public void turnRefresh(STUN stun, int lifetime) {
        this.turnAllocExpires = System.currentTimeMillis() + (long)(lifetime * 1000);
    }

    @Override
    public void turnFailed(STUN stun) {
        this.turnFailed = true;
    }

    @Override
    public void turnData(STUN stun, byte[] data, int offset, int length, short turnChannel) {
        RTPChannel channel = this.findChannel(turnChannel);
        if (channel == null) {
            return;
        }
        if (stun == this.stun1) {
            channel.processRTP(data, offset, length);
        } else if (stun == this.stun2) {
            channel.processRTCP(data, offset, length);
        }
    }

    protected void wait4reset() {
        this.turnSuccess = false;
        this.turnFailed = false;
    }

    protected void wait4reply() throws Exception {
        for (int a = 0; a < 100; ++a) {
            JF.sleep(10);
            if (this.turnFailed) {
                throw new Exception("Turn failed");
            }
            if (!this.turnSuccess) continue;
            return;
        }
        throw new Exception("Turn timeout");
    }

    public boolean init(RTPInterface iface, TransportType type) {
        this.iface = iface;
        for (int a = 0; a < 5; ++a) {
            try {
                this.localrtpport = RTP.getnextlocalrtpport();
                if (useTURN) {
                    this.wait4reset();
                    this.stun1 = new STUN();
                    if (!this.stun1.start(this.localrtpport, turnHost, turnUser, turnPass, this)) {
                        throw new Exception("STUN init failed");
                    }
                    this.stun1.requestAlloc(true, null);
                    this.wait4reply();
                    if (this.turnToken == null) {
                        throw new Exception("Turn token missing");
                    }
                    JFLog.log(this.log, "RTP:TURN:host=" + this.stun1.getIP());
                    JFLog.log(this.log, "RTP:TURN:port=" + this.stun1.getPort());
                    this.wait4reset();
                    this.stun2 = new STUN();
                    if (!this.stun2.start(this.localrtpport + 1, turnHost, turnUser, turnPass, this)) {
                        throw new Exception("STUN init failed");
                    }
                    this.stun2.requestAlloc(false, this.turnToken);
                    this.wait4reply();
                    JFLog.log(this.log, "RTP:TURN:host=" + this.stun2.getIP());
                    JFLog.log(this.log, "RTP:TURN:port=" + this.stun2.getPort());
                } else {
                    switch (type) {
                        case UDP: {
                            this.sock1 = new TransportUDP();
                            this.sock2 = new TransportUDP();
                            break;
                        }
                        case TCP: {
                            this.sock1 = new TransportTCPClient();
                            this.sock2 = new TransportTCPClient();
                        }
                    }
                    this.sock1.open(null, this.localrtpport, null);
                    this.sock2.open(null, this.localrtpport + 1, null);
                    this.sock1.setReceiveBufferSize(0x1000000);
                }
                JFLog.log(this.log, "RTP:localport=" + this.localrtpport);
            }
            catch (Exception e2) {
                JFLog.log(this.log, (Throwable)e2);
                continue;
            }
            return true;
        }
        return false;
    }

    public boolean init(RTPInterface iface) {
        return this.init(iface, TransportType.UDP);
    }

    public void setReceiveBufferSize(int bytes) {
        if (this.sock1 == null) {
            return;
        }
        try {
            this.sock1.setReceiveBufferSize(bytes);
            this.sock2.setReceiveBufferSize(bytes);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setMTU(int mtu) {
        if (this.active) {
            return;
        }
        this.mtu = mtu;
    }

    protected short getNextTURNChannel() {
        return (short)(this.r.nextInt(16382) + 16384);
    }

    public boolean start() {
        now = System.currentTimeMillis();
        if (this.active) {
            return true;
        }
        this.active = true;
        if (!useTURN) {
            this.worker1 = new Worker(this, this.sock1, false);
            this.worker1.start();
            this.worker2 = new Worker(this, this.sock2, true);
            this.worker2.start();
        }
        return true;
    }

    public void stop() {
        if (!this.active) {
            return;
        }
        this.active = false;
        this.closeSockets();
        this.freeWorkers();
        if (useTURN) {
            if (this.stun1 != null) {
                this.stun1.requestRefresh(0);
                this.stun1.close();
                this.stun1 = null;
            }
            if (this.stun2 != null) {
                this.stun2.requestRefresh(0);
                this.stun2.close();
                this.stun2 = null;
            }
        }
        this.freeChannels();
    }

    private void freeWorkers() {
        if (this.worker1 != null) {
            try {
                this.worker1.join();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.worker1 = null;
        }
        if (this.worker2 != null) {
            try {
                this.worker2.join();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.worker2 = null;
        }
    }

    private void freeChannels() {
        while (this.channels.size() > 0) {
            RTPChannel channel = this.channels.remove(0);
            channel.stop();
        }
    }

    public void uninit() {
        this.stop();
    }

    private void closeSockets() {
        if (this.sock1 != null) {
            try {
                this.sock1.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.sock1 = null;
        }
        if (this.sock2 != null) {
            try {
                this.sock2.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.sock2 = null;
        }
    }

    public RTPChannel createChannel(SDP.Stream stream) {
        return this.createChannel(-1, stream);
    }

    public RTPChannel createChannel(int ssrc, SDP.Stream stream) {
        JFLog.log(this.log, "RTP.createChannel():remote=" + stream.getIP() + ":" + stream.port);
        if (stream.getIP() == null) {
            JFLog.log("RTP.createChannel():Error:remote == null");
            return null;
        }
        RTPChannel channel = null;
        switch (stream.profile) {
            case AVP: 
            case AVPF: {
                channel = new RTPChannel(this, ssrc, stream);
                break;
            }
            case SAVP: 
            case SAVPF: {
                if (!hasBouncyCastle) {
                    JFLog.log(this.log, "RTP:Couldn't create SRTPChannel");
                    return null;
                }
                channel = new SRTPChannel(this, ssrc, stream);
                break;
            }
            case UNKNOWN: {
                JFLog.log(this.log, "RTP:Can not create unknown profile");
                return null;
            }
        }
        channel.setLog(this.log);
        this.channels.add(channel);
        return channel;
    }

    public void removeChannel(RTPChannel channel) {
        channel.stop();
        this.channels.remove(channel);
    }

    public RTPChannel getDefaultChannel() {
        if (this.channels.size() == 0) {
            return null;
        }
        return this.channels.get(0);
    }

    public RTPChannel findChannel(short turnChannel) {
        for (int a = 0; a < this.channels.size(); ++a) {
            RTPChannel channel = this.channels.get(a);
            if (!channel.active) continue;
            if (channel.turn1ch == turnChannel) {
                return channel;
            }
            if (channel.turn2ch != turnChannel) continue;
            return channel;
        }
        return null;
    }

    public RTPChannel findChannel(String ip, int port) {
        for (int a = 0; a < this.channels.size(); ++a) {
            RTPChannel channel = this.channels.get(a);
            if (!channel.active || !channel.stream.getIP().equals(ip) || channel.stream.port != -1 && channel.stream.port != port) continue;
            return channel;
        }
        return null;
    }

    public static void setPortRange(int min, int max) {
        rtpmin = min;
        rtpmax = max;
        nextlocalrtpport = min;
    }

    public static void setServerPortRange() {
        RTP.setPortRange(32768, 49152);
    }

    public static void setClientPortRange() {
        RTP.setPortRange(49152, 65536);
    }

    public void keepalive() {
        if (!this.active) {
            return;
        }
        now = System.currentTimeMillis();
        if (useTURN && now + 75000L > this.turnAllocExpires) {
            this.stun1.requestRefresh(600);
            this.stun2.requestRefresh(600);
        }
        for (int a = 0; a < this.channels.size(); ++a) {
            RTPChannel channel = this.channels.get(a);
            channel.keepalive(now);
        }
    }

    public void setRawMode(boolean state) {
        this.rawMode = state;
    }

    public boolean getRawMode() {
        return this.rawMode;
    }

    public static String getTurnIP() {
        return turnIP;
    }

    public static String genIceufrag() {
        StringBuilder sb = new StringBuilder();
        Random r = new Random();
        for (int a = 0; a < 16; ++a) {
            sb.append((char)(97 + r.nextInt(26)));
        }
        return sb.toString();
    }

    public static String genIcepwd() {
        StringBuilder sb = new StringBuilder();
        Random r = new Random();
        for (int a = 0; a < 16; ++a) {
            sb.append((char)(97 + r.nextInt(26)));
        }
        return sb.toString();
    }

    public void setInterface(RTPInterface iface) {
        this.iface = iface;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("RTP:{localport=" + this.localrtpport + ",channels:{");
        for (RTPChannel ch : this.channels) {
            sb.append(ch.toString());
        }
        sb.append("}}");
        return sb.toString();
    }

    static {
        useTURN = false;
        debug = false;
        CODEC_UNKNOWN = new Codec("?");
        CODEC_G711u = new Codec("PCMU", 0, 8000);
        CODEC_GSM = new Codec("GSM", 3, 8000);
        CODEC_G711a = new Codec("PCMA", 8, 8000);
        CODEC_G722 = new Codec("G722", 9, 8000);
        CODEC_G729a = new Codec("G729", 18, 8000);
        CODEC_JPEG = new Codec("JPEG", 26);
        CODEC_H263 = new Codec("H263", 34);
        CODEC_RFC2833 = new Codec("telephone-event", 96);
        CODEC_SPEEX = new Codec("SPEEX", 97, 8000);
        CODEC_SPEEX16 = new Codec("SPEEX", 98, 16000);
        CODEC_SPEEX32 = new Codec("SPEEX", 99, 32000);
        CODEC_VP8 = new Codec("VP8", 100);
        CODEC_VP9 = new Codec("VP9", 101);
        CODEC_H263_1998 = new Codec("H263-1998", 110);
        CODEC_H263_2000 = new Codec("H263-2000", 111);
        CODEC_OPUS = new Codec("OPUS", 112, 48000);
        CODEC_H264 = new Codec("H264", 120);
        CODEC_H265 = new Codec("H265", 121);
        try {
            Class.forName("org.bouncycastle.tls.TlsServer");
            hasBouncyCastle = true;
        }
        catch (Exception e) {
            JFLog.log("Warning:BouncyCastle not found, SRTP/DTLS not available");
        }
    }

    private static class Worker
    extends Thread {
        private RTP rtp;
        private Transport sock;
        private boolean rtcp;

        public Worker(RTP rtp, Transport sock, boolean rtcp) {
            this.rtp = rtp;
            this.sock = sock;
            this.rtcp = rtcp;
        }

        @Override
        public void run() {
            this.setName("RTP.Worker:" + this.rtp.localrtpport);
            byte[] data = new byte[this.rtp.mtu];
            while (this.rtp.active) {
                try {
                    RTPChannel channel;
                    Packet pack = new Packet();
                    pack.data = data;
                    this.sock.receive(pack);
                    int len = pack.length;
                    if (len < 12) continue;
                    String remoteip = pack.host;
                    int remoteport = pack.port;
                    if (this.rtcp) {
                        channel = this.rtp.findChannel(remoteip, remoteport - 1);
                        if (channel == null) {
                            JFLog.log(this.rtp.log, "RTP:No channel found:" + remoteip + ":" + remoteport);
                            continue;
                        }
                        channel.processRTCP(data, 0, len);
                        continue;
                    }
                    channel = this.rtp.findChannel(remoteip, remoteport);
                    if (channel == null) {
                        JFLog.log(this.rtp.log, "RTP:No channel found:" + remoteip + ":" + remoteport);
                        continue;
                    }
                    if (channel.stream.port == -1) {
                        channel.stream.port = remoteport;
                        JFLog.log(this.rtp.log, "RTP : NAT port = " + channel.stream.getPort());
                    }
                    channel.processRTP(data, 0, len);
                }
                catch (Exception e) {
                    JFLog.log(this.rtp.log, (Throwable)e);
                    this.rtp.active = false;
                }
            }
        }
    }
}

